/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import com.google.common.collect.Ordering;
import fi.dy.masa.enderutilities.gui.client.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.GuiButtonIcon;
import fi.dy.masa.enderutilities.gui.client.GuiContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiHandyBag
extends GuiContainerLargeStacks {
    public static final int BTN_ID_FIRST_SELECT_MODULE = 0;
    public static final int BTN_ID_FIRST_MOVE_ITEMS = 4;
    public static final int BTN_ID_FIRST_SORT = 10;
    public static final int BTN_ID_FIRST_BLOCK = 14;
    private static final String[] BUTTON_STRINGS = new String[]{"enderutilities.gui.label.moveallitemsexcepthotbar", "enderutilities.gui.label.movematchingitemsexcepthotbar", "enderutilities.gui.label.leaveonefilledstack", "enderutilities.gui.label.fillstacks", "enderutilities.gui.label.movematchingitems", "enderutilities.gui.label.moveallitems", "enderutilities.gui.label.sortitems", "enderutilities.gui.label.blockquickactions"};
    private final ContainerHandyBag containerHB;
    private final InventoryItemModular invModular;
    private final int invSize;
    private final int numModuleSlots;
    private final int bagTier;
    private float oldMouseX;
    private float oldMouseY;
    private int firstModuleSlotX;
    private int firstModuleSlotY;
    private boolean hasActivePotionEffects;
    private int[] lastPos = new int[2];

    public GuiHandyBag(ContainerHandyBag container) {
        super(container, container.getBagTier() == 1 ? 256 : 176, 256, "gui.container.handybag." + container.getBagTier());
        this.containerHB = container;
        this.invModular = container.inventoryItemModular;
        this.invSize = this.invModular.getSlots();
        this.numModuleSlots = this.invModular.getModuleInventory().getSlots();
        this.bagTier = this.containerHB.getBagTier();
        this.scaledStackSizeTextInventories.add(this.invModular);
    }

    private void updatePositions() {
        this.firstModuleSlotX = this.field_147003_i + this.containerHB.func_75139_a((int)0).field_75223_e + 90;
        this.firstModuleSlotY = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f - 33;
        this.createButtons();
        this.lastPos[0] = this.field_147003_i;
        this.lastPos[1] = this.field_147009_r;
    }

    private boolean needsPositionUpdate() {
        return this.lastPos[0] != this.field_147003_i || this.lastPos[1] != this.field_147009_r;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updatePositions();
        this.updateActivePotionEffects();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateActivePotionEffects();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        if (this.needsPositionUpdate()) {
            this.updatePositions();
        }
        if (this.hasActivePotionEffects) {
            this.drawActivePotionEffects();
        }
        this.drawTooltips(mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        int index;
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.bindTexture(this.guiTextureWidgets);
        if (!this.invModular.isAccessibleByPlayer(this.player)) {
            for (i = 0; i < this.invSize; ++i) {
                Slot slot = this.containerHB.func_75139_a(i);
                this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 102, 0, 18, 18);
            }
        } else if (this.containerHB.getSelectedSlot() != -1) {
            Slot slot = this.containerHB.func_75139_a(this.containerHB.getSelectedSlot());
            this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 102, 18, 18, 18);
        }
        if (!this.invModular.getModuleInventory().isAccessibleByPlayer(this.player)) {
            for (i = 0; i < this.numModuleSlots; ++i) {
                this.func_73729_b(this.firstModuleSlotX - 1 + i * 18, this.firstModuleSlotY - 1, 102, 0, 18, 18);
            }
        }
        if ((index = this.invModular.getSelectedModuleIndex()) >= 0) {
            this.func_73729_b(this.firstModuleSlotX - 1 + index * 18, this.firstModuleSlotY - 1, 102, 18, 18, 18);
            this.func_73729_b(this.firstModuleSlotX + 3 + index * 18, this.firstModuleSlotY + 18, 120, 0, 10, 10);
        }
        for (int i2 = 0; i2 < this.numModuleSlots; ++i2) {
            if (this.invModular.getModuleInventory().getStackInSlot(i2) != null) continue;
            this.func_73729_b(this.firstModuleSlotX + i2 * 18, this.firstModuleSlotY, 240, 80, 16, 16);
        }
        ItemStack stack = null;
        int selected = this.invModular.getSelectedModuleIndex();
        if (selected >= 0) {
            stack = this.invModular.getModuleInventory().getStackInSlot(selected);
        }
        if (stack != null) {
            int x = (this.field_146294_l - this.field_146999_f) / 2;
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            long[] masks = new long[]{0x1FFFFFFL, 2198889037824L, 36026597995708416L};
            int[] xPos = new int[]{111, 20, 226};
            long lockMask = NBTUtils.getLong(stack, "HandyBag", "LockMask");
            for (int i3 = 0; i3 < 3; ++i3) {
                if ((lockMask & masks[i3]) != masks[i3]) continue;
                this.func_73729_b(x + xPos[i3], y + 90, 120, 24, 10, 10);
            }
        }
        int xOff = this.field_147003_i + (this.bagTier == 1 ? 91 : 51);
        GuiInventory.func_147046_a((int)xOff, (int)(this.field_147009_r + 82), (int)30, (float)((float)xOff - this.oldMouseX), (float)((float)(this.field_147009_r + 25) - this.oldMouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int xOff = this.bagTier == 1 ? 40 : 0;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), xOff + 97, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.memorycards", (Object[])new Object[0]), xOff + 99, 59, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.handybag", (Object[])new Object[0]), xOff + 8, 90, 0x404040);
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int numModules = this.invModular.getModuleInventory().getSlots();
        for (int i = 0; i < numModules; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(0 + i, this.firstModuleSlotX + 4 + i * 18, this.firstModuleSlotY + 19, 8, 8, 0, 0, this.guiTextureWidgets, 8, 0));
        }
        int x = this.field_147003_i + this.containerHB.func_75139_a((int)0).field_75223_e + 2;
        int y = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f + 55;
        this.field_146292_n.add(new GuiButtonHoverText(4, x + 0, y + 0, 12, 12, 24, 0, this.guiTextureWidgets, 12, 0, "enderutilities.gui.label.moveallitemsexcepthotbar", "enderutilities.gui.label.holdshifttoincludehotbar"));
        this.field_146292_n.add(new GuiButtonHoverText(5, x + 18, y + 0, 12, 12, 24, 12, this.guiTextureWidgets, 12, 0, "enderutilities.gui.label.movematchingitemsexcepthotbar", "enderutilities.gui.label.holdshifttoincludehotbar"));
        int[] xOff = new int[]{36, 108, 126, 144};
        for (int i = 2; i < 6; ++i) {
            this.field_146292_n.add(new GuiButtonHoverText(4 + i, x + xOff[i - 2], y, 12, 12, 24, i * 12, this.guiTextureWidgets, 12, 0, BUTTON_STRINGS[i]));
        }
        y = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f - 11;
        if (this.bagTier == 0) {
            this.field_146292_n.add(new GuiButtonHoverText(10, x + 74, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(13, x + 74, y + 70, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
        } else {
            this.field_146292_n.add(new GuiButtonHoverText(11, x - 17, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(10, x + 74, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(12, x + 165, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(13, x + 74, y + 70, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(15, x - 29, y + 0, 8, 8, 0, 40, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[7]));
            this.field_146292_n.add(new GuiButtonHoverText(14, x + 62, y + 0, 8, 8, 0, 40, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[7]));
            this.field_146292_n.add(new GuiButtonHoverText(16, x + 177, y + 0, 8, 8, 0, 40, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[7]));
        }
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!(button instanceof GuiButtonHoverText) || !button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            this.drawHoveringText(((GuiButtonHoverText)button).getHoverStrings(), mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    protected void bindTexture(ResourceLocation rl) {
        this.field_146297_k.func_110434_K().func_110577_a(rl);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k >= 0 && button.field_146127_k < 0 + this.numModuleSlots) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 0, button.field_146127_k - 0));
        } else if (button.field_146127_k >= 4 && button.field_146127_k <= 9) {
            int value = button.field_146127_k - 4;
            if (GuiScreen.func_146272_n()) {
                value |= 0x8000;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 1, value));
        } else if (button.field_146127_k >= 10 && button.field_146127_k < 14) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 2, button.field_146127_k - 10));
        } else if (button.field_146127_k >= 14 && button.field_146127_k < 17) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 3, button.field_146127_k - 14));
        }
    }

    protected void updateActivePotionEffects() {
        boolean hasVisibleEffect = false;
        for (PotionEffect potioneffect : this.field_146297_k.field_71439_g.func_70651_bq()) {
            Potion potion = potioneffect.func_188419_a();
            if (!potion.shouldRender(potioneffect)) continue;
            hasVisibleEffect = true;
            break;
        }
        if (!this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() && hasVisibleEffect) {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((GuiScreen)this)) ? (this.field_146294_l - this.field_146999_f) / 2 : 160 + (this.field_146294_l - this.field_146999_f - 200) / 2;
            this.hasActivePotionEffects = true;
        } else {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.hasActivePotionEffects = false;
        }
    }

    private void drawActivePotionEffects() {
        int i = this.field_147003_i - 124;
        int j = this.field_147009_r;
        Collection collection = this.field_146297_k.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            int l = 33;
            if (collection.size() > 5) {
                l = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
                this.func_73729_b(i, j, 0, 166, 140, 32);
                if (potion.func_76400_d()) {
                    int i1 = potion.func_76392_e();
                    this.func_73729_b(i + 6, j + 7, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                }
                potion.renderInventoryEffect(i, j, potioneffect, this.field_146297_k);
                if (!potion.shouldRenderInvText(potioneffect)) {
                    j += l;
                    continue;
                }
                String s1 = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                if (potioneffect.func_76458_c() == 1) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.2", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 2) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.3", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 3) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.4", (Object[])new Object[0]);
                }
                this.field_146289_q.func_175063_a(s1, (float)(i + 10 + 18), (float)(j + 6), 0xFFFFFF);
                String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                this.field_146289_q.func_175063_a(s, (float)(i + 10 + 18), (float)(j + 6 + 10), 0x7F7F7F);
                j += l;
            }
        }
    }
}

