/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSelective;
import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackHandlerBasic
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound>,
IItemHandlerSelective,
IItemHandlerSize {
    protected final int invSize;
    protected final int stackLimit;
    protected final boolean allowCustomStackSizes;
    protected final ItemStack[] items;
    protected String tagName;

    public ItemStackHandlerBasic(int invSize) {
        this(invSize, 64, false, "Items");
    }

    public ItemStackHandlerBasic(int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName) {
        this.invSize = invSize;
        this.stackLimit = stackLimit;
        this.tagName = tagName;
        this.allowCustomStackSizes = allowCustomStackSizes;
        this.items = new ItemStack[invSize];
    }

    public int getSlots() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.onContentsChanged(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.items.length || stack == null || !this.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        int existingStackSize = this.items[slot] != null ? this.items[slot].field_77994_a : 0;
        int max = this.getItemStackLimit(stack);
        if (!this.allowCustomStackSizes) {
            max = Math.min(max, stack.func_77976_d());
        }
        if (this.items[slot] != null) {
            if (this.items[slot].field_77994_a >= max) {
                return stack;
            }
            if (stack.func_77973_b() != this.items[slot].func_77973_b() || stack.func_77960_j() != this.items[slot].func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.items[slot])) {
                return stack;
            }
        }
        int amount = Math.min(max - existingStackSize, stack.field_77994_a);
        if (!simulate) {
            if (this.items[slot] != null) {
                this.items[slot].field_77994_a += amount;
            } else {
                this.items[slot] = stack.func_77946_l();
                this.items[slot].field_77994_a = amount;
            }
            this.onContentsChanged(slot);
        }
        if (amount < stack.field_77994_a) {
            ItemStack stackRemaining = stack.func_77946_l();
            stackRemaining.field_77994_a -= amount;
            return stackRemaining;
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack;
        if (slot < 0 || slot >= this.items.length || this.items[slot] == null || !this.canExtractFromSlot(slot)) {
            return null;
        }
        amount = Math.min(amount, this.items[slot].field_77994_a);
        amount = Math.min(amount, this.items[slot].func_77976_d());
        if (simulate) {
            ItemStack stack2 = this.items[slot].func_77946_l();
            stack2.field_77994_a = amount;
            return stack2;
        }
        if (amount == this.items[slot].field_77994_a) {
            stack = this.items[slot];
            this.items[slot] = null;
        } else {
            stack = this.items[slot].func_77979_a(amount);
            if (this.items[slot].field_77994_a <= 0) {
                this.items[slot] = null;
            }
        }
        this.onContentsChanged(slot);
        return stack;
    }

    public NBTTagCompound serializeNBT() {
        return NBTUtils.writeItemsToTag(new NBTTagCompound(), this.items, this.tagName, true);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTUtils.readStoredItemsFromTag(nbt, this.items, this.tagName);
    }

    public void onContentsChanged(int slot) {
    }

    @Override
    public int getInventoryStackLimit() {
        return this.stackLimit;
    }

    @Override
    public int getItemStackLimit(ItemStack stack) {
        if (this.allowCustomStackSizes || stack != null && this.getInventoryStackLimit() < stack.func_77976_d()) {
            return this.getInventoryStackLimit();
        }
        return stack.func_77976_d();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        return true;
    }
}

