/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCrafting;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftresult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerFurnaceOutput;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerCreationStation
extends ContainerLargeStacks {
    protected final TileEntityCreationStation tecs;
    public int selectionsLast;
    public int modeMask;
    public int fuelProgress;
    public int smeltProgress;
    private int lastInteractedCraftingGrid;
    private final InventoryItemCrafting[] craftMatrices;
    private final IItemHandler[] craftMatrixWrappers;
    private final ItemStackHandlerBasic[] craftResults;
    private final IItemHandler furnaceInventory;
    private SlotRange craftingGridSlotsLeft;
    private SlotRange craftingGridSlotsRight;

    public ContainerCreationStation(EntityPlayer player, TileEntityCreationStation te) {
        super(player, te.getItemInventory(player));
        this.tecs = te;
        this.tecs.openInventory(player);
        this.craftMatrices = new InventoryItemCrafting[]{te.getCraftingInventory(0, this, player), te.getCraftingInventory(1, this, player)};
        this.craftMatrixWrappers = new IItemHandler[]{te.getCraftingInventoryWrapper(0), te.getCraftingInventoryWrapper(1)};
        this.craftResults = new ItemStackHandlerBasic[]{te.getCraftResultInventory(0), te.getCraftResultInventory(1)};
        this.furnaceInventory = this.tecs.getFurnaceInventory();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(40, 174);
    }

    @Override
    protected void addCustomInventorySlots() {
        int j;
        int i;
        int customInvStart = this.field_75151_b.size();
        int posX = 40;
        int posY = 102;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        this.customInventorySlots = new MergeSlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 4);
        posX = 216;
        posY = 102;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerModule(this.tecs.getMemoryCardInventory(), i, posX, posY + i * 18, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS));
        }
        this.craftingGridSlotsLeft = new SlotRange(this.field_75151_b.size(), 9);
        posX = 40;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.craftMatrixWrappers[0], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotItemHandlerCraftresult(this.player, this.craftMatrices[0], (IItemHandler)this.craftResults[0], 0, 112, 33));
        this.craftingGridSlotsRight = new SlotRange(this.field_75151_b.size(), 9);
        posX = 148;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.craftMatrixWrappers[1], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotItemHandlerCraftresult(this.player, this.craftMatrices[1], (IItemHandler)this.craftResults[1], 0, 112, 69));
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 6, true);
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 0, 8, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 1, 8, 51));
        this.func_75146_a((Slot)new SlotItemHandlerFurnaceOutput(this.player, this.furnaceInventory, 2, 40, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 3, 216, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 4, 216, 51));
        this.func_75146_a((Slot)new SlotItemHandlerFurnaceOutput(this.player, this.furnaceInventory, 5, 184, 8));
        this.func_75130_a((IInventory)this.craftMatrices[0]);
    }

    public SlotRange getCraftingGridSlotRange(int id) {
        return id == 1 ? this.craftingGridSlotsRight : this.craftingGridSlotsLeft;
    }

    public int getLastInteractedCraftingGridId() {
        return this.tecs.lastInteractedCraftingGrid;
    }

    public IItemHandler getCraftMatrixWrapper(int id) {
        return this.craftMatrixWrappers[id];
    }

    public void func_75130_a(IInventory inv) {
        this.craftResults[0].setStackInSlot(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrices[0], this.player.field_70170_p));
        this.craftResults[1].setStackInSlot(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrices[1], this.player.field_70170_p));
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.tecs.closeInventory(player);
    }

    @Override
    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        SlotItemHandler slotItemHandler;
        if (slot instanceof SlotItemHandler && ((slotItemHandler = (SlotItemHandler)slot).getItemHandler() == this.inventory || slotItemHandler.getItemHandler() == this.tecs.getFurnaceInventory())) {
            return slotItemHandler.func_178170_b(stack);
        }
        return super.getMaxStackSizeFromSlotAndStack(slot, stack);
    }

    @Override
    protected boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        if (slotNum == 40 || slotNum == 50) {
            MergeSlotRange range;
            int invId;
            int n = invId = slotNum == 50 ? 1 : 0;
            if (!this.tecs.canCraftItems(invId)) {
                return false;
            }
            boolean ret = false;
            IItemHandler inv = this.tecs.getItemInventory(player);
            ret = InventoryUtils.matchingStackFoundInSlotRange(inv, range = new MergeSlotRange(inv), this.func_75139_a(slotNum).func_75211_c(), false, false) ? super.transferStackToSlotRange(player, slotNum, range, false) : super.transferStackFromSlot(player, slotNum);
            this.tecs.restockCraftingGrid(invId);
            return ret;
        }
        if ((this.craftingGridSlotsLeft.contains(slotNum) || this.craftingGridSlotsRight.contains(slotNum)) && this.transferStackToSlotRange(player, slotNum, this.customInventorySlots, false)) {
            return true;
        }
        return super.transferStackFromSlot(player, slotNum);
    }

    @Override
    protected void shiftClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        if (slotNum != 40 && slotNum != 50) {
            super.shiftClickSlot(slotNum, player);
            return;
        }
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackSlot == null) {
            return;
        }
        ItemStack stackOrig = stackSlot.func_77946_l();
        int num = 64;
        while (num-- > 0 && this.transferStackFromSlot(player, slotNum) && InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) {
        }
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (!this.tecs.isInventoryAccessible(player) && (this.craftingGridSlotsLeft.contains(slotNum) || this.craftingGridSlotsRight.contains(slotNum))) {
            return null;
        }
        if (this.craftingGridSlotsLeft.contains(slotNum) || slotNum == 40) {
            this.tecs.lastInteractedCraftingGrid = 0;
        } else if (this.craftingGridSlotsRight.contains(slotNum) || slotNum == 50) {
            this.tecs.lastInteractedCraftingGrid = 1;
        }
        if (slotNum == 40 || slotNum == 50) {
            int invId;
            int n = invId = slotNum == 50 ? 1 : 0;
            if (!this.tecs.canCraftItems(invId)) {
                return null;
            }
            ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
            this.tecs.restockCraftingGrid(invId);
            return stack;
        }
        return super.func_184996_a(slotNum, dragType, clickType, player);
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModuleSlot();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        listener.func_71112_a((Container)this, 0, modeMask);
        listener.func_71112_a((Container)this, 1, selection);
        listener.func_71112_a((Container)this, 2, fuelProgress);
        listener.func_71112_a((Container)this, 3, smeltProgress);
        listener.func_71112_a((Container)this, 4, this.tecs.lastInteractedCraftingGrid);
        this.func_75142_b();
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.tecs.func_145831_w().field_72995_K) {
            return;
        }
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModuleSlot();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (this.modeMask != modeMask) {
                listener.func_71112_a((Container)this, 0, modeMask);
            }
            if (this.selectionsLast != selection) {
                listener.func_71112_a((Container)this, 1, selection);
            }
            if (this.fuelProgress != fuelProgress) {
                listener.func_71112_a((Container)this, 2, fuelProgress);
            }
            if (this.smeltProgress != smeltProgress) {
                listener.func_71112_a((Container)this, 3, smeltProgress);
            }
            if (this.lastInteractedCraftingGrid == this.tecs.lastInteractedCraftingGrid) continue;
            listener.func_71112_a((Container)this, 4, this.tecs.lastInteractedCraftingGrid);
        }
        this.modeMask = modeMask;
        this.selectionsLast = selection;
        this.fuelProgress = fuelProgress;
        this.smeltProgress = smeltProgress;
        this.lastInteractedCraftingGrid = this.tecs.lastInteractedCraftingGrid;
    }

    public void func_75137_b(int var, int val) {
        super.func_75137_b(var, val);
        switch (var) {
            case 0: {
                this.modeMask = val;
                break;
            }
            case 1: {
                this.tecs.setSelectedModuleSlot(val & 3);
                this.tecs.setQuickMode(val >> 2 & 7);
                this.tecs.inventoryChanged(1, 0);
                break;
            }
            case 2: {
                this.fuelProgress = val;
                break;
            }
            case 3: {
                this.smeltProgress = val;
                break;
            }
            case 4: {
                this.tecs.lastInteractedCraftingGrid = val;
                break;
            }
        }
    }
}

