/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftresult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerCustomSlotClick
extends ContainerEnderUtilities {
    protected boolean isDragging;
    protected boolean draggingRightClick;
    protected final Set<Integer> draggedSlots = new HashSet<Integer>();
    protected int selectedSlot = -1;

    public ContainerCustomSlotClick(EntityPlayer player, IItemHandler inventory) {
        super(player, inventory);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    protected void startDragging(boolean isRightClick) {
        this.isDragging = true;
        this.draggingRightClick = isRightClick;
        this.draggedSlots.clear();
    }

    private void dragging(int slotNum) {
        this.draggedSlots.add(slotNum);
    }

    protected ItemStack putItemsToSlot(SlotItemHandlerGeneric slot, ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        if (amount < stack.field_77994_a) {
            ItemStack stackInsert = stack.func_77979_a(amount);
            if ((stackInsert = slot.insertItem(stackInsert, false)) != null) {
                stack.field_77994_a += stackInsert.field_77994_a;
            }
            return stack;
        }
        return slot.insertItem(stack, false);
    }

    protected boolean takeItemsFromSlotToCursor(SlotItemHandlerGeneric slot, int amount) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (!slot.func_82869_a(this.player) || stackSlot == null || stackCursor != null && !InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
            return false;
        }
        amount = Math.min(amount, stackSlot.func_77976_d());
        int spaceAvailable = stackSlot.func_77976_d();
        if (stackCursor != null) {
            spaceAvailable = stackCursor.func_77976_d() - stackCursor.field_77994_a;
        }
        if ((amount = Math.min(amount, spaceAvailable)) <= 0 || slot instanceof SlotItemHandlerCraftresult && spaceAvailable < stackSlot.field_77994_a) {
            return false;
        }
        stackSlot = slot.func_75209_a(amount);
        if (stackSlot != null) {
            slot.func_82870_a(this.player, stackSlot);
            if (stackCursor == null) {
                stackCursor = stackSlot;
            } else {
                stackCursor.field_77994_a += stackSlot.field_77994_a;
            }
            this.inventoryPlayer.func_70437_b(stackCursor);
            return true;
        }
        return false;
    }

    protected boolean swapSlots(SlotItemHandlerGeneric slot1, SlotItemHandlerGeneric slot2) {
        if (slot1.func_75216_d() && !slot1.func_82869_a(this.player) || slot2.func_75216_d() && !slot2.func_82869_a(this.player)) {
            return false;
        }
        ItemStack stack1 = slot1.func_75211_c();
        ItemStack stack2 = slot2.func_75211_c();
        if (stack1 != null && !slot2.func_75214_a(stack1) || stack2 != null && !slot1.func_75214_a(stack2)) {
            return false;
        }
        if (stack1 != null) {
            slot1.func_82870_a(this.player, stack1);
        }
        if (stack2 != null) {
            slot2.func_82870_a(this.player, stack2);
        }
        slot1.func_75215_d(ItemStack.func_77944_b((ItemStack)stack2));
        slot2.func_75215_d(ItemStack.func_77944_b((ItemStack)stack1));
        return true;
    }

    protected void endDragging() {
        ItemStack stackCursor = ItemStack.func_77944_b((ItemStack)this.inventoryPlayer.func_70445_o());
        if (stackCursor != null) {
            int numSlots = this.draggedSlots.size();
            int itemsPerSlot = this.draggingRightClick ? 1 : (numSlots > 0 ? stackCursor.field_77994_a / numSlots : stackCursor.field_77994_a);
            for (int slotNum : this.draggedSlots) {
                if (stackCursor == null) break;
                SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
                if (slot == null) continue;
                int amount = Math.min(itemsPerSlot, this.getMaxStackSizeFromSlotAndStack((Slot)slot, stackCursor));
                amount = Math.min(amount, stackCursor.field_77994_a);
                stackCursor = this.putItemsToSlot(slot, stackCursor, amount);
            }
            this.inventoryPlayer.func_70437_b(stackCursor);
        }
        this.isDragging = false;
    }

    protected void leftClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (stackCursor != null) {
            int max = stackCursor.func_77976_d();
            while (stackCursor.field_77994_a > max) {
                ItemStack stackDrop = stackCursor.func_77946_l();
                stackDrop.field_77994_a = max;
                player.func_71019_a(stackDrop, true);
            }
            player.func_71019_a(stackCursor, true);
            this.inventoryPlayer.func_70437_b(null);
        }
    }

    protected void rightClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (stackCursor != null) {
            ItemStack stackDrop = stackCursor.func_77979_a(1);
            player.func_71019_a(stackDrop, true);
            this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
        }
    }

    protected void leftClickSlot(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (stackCursor != null) {
            if (stackSlot == null || InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    this.inventoryPlayer.func_70437_b(slot.insertItem(stackCursor, false));
                } else if (stackSlot != null) {
                    this.takeItemsFromSlotToCursor(slot, stackSlot.field_77994_a);
                }
            } else if (slot.func_82869_a(this.player) && slot.canTakeAll() && slot.func_75214_a(stackCursor)) {
                this.inventoryPlayer.func_70437_b(slot.func_75209_a(stackSlot.field_77994_a));
                slot.func_82870_a(this.player, stackSlot);
                slot.insertItem(stackCursor, false);
            }
        } else if (stackSlot != null) {
            this.takeItemsFromSlotToCursor(slot, stackSlot.field_77994_a);
        }
    }

    protected void rightClickSlot(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (stackCursor != null) {
            if (stackSlot == null || InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    if (slot.insertItem(stackCursor.func_77979_a(1), false) != null) {
                        ++stackCursor.field_77994_a;
                    }
                    this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                } else if (stackSlot != null) {
                    this.takeItemsFromSlotToCursor(slot, Math.min(stackSlot.func_77976_d() / 2, stackSlot.field_77994_a));
                }
            } else if (slot.func_82869_a(this.player) && slot.canTakeAll() && slot.func_75214_a(stackCursor)) {
                this.inventoryPlayer.func_70437_b(slot.func_75209_a(stackSlot.field_77994_a));
                slot.func_82870_a(this.player, stackSlot);
                slot.insertItem(stackCursor, false);
            }
        } else if (stackSlot != null) {
            int amount = stackSlot.field_77994_a;
            if (!(slot instanceof SlotItemHandlerCraftresult)) {
                amount = Math.min((int)Math.ceil((double)stackSlot.field_77994_a / 2.0), (int)Math.ceil((double)stackSlot.func_77976_d() / 2.0));
            }
            this.takeItemsFromSlotToCursor(slot, amount);
        }
    }

    protected void middleClickSlot(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot1 = this.getSlotItemHandler(slotNum);
        if (slot1 != null && slot1.getItemHandler() == this.inventory) {
            if (this.selectedSlot >= 0 && this.selectedSlot < this.field_75151_b.size()) {
                SlotItemHandlerGeneric slot2;
                if (this.selectedSlot != slotNum && (slot2 = this.getSlotItemHandler(this.selectedSlot)) != null) {
                    this.swapSlots(slot1, slot2);
                }
                this.selectedSlot = -1;
            } else {
                this.selectedSlot = slotNum;
            }
        }
    }

    protected void leftDoubleClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackTmp;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (slot != null && stackCursor != null && this.func_94530_a(stackCursor, (Slot)slot) && (stackTmp = InventoryUtils.collectItemsFromInventory(slot.getItemHandler(), stackCursor, stackCursor.func_77976_d() - stackCursor.field_77994_a, true)) != null) {
            stackCursor.field_77994_a += stackTmp.field_77994_a;
            this.inventoryPlayer.func_70437_b(stackCursor);
        }
    }

    protected void shiftClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackSlot == null) {
            return;
        }
        this.transferStackFromSlot(player, slotNum);
        slot.func_82870_a(player, stackSlot);
    }

    protected void pressDropKey(int slotNum, EntityPlayer player, boolean wholeStack) {
        ItemStack stackDrop;
        ItemStack stackSlot;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackSlot != null && slot.func_82869_a(this.player) && (stackDrop = slot.func_75209_a(wholeStack ? stackSlot.field_77994_a : 1)) != null) {
            slot.func_82870_a(player, stackDrop);
            player.func_71019_a(stackDrop, true);
        }
    }

    protected void pressHotbarKey(int slotNum, int button, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackSlot = slot != null ? slot.func_75211_c() : null;
        ItemStack stackHotbar = this.playerInv.getStackInSlot(button);
        if ((stackSlot == null || stackSlot.field_77994_a <= stackSlot.func_77976_d()) && (stackHotbar == null || stackHotbar.field_77994_a <= this.getMaxStackSizeFromSlotAndStack((Slot)slot, stackHotbar)) && slot.func_82869_a(this.player) && slot.func_75214_a(stackHotbar)) {
            slot.func_75215_d(stackHotbar);
            this.playerInv.setStackInSlot(button, stackSlot);
            if (stackSlot != null) {
                slot.func_82870_a(player, stackSlot);
            }
        } else if (stackHotbar == null && stackSlot != null) {
            int num = Math.min(stackSlot.func_77976_d(), this.inventoryPlayer.func_70297_j_());
            num = Math.min(num, stackSlot.field_77994_a);
            stackHotbar = slot.func_75209_a(num);
            slot.func_82870_a(player, stackHotbar);
            this.playerInv.setStackInSlot(button, stackHotbar);
        } else if (stackHotbar != null && stackSlot != null && InventoryUtils.areItemStacksEqual(stackHotbar, stackSlot)) {
            int num = Math.min(stackHotbar.func_77976_d() - stackHotbar.field_77994_a, stackSlot.field_77994_a);
            if (num > 0) {
                stackHotbar.field_77994_a += num;
                slot.func_75209_a(num);
                slot.func_82870_a(player, stackSlot);
                this.playerInv.setStackInSlot(button, stackHotbar);
            } else if (slot.func_75214_a(stackHotbar)) {
                this.playerInv.setStackInSlot(button, this.putItemsToSlot(slot, stackHotbar, stackHotbar.field_77994_a));
            }
        }
    }

    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (this.isDragging) {
            if (clickType == ClickType.QUICK_CRAFT && (dragType == 2 || dragType == 6)) {
                this.endDragging();
            } else if (clickType == ClickType.QUICK_CRAFT && (dragType == 1 || dragType == 5)) {
                this.dragging(slotNum);
            }
        } else if (clickType == ClickType.QUICK_CRAFT && (dragType == 0 || dragType == 4)) {
            this.startDragging(dragType == 4);
        } else if (clickType == ClickType.PICKUP && slotNum == -999) {
            if (dragType == 0) {
                this.leftClickOutsideInventory(player);
            } else if (dragType == 1) {
                this.rightClickOutsideInventory(player);
            }
        } else if (clickType == ClickType.PICKUP && dragType == 0) {
            this.leftClickSlot(slotNum, player);
        } else if (clickType == ClickType.PICKUP && dragType == 1) {
            this.rightClickSlot(slotNum, player);
        } else if (clickType == ClickType.QUICK_MOVE && (dragType == 0 || dragType == 1)) {
            this.shiftClickSlot(slotNum, player);
        } else if (clickType == ClickType.THROW && (dragType == 0 || dragType == 1)) {
            this.pressDropKey(slotNum, player, dragType == 1);
        } else if (clickType == ClickType.SWAP && dragType >= 0 && dragType <= 8) {
            this.pressHotbarKey(slotNum, dragType, player);
        } else if (clickType == ClickType.PICKUP_ALL && dragType == 0) {
            this.leftDoubleClickSlot(slotNum, player);
        } else if (clickType == ClickType.CLONE && dragType == 2) {
            this.middleClickSlot(slotNum, player);
        }
        return null;
    }
}

