/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.event.tasks.TaskBuildersWand;
import fi.dy.masa.enderutilities.event.tasks.TaskMoveArea;
import fi.dy.masa.enderutilities.event.tasks.TaskReplaceBlocks;
import fi.dy.masa.enderutilities.event.tasks.TaskTemplatePlaceBlocks;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.IStringInput;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.TemplateEnderUtilities;
import fi.dy.masa.enderutilities.util.TemplateManagerEU;
import fi.dy.masa.enderutilities.util.TemplateMetadata;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemBuildersWand
extends ItemLocationBoundModular
implements IStringInput {
    public static final int ENDER_CHARGE_COST = 2;
    public static final int MAX_BLOCKS = 16;
    public static final String WRAPPER_TAG_NAME = "BuildersWand";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_CONFIGS = "Configs";
    public static final String TAG_NAME_CONFIG_PRE = "Mode_";
    public static final String TAG_NAME_CORNERS = "Corners";
    public static final String TAG_NAME_DIMENSIONS = "Dim";
    public static final String TAG_NAME_BLOCKS = "Blocks";
    public static final String TAG_NAME_BLOCK_PRE = "Block_";
    public static final String TAG_NAME_BLOCK_SEL = "SelBlock";
    public static final String TAG_NAME_TEMPLATES = "Templates";
    public static final int BLOCK_TYPE_TARGETED = -1;
    public static final int BLOCK_TYPE_ADJACENT = -2;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();

    public ItemBuildersWand() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("builderswand");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null) {
            return super.func_77659_a(stack, world, player, hand);
        }
        Mode mode = Mode.getMode(stack);
        if (!world.field_72995_K) {
            if (this.cancelRunningTask(player)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!mode.hasUseDelay()) {
                EnumActionResult result = this.useWand(stack, world, player, pos);
                return new ActionResult(result, (Object)stack);
            }
        }
        if (mode.hasUseDelay() && this.getPosition(stack, false) != null) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private boolean cancelRunningTask(EntityPlayer player) {
        boolean removed = false;
        Class[] classes = new Class[]{TaskBuildersWand.class, TaskReplaceBlocks.class, TaskTemplatePlaceBlocks.class};
        PlayerTaskScheduler scheduler = PlayerTaskScheduler.getInstance();
        for (Class clazz : classes) {
            if (!scheduler.hasTask(player, clazz)) continue;
            PlayerTaskScheduler.getInstance().removeTask(player, clazz);
            removed = true;
        }
        return removed;
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || te.getClass() == TileEntityEnderChest.class)) {
            return super.func_180614_a(stack, player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        Mode mode = Mode.getMode(stack);
        if (mode.hasTwoPlacableCorners()) {
            if (!world.field_72995_K) {
                this.setPosition(stack, new BlockPosEU(player.func_70093_af() ? pos : pos.func_177972_a(side), player.field_71093_bK, side), false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!(world.field_72995_K || player.func_70093_af() && side == EnumFacing.UP && mode != Mode.REPLACE)) {
            if (mode != Mode.REPLACE) {
                pos = pos.func_177972_a(side);
            }
            return this.useWand(stack, world, player, new BlockPosEU(pos, player.field_71093_bK, side));
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.equals(newStack);
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, BlockPos pos, int dimension, EnumFacing side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            Mode mode = Mode.getMode(stack);
            if (player.func_70093_af() && !mode.isAreaMode()) {
                this.setSelectedFixedBlockType(stack, player, world, pos);
            } else if (mode == Mode.REPLACE) {
                if (this.getReplaceModeIsArea(stack)) {
                    this.setPosition(stack, new BlockPosEU(pos, player.field_71093_bK, side), true);
                }
            } else {
                this.setPosition(stack, new BlockPosEU(player.func_70093_af() ? pos : pos.func_177972_a(side), player.field_71093_bK, side), true);
            }
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int itemInUseCount) {
        if (world.field_72995_K || !(livingBase instanceof EntityPlayer)) {
            return;
        }
        if (this.func_77626_a(stack) - itemInUseCount >= 20) {
            EntityPlayer player = (EntityPlayer)livingBase;
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && this.useWand(stack, world, player, pos) == EnumActionResult.SUCCESS) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.4f, 0.7f);
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String itemName = this.getBaseItemDisplayName(stack);
        if (stack.func_77978_p() == null) {
            return itemName;
        }
        Mode mode = Mode.getMode(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        if (itemName.length() >= 14) {
            itemName = EUStringUtils.getInitialsWithDots(itemName);
        }
        itemName = itemName + " - " + preGreen + mode.getDisplayName() + rst;
        return itemName;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String str2;
        String str;
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        String pre = TextFormatting.DARK_GREEN.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strYes = preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst;
        String strNo = preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        Mode mode = Mode.getMode(stack);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + pre + mode.getDisplayName() + rst);
        int sel = this.getSelectionIndex(stack);
        if (mode.isAreaMode()) {
            str = mode == Mode.COPY || mode == Mode.PASTE ? I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedtemplate", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]);
            list.add(str + ": " + preGreen + (sel + 1) + rst);
        } else if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = this.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)) != null && blockStack.func_77973_b() != null) {
                String str3 = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedblock", (Object[])new Object[0]);
                list.add(str3 + ": " + pre + blockStack.func_82833_r() + rst);
            }
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedblock", (Object[])new Object[0]);
            str2 = sel == -1 ? I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.targeted", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.adjacent", (Object[])new Object[0]);
            list.add(str + ": " + pre + str2 + rst);
        }
        if (mode.isAreaMode()) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.rotation", (Object[])new Object[0]) + ": ";
            EnumFacing facing = this.getAreaFacing(stack, mode);
            str2 = facing != null ? preGreen + facing.toString().toLowerCase() : preRed + "N/A";
            list.add(str + str2 + rst);
            str2 = I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]) + ": ";
            if (this.isMirrored(stack)) {
                String m = this.getMirror(stack) == Mirror.FRONT_BACK ? "x" : "z";
                list.add(str2 + preGreen + m + rst);
            } else {
                list.add(str2 + strNo);
            }
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area.flipped", (Object[])new Object[0]);
            if (this.getAreaFlipped(stack)) {
                list.add(str + ": " + strYes + rst);
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.flipaxis", (Object[])new Object[0]);
                String preBlue = TextFormatting.BLUE.toString();
                list.add(str + ": " + preBlue + this.getAreaFlipAxis(stack, EnumFacing.UP) + rst);
            } else {
                list.add(str + ": " + strNo + rst);
            }
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.move", (Object[])new Object[0]);
            list.add(str + ": " + (this.getMovePosition(stack, mode) ? strYes : strNo) + rst);
        }
        if (mode == Mode.EXTEND_CONTINUOUS) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals", (Object[])new Object[0]);
            list.add(str + ": " + (this.getAllowDiagonals(stack, mode) ? strYes : strNo) + rst);
        }
        if (!mode.isAreaMode()) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.renderghostblocks", (Object[])new Object[0]);
            list.add(str + ": " + (this.getRenderGhostBlocks(stack, mode) ? strYes : strNo) + rst);
        }
        super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
    }

    @Override
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemBuildersWand.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    private NBTTagCompound getModeTag(ItemStack stack, Mode mode) {
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        return NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode.getName(), true);
    }

    public BlockPosEU getPosition(ItemStack stack, boolean isStart) {
        return this.getPosition(stack, Mode.getMode(stack), isStart);
    }

    public BlockPosEU getPosition(ItemStack stack, Mode mode, boolean isStart) {
        if (mode.isAreaMode()) {
            if (isStart) {
                return this.getPerTemplateAreaCorner(stack, mode, isStart);
            }
            return this.getTransformedEndPosition(stack, mode);
        }
        if (mode == Mode.REPLACE && !this.getReplaceModeIsArea(stack)) {
            return null;
        }
        return BlockPosEU.readFromTag(this.getModeTag(stack, mode).func_74775_l(isStart ? "Pos1" : "Pos2"));
    }

    private BlockPosEU getTransformedEndPosition(ItemStack stack, Mode mode) {
        EnumFacing origFacing;
        BlockPosEU posEndRelative;
        BlockPosEU posStart = this.getPerTemplateAreaCorner(stack, mode, true);
        if (posStart == null) {
            return null;
        }
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.NONE;
        EnumFacing adjustedFacing = this.getAreaFacing(stack, mode);
        if (mode == Mode.PASTE) {
            NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, false);
            if (tag == null) {
                return null;
            }
            posEndRelative = new BlockPosEU(tag.func_74762_e("endOffsetX"), tag.func_74762_e("endOffsetY"), tag.func_74762_e("endOffsetZ"));
            origFacing = this.getTemplateFacing(stack);
        } else if (mode == Mode.MOVE_DST) {
            BlockPosEU posStartSrc = this.getPerTemplateAreaCorner(stack, Mode.MOVE_SRC, true);
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, Mode.MOVE_SRC, false);
            if (posStartSrc == null || posEnd == null) {
                return null;
            }
            posEndRelative = posEnd.subtract(posStartSrc);
            origFacing = PositionUtils.getFacingFromPositions(posStartSrc, posEnd);
        } else {
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
            if (posEnd == null) {
                return null;
            }
            posEndRelative = posEnd.subtract(posStart);
            origFacing = PositionUtils.getFacingFromPositions(posStart, posEnd);
        }
        if (adjustedFacing == null) {
            adjustedFacing = origFacing;
        }
        mirror = this.getMirror(stack, mode);
        rotation = PositionUtils.getRotation(origFacing, adjustedFacing);
        posEndRelative = PositionUtils.getTransformedBlockPos(posEndRelative, mirror, rotation);
        return posStart.add(posEndRelative);
    }

    private NBTTagCompound getCornerPositionTag(ItemStack stack, Mode mode, boolean isStart) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag = NBTUtils.getCompoundTag(tag, "Corners_" + sel, true);
        tag = NBTUtils.getCompoundTag(tag, isStart ? "Pos1" : "Pos2", true);
        return tag;
    }

    private BlockPosEU getPerTemplateAreaCorner(ItemStack stack, Mode mode, boolean isStart) {
        return BlockPosEU.readFromTag(this.getCornerPositionTag(stack, mode, isStart));
    }

    private void setPerTemplateAreaCorner(ItemStack stack, Mode mode, boolean isStart, BlockPosEU pos) {
        pos.writeToTag(this.getCornerPositionTag(stack, mode, isStart));
    }

    public void setPosition(ItemStack stack, BlockPosEU pos, boolean isStart) {
        String tagName;
        Mode mode = Mode.getMode(stack);
        if (!(isStart || mode != Mode.PASTE && mode != Mode.MOVE_DST && mode != Mode.REPLACE)) {
            return;
        }
        if (mode == Mode.REPLACE && !this.getReplaceModeIsArea(stack)) {
            return;
        }
        if (mode.isAreaMode()) {
            this.setPerTemplateAreaCorner(stack, mode, isStart, pos);
            this.setMirror(stack, mode, Mirror.NONE);
            BlockPosEU posStart = this.getPerTemplateAreaCorner(stack, mode, true);
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
            if (posStart != null && posEnd != null) {
                this.setAreaFacing(stack, mode, PositionUtils.getFacingFromPositions(posStart, posEnd));
            }
            return;
        }
        NBTTagCompound tag = this.getModeTag(stack, mode);
        String string = tagName = isStart ? "Pos1" : "Pos2";
        if (tag.func_150297_b(tagName, 10)) {
            BlockPosEU oldPos = BlockPosEU.readFromTag(tag.func_74775_l(tagName));
            if (oldPos != null && oldPos.equals(pos)) {
                tag.func_82580_o(tagName);
            } else {
                tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
        } else {
            tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
        }
    }

    private EnumActionResult useWand(ItemStack stack, World world, EntityPlayer player, BlockPosEU posTarget) {
        if (player.field_71093_bK != posTarget.dimension) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d && !UtilItemModular.useEnderCharge(stack, 2, true)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.notenoughendercharge", new Object[0]));
            return EnumActionResult.FAIL;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        BlockPosEU posStart = this.getPosition(stack, true);
        BlockPosEU posEnd = this.getPosition(stack, false);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE) {
            this.getBlockPositionsCube(stack, world, positions, posStart, posEnd);
        } else if (mode == Mode.WALLS) {
            this.getBlockPositionsWalls(stack, world, positions, posStart, posEnd);
        } else {
            if (mode == Mode.COPY) {
                return this.copyAreaToTemplate(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.PASTE) {
                return this.pasteAreaIntoWorld(stack, world, player, posStart);
            }
            if (mode == Mode.DELETE) {
                return this.deleteArea(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.MOVE_DST) {
                return this.moveArea(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.MOVE_SRC) {
                return EnumActionResult.PASS;
            }
            if (mode == Mode.REPLACE) {
                return this.replaceBlocks(stack, world, player, posStart != null ? posStart : posTarget);
            }
            this.getBlockPositions(stack, world, player, positions, posStart != null ? posStart : posTarget);
        }
        if (positions.size() <= 60) {
            for (int i = 0; i < positions.size(); ++i) {
                this.placeBlockToPosition(stack, world, player, (BlockPosStateDist)positions.get(i));
            }
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && mode != Mode.WALLS && mode != Mode.CUBE && mode != Mode.REPLACE && this.getMovePosition(stack, mode)) {
                this.setPosition(stack, pos.offset(pos.side, 1), true);
            }
        } else {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskBuildersWand task = new TaskBuildersWand(world, wandUUID, positions, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    public static boolean hasEnoughCharge(ItemStack stack, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return UtilItemModular.useEnderCharge(stack, 2, true);
    }

    public static boolean canManipulateBlock(World world, BlockPos pos, EntityPlayer player, ItemStack stack, boolean allowTileEntities) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return true;
        }
        float hardness = state.func_185887_b(world, pos);
        return hardness >= 0.0f && hardness <= Configs.buildersWandMaxBlockHardness && (allowTileEntities || !state.func_177230_c().hasTileEntity(state));
    }

    public boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPosStateDist posStateDist) {
        BlockInfo blockInfo = this.getSelectionIndex(wandStack) == -2 ? this.getBlockInfoForAdjacentBlock(world, posStateDist.toBlockPos(), posStateDist.side) : posStateDist.blockInfo;
        if (blockInfo == null || blockInfo.block == Blocks.field_150350_a) {
            return false;
        }
        return this.placeBlockToPosition(wandStack, world, player, posStateDist.toBlockPos(), posStateDist.side, blockInfo.blockStateActual, 3, true, true);
    }

    public boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState newState, int setBlockStateFlags, boolean requireItems, boolean dropItems) {
        if (newState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        boolean replace = this.getReplaceExisting(wandStack, Mode.getMode(wandStack));
        boolean isAir = world.func_175623_d(pos);
        if (player.field_71075_bZ.field_75098_d) {
            if (replace || isAir) {
                BlockUtils.placeBlock(world, pos, newState, setBlockStateFlags);
                return true;
            }
            return false;
        }
        if (!(ItemBuildersWand.hasEnoughCharge(wandStack, player) && (isAir || replace && ItemBuildersWand.canManipulateBlock(world, pos, player, wandStack, false)))) {
            return false;
        }
        ItemStack targetStack = null;
        Block blockNew = newState.func_177230_c();
        if (requireItems) {
            targetStack = ItemBuildersWand.getAndConsumeBuildItem(wandStack, world, pos, newState, player, false);
        }
        if (targetStack != null || !requireItems) {
            if (replace && !isAir && player instanceof EntityPlayerMP) {
                if (dropItems) {
                    BlockUtils.breakBlockAsPlayer(world, pos, (EntityPlayerMP)player, wandStack);
                    if (!world.func_175623_d(pos)) {
                        return false;
                    }
                } else {
                    world.restoringBlockSnapshots = true;
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    world.restoringBlockSnapshots = false;
                }
            }
            if (!requireItems || BlockUtils.checkCanPlaceBlockAt(world, pos, side, blockNew, targetStack)) {
                BlockUtils.placeBlock(world, pos, newState, setBlockStateFlags);
                if (!player.field_71075_bZ.field_75098_d) {
                    UtilItemModular.useEnderCharge(wandStack, 2, false);
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack getAndConsumeBuildItem(ItemStack wandStack, World world, BlockPos pos, IBlockState newState, EntityPlayer player, boolean simulate) {
        ItemStack templateStack = BlockUtils.getStackedItemFromBlock(world, pos, newState, player, EnumFacing.UP);
        if (templateStack == null) {
            return null;
        }
        IItemHandler inv = ItemBuildersWand.getInventoryWithItems(wandStack, templateStack, player);
        return ItemBuildersWand.consumeBuildItem(inv, templateStack, 1, simulate);
    }

    private static IItemHandler getInventoryWithItems(ItemStack wandStack, ItemStack templateStack, EntityPlayer player) {
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack);
        if (slot != -1) {
            return inv;
        }
        inv = UtilItemModular.getBoundInventory(wandStack, player, 30);
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack)) != -1) {
            return inv;
        }
        return null;
    }

    private static ItemStack consumeBuildItem(IItemHandler inv, ItemStack templateStack, int amount, boolean simulate) {
        int slot;
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack)) != -1) {
            return inv.extractItem(slot, amount, simulate);
        }
        return null;
    }

    private void setSelectedFixedBlockType(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        int sel = this.getSelectionIndex(stack);
        if (sel < 0) {
            return;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, true);
        IBlockState state = world.func_180495_p(pos);
        tag.func_74778_a("BlockName", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()).toString());
        tag.func_74774_a("BlockMeta", (byte)state.func_177230_c().func_176201_c(state));
        ItemStack stackTmp = state.func_177230_c().getPickBlock(state, EntityUtils.getRayTraceFromPlayer(world, player, false), world, pos, player);
        int itemMeta = stackTmp != null ? stackTmp.func_77960_j() : 0;
        tag.func_74777_a("ItemMeta", (short)itemMeta);
    }

    public BlockInfo getSelectedFixedBlockType(ItemStack stack) {
        int sel = this.getSelectionIndex(stack);
        if (sel < 0) {
            return null;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, false);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, false);
        if (tag != null && tag.func_150297_b("BlockName", 8)) {
            return new BlockInfo(new ResourceLocation(tag.func_74779_i("BlockName")), (int)tag.func_74771_c("BlockMeta"), (int)tag.func_74765_d("ItemMeta"));
        }
        return null;
    }

    public int getSelectionIndex(ItemStack stack) {
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + Mode.getMode(stack).getName(), true);
        return tag.func_74771_c(TAG_NAME_BLOCK_SEL);
    }

    private void changeSelectionIndex(ItemStack stack, boolean reverse) {
        Mode mode = Mode.getMode(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        int min = mode == Mode.COPY || mode == Mode.PASTE || mode == Mode.DELETE || mode == Mode.MOVE_SRC || mode == Mode.MOVE_DST || mode == Mode.REPLACE ? 0 : -2;
        NBTUtils.cycleByteValue(tag, TAG_NAME_BLOCK_SEL, min, 15, reverse);
    }

    private void toggleMirror(ItemStack stack, Mode mode, EntityPlayer player) {
        Mirror mirror;
        Mirror mirror2 = mirror = player.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        if (mirror == this.getMirror(stack) && this.isMirrored(stack)) {
            mirror = Mirror.NONE;
        }
        this.setMirror(stack, mode, mirror);
    }

    private void setMirror(ItemStack stack, Mode mode, Mirror mirror) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag.func_74774_a("Mirror_" + sel, (byte)mirror.ordinal());
        tag.func_74757_a("IsMirrored_" + sel, mirror != Mirror.NONE);
    }

    public boolean isMirrored(ItemStack stack) {
        int sel = this.getSelectionIndex(stack);
        return this.getModeTag(stack, Mode.getMode(stack)).func_74767_n("IsMirrored_" + sel);
    }

    public Mirror getMirror(ItemStack stack) {
        return this.getMirror(stack, Mode.getMode(stack));
    }

    public Mirror getMirror(ItemStack stack, Mode mode) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        if (tag.func_74767_n("IsMirrored_" + sel) && tag.func_150297_b("Mirror_" + sel, 1)) {
            return Mirror.values()[tag.func_74771_c("Mirror_" + sel) % Mirror.values().length];
        }
        return Mirror.NONE;
    }

    public boolean getAreaFlipped(ItemStack stack) {
        return this.getModeTag(stack, Mode.getMode(stack)).func_74767_n("Flip");
    }

    private void toggleAreaFlipped(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = this.getModeTag(stack, Mode.getMode(stack));
        EnumFacing facing = EntityUtils.getClosestLookingDirection((Entity)player);
        tag.func_74774_a("FlipAxis", (byte)facing.func_176745_a());
        tag.func_74757_a("Flip", !tag.func_74767_n("Flip"));
    }

    public EnumFacing getAreaFlipAxis(ItemStack stack, EnumFacing defaultFlipAxis) {
        NBTTagCompound tag = this.getModeTag(stack, Mode.getMode(stack));
        if (tag.func_150297_b("FlipAxis", 1)) {
            return EnumFacing.func_82600_a((int)tag.func_74771_c("FlipAxis"));
        }
        return defaultFlipAxis;
    }

    private EnumFacing getAxisRight(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.side;
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
        }
        return axisRight;
    }

    private EnumFacing getAxisUp(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.side;
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(face, axisRight);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
        }
        return axisUp;
    }

    private void changeAreaDimensions(EntityPlayer player, ItemStack stack, boolean reverse) {
        EnumFacing lookDir;
        EnumFacing faceAxisFlipped;
        Mode mode = Mode.getMode(stack);
        if (mode.hasTwoPlacableCorners()) {
            this.moveEndPosition(stack, EntityUtils.getClosestLookingDirection((Entity)player), reverse);
            return;
        }
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null || mode == Mode.PASTE || mode == Mode.MOVE_DST) {
            return;
        }
        int amount = reverse ? 1 : -1;
        Area area = new Area(this.getModeTag(stack, mode));
        if (mode == Mode.COLUMN) {
            area.adjustFromPlanarizedFacing(EnumFacing.EAST, amount, EnumFacing.UP, EnumFacing.EAST);
            area.writeToNBT(this.getModeTag(stack, mode));
            return;
        }
        EnumFacing faceAxis = pos.side;
        EnumFacing axisRight = this.getAxisRight(stack, pos);
        EnumFacing axisUp = this.getAxisUp(stack, pos);
        boolean isFlipped = this.getAreaFlipped(stack);
        EnumFacing flipAxis = this.getAreaFlipAxis(stack, faceAxis);
        EnumFacing enumFacing = faceAxisFlipped = isFlipped ? BlockPosEU.getRotation(faceAxis, flipAxis) : faceAxis;
        if (faceAxisFlipped == EnumFacing.UP || faceAxisFlipped == EnumFacing.DOWN) {
            lookDir = EntityUtils.getHorizontalLookingDirection((Entity)player);
        } else {
            EntityUtils.LeftRight leftRight;
            lookDir = EntityUtils.getClosestLookingDirection((Entity)player);
            lookDir = Math.abs(player.field_70125_A) > 20.0f && (lookDir.func_176740_k() == faceAxisFlipped.func_176740_k() || lookDir.func_176740_k() == EnumFacing.Axis.Y) ? EntityUtils.getVerticalLookingDirection((Entity)player) : ((leftRight = EntityUtils.getLookLeftRight((Entity)player, faceAxisFlipped)) == EntityUtils.LeftRight.RIGHT ? BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.DOWN) : BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.UP));
        }
        area.adjustFromPlanarizedFacing(lookDir, amount, axisUp, axisRight);
        area.writeToNBT(this.getModeTag(stack, mode));
    }

    private void moveEndPosition(ItemStack stack, EnumFacing direction, boolean reverse) {
        Mode mode = Mode.getMode(stack);
        BlockPosEU posStart = mode == Mode.CUBE || mode == Mode.WALLS ? this.getPosition(stack, mode, true) : this.getPerTemplateAreaCorner(stack, mode, true);
        BlockPosEU posEnd = this.getPosition(stack, mode, false);
        if (posEnd == null) {
            posEnd = posStart;
        }
        if (posStart != null && posEnd != null) {
            int v = reverse ? 1 : -1;
            posEnd = posEnd.add(direction.func_82601_c() * v, direction.func_96559_d() * v, direction.func_82599_e() * v);
            if (mode == Mode.WALLS || mode == Mode.CUBE) {
                this.setPosition(stack, posEnd, false);
            } else {
                this.setPerTemplateAreaCorner(stack, mode, false, posEnd);
                this.setAreaFacing(stack, mode, PositionUtils.getFacingFromPositions(posStart, posEnd));
                this.setMirror(stack, mode, Mirror.NONE);
            }
        }
    }

    private List<BlockPosStateDist> getPositionsOnPlane(ItemStack stack, Mode mode, World world, BlockPosEU posStart, EnumFacing axisRight, EnumFacing axisUp) {
        BlockPosEU pos = posStart;
        Area area = new Area(this.getModeTag(stack, mode));
        BlockPos pos1 = posStart.toBlockPos().func_177967_a(axisRight, -area.rNegH).func_177967_a(axisUp, -area.rNegV);
        BlockPos pos2 = posStart.toBlockPos().func_177967_a(axisRight, area.rPosH).func_177967_a(axisUp, area.rPosV);
        BlockPos posMin = PositionUtils.getMinCorner(pos1, pos2);
        BlockPos posMax = PositionUtils.getMaxCorner(pos1, pos2);
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        ArrayList<BlockPosEU> branches = new ArrayList<BlockPosEU>();
        HashSet<BlockPosEU> visited = new HashSet<BlockPosEU>();
        boolean continueThrough = mode != Mode.EXTEND_CONTINUOUS && this.getContinueThrough(stack, mode);
        boolean diagonals = mode == Mode.EXTEND_CONTINUOUS && this.getAllowDiagonals(stack, mode);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, posStart.offset(posStart.side, -1).toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int branchIndex = 0;
        BlockPosEU nextPos = null;
        for (int counter = 0; counter <= 16641; ++counter) {
            nextPos = this.checkPositionIgnoringSide(mode, world, pos, posMin, posMax, visited, branches, positions, continueThrough, diagonals, blockType, biTarget, biBound);
            if (nextPos == null) {
                if (branchIndex >= branches.size()) break;
                pos = (BlockPosEU)branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = nextPos;
        }
        return positions;
    }

    private BlockPosEU checkPositionIgnoringSide(Mode mode, World world, BlockPosEU posIn, BlockPos posMin, BlockPos posMax, Set<BlockPosEU> visited, List<BlockPosEU> branches, List<BlockPosStateDist> positions, boolean continueThrough, boolean diagonals, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        BlockPos posTmp = posIn.toBlockPos();
        BlockPosEU continueTo = null;
        int sides = 0;
        if (visited.contains(posIn) || !PositionUtils.isPositionInsideArea(posIn, posMin, posMax)) {
            return null;
        }
        if (world.func_175623_d(posTmp)) {
            if (mode == Mode.EXTEND_AREA || mode == Mode.EXTEND_CONTINUOUS) {
                BlockPos posTgt = posTmp.func_177967_a(posIn.side, -1);
                IBlockState state = world.func_180495_p(posTgt);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (!block.isAir(state, (IBlockAccess)world, posTgt) && !state.func_185904_a().func_76224_d() && (blockType == -2 || blockType >= 0 && biBound != null || biTarget != null && biTarget.block == block && biTarget.blockMeta == meta)) {
                    positions.add(new BlockPosStateDist(posIn, this.getBlockInfoForBlockType(world, posTmp, posIn.side, blockType, biTarget, biBound)));
                } else if (mode == Mode.EXTEND_CONTINUOUS) {
                    return null;
                }
            } else {
                positions.add(new BlockPosStateDist(posIn, this.getBlockInfoForBlockType(world, posTmp, posIn.side, blockType, biTarget, biBound)));
            }
        } else if (!continueThrough) {
            return null;
        }
        visited.add(posIn);
        for (BlockPosEU pos : PositionUtils.getAdjacentPositions(posIn, posIn.side, diagonals)) {
            if (visited.contains(pos) || !PositionUtils.isPositionInsideArea(pos, posMin, posMax) || !world.func_175623_d(pos.toBlockPos()) && !continueThrough) continue;
            if (!visited.contains(pos)) {
                if (sides == 0) {
                    continueTo = pos;
                } else if (!branches.contains(pos)) {
                    branches.add(pos);
                }
            }
            ++sides;
        }
        return continueTo;
    }

    private List<BlockPosStateDist> getReplacePositions(ItemStack stack, World world, BlockPosEU posStart, EnumFacing axisRight, EnumFacing axisUp) {
        Area area = new Area(this.getModeTag(stack, Mode.REPLACE));
        BlockPos pos1 = posStart.toBlockPos().func_177967_a(axisRight, -area.rNegH).func_177967_a(axisUp, -area.rNegV);
        BlockPos pos2 = posStart.toBlockPos().func_177967_a(axisRight, area.rPosH).func_177967_a(axisUp, area.rPosV);
        BlockPos posMin = PositionUtils.getMinCorner(pos1, pos2);
        BlockPos posMax = PositionUtils.getMaxCorner(pos1, pos2);
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        boolean diagonals = this.getAllowDiagonals(stack, Mode.REPLACE);
        BlockPos pos = posStart.toBlockPos();
        BlockInfo biTarget = BlockInfo.getBlockInfo(world, pos);
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        if (biTarget == null || biBound == null) {
            return positions;
        }
        int branchIndex = 0;
        BlockPos nextPos = null;
        for (int counter = 0; counter <= 16641; ++counter) {
            nextPos = this.checkReplacePositionIgnoringSide(world, pos, posStart.side, posMin, posMax, visited, branches, positions, diagonals, biTarget, biBound);
            if (nextPos == null) {
                if (branchIndex >= branches.size()) break;
                pos = (BlockPos)branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = nextPos;
        }
        return positions;
    }

    private BlockPos checkReplacePositionIgnoringSide(World world, BlockPos posIn, EnumFacing side, BlockPos posMin, BlockPos posMax, Set<BlockPos> visited, List<BlockPos> branches, List<BlockPosStateDist> positions, boolean diagonals, BlockInfo biTarget, BlockInfo biBound) {
        BlockPos pos = posIn;
        BlockPos continueTo = null;
        int sides = 0;
        if (visited.contains(pos) || !PositionUtils.isPositionInsideArea(pos, posMin, posMax)) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state == biTarget.blockState) {
            BlockPos posAdj = pos.func_177972_a(side);
            IBlockState stateAdj = world.func_180495_p(posAdj);
            Block blockAdj = stateAdj.func_177230_c();
            if (!blockAdj.isAir(stateAdj, (IBlockAccess)world, posAdj) && stateAdj.isSideSolid((IBlockAccess)world, posAdj, side.func_176734_d())) {
                return null;
            }
        } else {
            return null;
        }
        positions.add(new BlockPosStateDist(posIn, world.field_73011_w.getDimension(), side, biBound));
        visited.add(pos);
        for (BlockPos posTmp : PositionUtils.getAdjacentPositions(pos, side, diagonals)) {
            if (visited.contains(posTmp) || !PositionUtils.isPositionInsideArea(posTmp, posMin, posMax) || world.func_180495_p(posTmp) != biTarget.blockState) continue;
            if (!visited.contains(posTmp)) {
                if (sides == 0) {
                    continueTo = posTmp;
                } else if (!branches.contains(posTmp)) {
                    branches.add(posTmp);
                }
            }
            ++sides;
        }
        return continueTo;
    }

    private BlockInfo getBlockInfoForAdjacentBlock(World world, BlockPos pos, EnumFacing side) {
        return BlockInfo.getBlockInfo(world, pos.func_177967_a(side, -1));
    }

    private BlockInfo getBlockInfoForTargeted(ItemStack stack, World world, BlockPos pos) {
        int blockType = this.getSelectionIndex(stack);
        if (blockType == -1 || blockType == -2) {
            return BlockInfo.getBlockInfo(world, pos);
        }
        if (blockType >= 0) {
            return this.getSelectedFixedBlockType(stack);
        }
        return null;
    }

    private BlockInfo getBlockInfoForBlockType(World world, BlockPos pos, EnumFacing side, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        if (blockType == -1) {
            return biTarget;
        }
        if (blockType == -2) {
            return this.getBlockInfoForAdjacentBlock(world, pos, side);
        }
        if (blockType >= 0) {
            return biBound;
        }
        return null;
    }

    public void getBlockPositions(ItemStack stack, World world, EntityPlayer player, List<BlockPosStateDist> positions, BlockPosEU center) {
        BlockPosEU flippedCenter = center;
        EnumFacing side = center.side;
        EnumFacing axisRight = BlockPosEU.getRotation(side, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(side, axisRight);
        if (side == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(side, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(side, axisRight);
        } else if (side == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(side, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(side, axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, side);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
            if (flipAxis.func_176740_k() != center.side.func_176740_k()) {
                flippedCenter = new BlockPosEU(center.toBlockPos(), center.dimension, BlockPosEU.getRotation(center.side, flipAxis));
            }
        }
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, center.offset(side, -1).toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        Mode mode = Mode.getMode(stack);
        Area area = new Area(this.getModeTag(stack, mode));
        int dim = world.field_73011_w.getDimension();
        boolean continueThrough = this.getContinueThrough(stack, mode);
        block0 : switch (mode) {
            case COLUMN: {
                for (int i = 0; i <= area.rPosH; ++i) {
                    BlockPosEU posTmp = center.offset(side, i);
                    if (world.func_175623_d(posTmp.toBlockPos())) {
                        positions.add(new BlockPosStateDist(posTmp, biTarget));
                        continue;
                    }
                    if (!continueThrough) break block0;
                }
                break;
            }
            case LINE: {
                BlockPos posTmp;
                int i;
                for (i = 0; i <= area.rPosH; ++i) {
                    posTmp = center.offset(axisRight, i).toBlockPos();
                    if (world.func_175623_d(posTmp)) {
                        positions.add(new BlockPosStateDist(posTmp, dim, side, this.getBlockInfoForBlockType(world, posTmp, side, blockType, biTarget, biBound)));
                        continue;
                    }
                    if (!continueThrough) break;
                }
                i = -1;
                while (-i <= area.rNegH) {
                    posTmp = center.offset(axisRight, i).toBlockPos();
                    if (world.func_175623_d(posTmp)) {
                        positions.add(new BlockPosStateDist(posTmp, dim, side, this.getBlockInfoForBlockType(world, posTmp, side, blockType, biTarget, biBound)));
                    } else if (!continueThrough) break block0;
                    --i;
                }
                break;
            }
            case PLANE: 
            case EXTEND_AREA: 
            case EXTEND_CONTINUOUS: {
                positions.addAll(this.getPositionsOnPlane(stack, mode, world, flippedCenter, axisRight, axisUp));
                break;
            }
            case REPLACE: {
                if (this.getReplaceModeIsArea(stack)) {
                    positions.addAll(this.getReplacePositions(stack, world, center, axisRight, axisUp));
                    break;
                }
                positions.add(new BlockPosStateDist(center, biBound));
                break;
            }
        }
    }

    public void getBlockPositionsWalls(ItemStack stack, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        int z;
        int z2;
        int y;
        int x;
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        BlockPosEU targeted = pos1.offset(pos1.side, -1);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int dim = world.field_73011_w.getDimension();
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, startZ, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, startZ), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, endZ, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, endZ), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, startY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, startY, z2), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, endY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, endY, z2), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(startX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(startX, y, z), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(endX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(endX, y, z), targeted.side, blockType, biTarget, biBound)));
            }
        }
    }

    private void getBlockPositionsCube(ItemStack stack, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        BlockPosEU targeted = pos1.offset(pos1.side, -1);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int dim = world.field_73011_w.getDimension();
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, pos1.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, z), targeted.side, blockType, biTarget, biBound)));
                }
            }
        }
    }

    private EnumActionResult copyAreaToTemplate(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn, BlockPosEU posEndIn) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableCopyMode) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]));
            return EnumActionResult.FAIL;
        }
        if (posStartIn == null || posEndIn == null || posStartIn.dimension != player.field_71093_bK || posEndIn.dimension != player.field_71093_bK) {
            return EnumActionResult.FAIL;
        }
        BlockPos posStart = posStartIn.toBlockPos();
        BlockPos endOffset = posEndIn.toBlockPos().func_177973_b((Vec3i)posStart);
        if (!this.isAreaWithinSizeLimit(endOffset, player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[]{this.getMaxAreaDimension(player)}));
            return EnumActionResult.FAIL;
        }
        if (posStartIn.dimension != player.field_71093_bK || posEndIn.dimension != player.field_71093_bK || player.func_174818_b(posStartIn.toBlockPos()) > 25600.0) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]));
            return EnumActionResult.FAIL;
        }
        ResourceLocation templateLocation = this.getTemplateResource(stack, player);
        boolean success = this.saveAreaToTemplate(world, posStart, endOffset, templateLocation, this.getTemplateName(stack, Mode.COPY), player.func_70005_c_());
        if (success) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areasavedtotemplate", new Object[]{this.getSelectionIndex(stack) + 1}));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.failedtosaveareatotemplate", new Object[0]));
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean saveAreaToTemplate(World world, BlockPos posStart, BlockPos endOffset, ResourceLocation templateLocation, String templateName, String author) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        TemplateEnderUtilities template = templateManager.getTemplate(templateLocation);
        template.takeBlocksFromWorld(world, posStart, endOffset, true);
        template.setAuthor(author);
        boolean success = templateManager.writeTemplate(templateLocation);
        TemplateMetadata templateMeta = templateManager.getTemplateMetadata(templateLocation);
        EnumFacing facing = PositionUtils.getFacingFromPositions(posStart, posStart.func_177971_a((Vec3i)endOffset));
        templateMeta.setValues(endOffset, facing, templateName, author);
        templateManager.writeTemplateMetadata(templateLocation);
        return success;
    }

    private EnumActionResult pasteAreaIntoWorld(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn) {
        if (posStartIn == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnablePasteMode) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]));
            return EnumActionResult.FAIL;
        }
        if (posStartIn.dimension != player.field_71093_bK || player.func_174818_b(posStartIn.toBlockPos()) > 25600.0) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]));
            return EnumActionResult.FAIL;
        }
        TemplateMetadata templateMeta = this.getTemplateMetadata(stack, player);
        if (!this.isAreaWithinSizeLimit(templateMeta.getRelativeEndPosition(), player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[]{this.getMaxAreaDimension(player)}));
            return EnumActionResult.FAIL;
        }
        PlacementSettings placement = this.getPasteModePlacement(stack, player);
        TemplateEnderUtilities template = this.getTemplate(world, player, stack, placement);
        if (player.field_71075_bZ.field_75098_d) {
            template.setReplaceMode(this.getReplaceExisting(stack, Mode.PASTE) ? TemplateEnderUtilities.ReplaceMode.EVERYTHING : TemplateEnderUtilities.ReplaceMode.NOTHING);
            template.addBlocksToWorld(world, posStartIn.toBlockPos());
        } else {
            template.setReplaceMode(TemplateEnderUtilities.ReplaceMode.NOTHING);
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskTemplatePlaceBlocks task = new TaskTemplatePlaceBlocks(template, posStartIn.toBlockPos(), player.field_71093_bK, player.func_110124_au(), wandUUID, Configs.buildersWandBlocksPerTick, false, false);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult deleteArea(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn, BlockPosEU posEndIn) {
        if (posStartIn == null || posEndIn == null) {
            return EnumActionResult.PASS;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.creativeonly", new Object[0]));
            return EnumActionResult.FAIL;
        }
        this.deleteArea(world, player, posStartIn.toBlockPos(), posEndIn.toBlockPos(), this.getRemoveEntities(stack));
        return EnumActionResult.SUCCESS;
    }

    private void deleteArea(World world, EntityPlayer player, BlockPos posStart, BlockPos posEnd, boolean removeEntities) {
        if (posStart == null || posEnd == null) {
            return;
        }
        if (player.func_174818_b(posStart) > 25600.0) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]));
        }
        if (!this.isAreaWithinSizeLimit(posStart.func_177973_b((Vec3i)posEnd), player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[0]));
            return;
        }
        for (BlockPos.MutableBlockPos posMutable : BlockPos.func_177975_b((BlockPos)posStart, (BlockPos)posEnd)) {
            if (world.func_175623_d((BlockPos)posMutable)) continue;
            world.restoringBlockSnapshots = true;
            world.func_180501_a((BlockPos)posMutable, Blocks.field_150350_a.func_176223_P(), 2);
            world.restoringBlockSnapshots = false;
        }
        if (removeEntities) {
            int x1 = Math.min(posStart.func_177958_n(), posEnd.func_177958_n());
            int y1 = Math.min(posStart.func_177956_o(), posEnd.func_177956_o());
            int z1 = Math.min(posStart.func_177952_p(), posEnd.func_177952_p());
            int x2 = Math.max(posStart.func_177958_n(), posEnd.func_177958_n());
            int y2 = Math.max(posStart.func_177956_o(), posEnd.func_177956_o());
            int z2 = Math.max(posStart.func_177952_p(), posEnd.func_177952_p());
            AxisAlignedBB bb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)(x2 + 1), (double)(y2 + 1), (double)(z2 + 1));
            List entities = world.func_72839_b(null, bb);
            for (Entity entity : entities) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70106_y();
            }
        }
    }

    private EnumActionResult moveArea(ItemStack stack, World world, EntityPlayer player, BlockPosEU posDst1EU, BlockPosEU posDst2EU) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableMoveMode) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]));
            return EnumActionResult.FAIL;
        }
        BlockPosEU posSrc1EU = this.getPosition(stack, Mode.MOVE_SRC, true);
        BlockPosEU posSrc2EU = this.getPosition(stack, Mode.MOVE_SRC, false);
        if (posSrc1EU == null || posSrc2EU == null || posDst1EU == null || posDst2EU == null) {
            return EnumActionResult.FAIL;
        }
        int dim = world.field_73011_w.getDimension();
        BlockPos posDst1 = posDst1EU.toBlockPos();
        BlockPos posDst2 = posDst2EU.toBlockPos();
        if (player.func_174818_b(posDst1) > 16384.0 || player.func_174818_b(posDst2) > 16384.0 || !this.isAreaWithinSizeLimit(posDst2.func_177973_b((Vec3i)posDst1), player) || posSrc1EU.dimension != dim || posSrc2EU.dimension != dim || posDst1EU.dimension != dim || posDst2EU.dimension != dim) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolargeortoofar", new Object[0]));
            return EnumActionResult.FAIL;
        }
        BlockPos posSrc1 = posSrc1EU.toBlockPos();
        BlockPos posSrc2 = posSrc2EU.toBlockPos();
        EnumFacing origFacing = PositionUtils.getFacingFromPositions(posSrc1, posSrc2);
        EnumFacing areaFacing = this.getAreaFacing(stack, Mode.MOVE_DST);
        if (areaFacing == null) {
            areaFacing = origFacing;
        }
        Rotation rotation = PositionUtils.getRotation(origFacing, areaFacing);
        Mirror mirror = this.getMirror(stack, Mode.MOVE_DST);
        if (posSrc1.equals((Object)posDst1) && rotation == Rotation.NONE && mirror == Mirror.NONE) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.builderswand.areasarethesame", new Object[0]));
            return EnumActionResult.FAIL;
        }
        int id = this.getSelectionIndex(stack);
        UUID uuid = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        String name = player.func_70005_c_();
        ResourceLocation rl = new ResourceLocation("enderutilities", "move_src_" + name + "_" + uuid.toString() + "_" + id);
        boolean success = this.saveAreaToTemplate(world, posSrc1, posSrc2.func_177973_b((Vec3i)posSrc1), rl, "Move source", name);
        if (!success) {
            return EnumActionResult.FAIL;
        }
        rl = new ResourceLocation("enderutilities", "move_dst_" + name + "_" + uuid.toString() + "_" + id);
        success = this.saveAreaToTemplate(world, posDst1, posDst2.func_177973_b((Vec3i)posDst1), rl, "Move destination", name);
        if (!success) {
            return EnumActionResult.FAIL;
        }
        if (player.field_71075_bZ.field_75098_d) {
            this.moveAreaImmediate(world, player, posSrc1, posSrc2, posDst1, mirror, rotation);
        } else {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskMoveArea task = new TaskMoveArea(world.field_73011_w.getDimension(), posSrc1, posSrc2, posDst1, rotation, mirror, wandUUID, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    private void moveAreaImmediate(World world, EntityPlayer player, BlockPos posSrc1, BlockPos posSrc2, BlockPos posDst1, Mirror mirror, Rotation rotation) {
        PlacementSettings placement = new PlacementSettings();
        placement.func_186214_a(mirror);
        placement.func_186220_a(rotation);
        placement.func_186222_a(false);
        placement.func_186225_a(Blocks.field_180401_cv);
        TemplateEnderUtilities template = new TemplateEnderUtilities(placement, TemplateEnderUtilities.ReplaceMode.EVERYTHING);
        template.takeBlocksFromWorld(world, posSrc1, posSrc2.func_177973_b((Vec3i)posSrc1), true);
        this.deleteArea(world, player, posSrc1, posSrc2, true);
        template.addBlocksToWorld(world, posDst1);
    }

    private EnumActionResult replaceBlocks(ItemStack stack, World world, EntityPlayer player, BlockPosEU center) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableReplaceMode) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]));
            return EnumActionResult.FAIL;
        }
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        if (biBound == null || biBound.blockState == world.func_180495_p(center.toBlockPos())) {
            return EnumActionResult.FAIL;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        this.getBlockPositions(stack, world, player, positions, center);
        UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        TaskReplaceBlocks task = new TaskReplaceBlocks(world, wandUUID, positions, Configs.buildersWandReplaceBlocksPerTick);
        PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        return EnumActionResult.SUCCESS;
    }

    private void placeHelperBlock(EntityPlayer player) {
        BlockPos pos = PositionUtils.getPositionInfrontOfEntity((Entity)player);
        player.field_70170_p.func_180501_a(pos, Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)), 3);
    }

    private int getMaxAreaDimension(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 128 : 64;
    }

    private boolean isAreaWithinSizeLimit(BlockPos size, EntityPlayer player) {
        int limit = this.getMaxAreaDimension(player);
        return Math.abs(size.func_177958_n()) <= limit && Math.abs(size.func_177956_o()) <= limit && Math.abs(size.func_177952_p()) <= limit;
    }

    private TemplateEnderUtilities getTemplate(World world, EntityPlayer player, ItemStack stack, PlacementSettings placement) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateEnderUtilities template = templateManager.getTemplate(rl);
        template.setPlacementSettings(placement);
        return template;
    }

    private TemplateMetadata getTemplateMetadata(ItemStack stack, EntityPlayer player) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateMetadata templateMeta = templateManager.getTemplateMetadata(rl);
        return templateMeta;
    }

    public String getTemplateName(ItemStack stack, Mode mode) {
        NBTTagCompound nbt = this.getSelectedTemplateTag(stack, mode, false);
        if (nbt != null && nbt.func_74764_b("TemplateName")) {
            return nbt.func_74779_i("TemplateName");
        }
        return "N/A";
    }

    public void setTemplateName(ItemStack stack, EntityPlayer player, String name) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateMetadata meta = templateManager.getTemplateMetadata(rl);
        meta.setTemplateName(name);
        templateManager.writeTemplateMetadata(rl);
        this.setTemplateNameOnItem(stack, Mode.COPY, name);
        this.updateTemplateMetadata(stack, player);
    }

    public void setTemplateNameOnItem(ItemStack stack, Mode mode, String name) {
        NBTTagCompound nbt = this.getSelectedTemplateTag(stack, mode, true);
        nbt.func_74778_a("TemplateName", name);
    }

    private ResourceLocation getTemplateResource(ItemStack stack, EntityPlayer player) {
        int id = this.getSelectionIndex(stack);
        UUID uuid = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        String name = NBTUtils.getOrCreateString(stack, WRAPPER_TAG_NAME, "player", player.func_70005_c_());
        return new ResourceLocation("enderutilities", name + "_" + uuid.toString() + "_" + id);
    }

    private TemplateManagerEU getTemplateManager() {
        File saveDir = DimensionManager.getCurrentSaveRootDirectory();
        if (saveDir == null) {
            return null;
        }
        return new TemplateManagerEU(new File(new File(saveDir, "enderutilities"), this.name));
    }

    private NBTTagCompound getSelectedTemplateTag(ItemStack stack, Mode mode, boolean create) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag = NBTUtils.getCompoundTag(tag, "Templates_" + sel, create);
        return tag;
    }

    private void updateTemplateMetadata(ItemStack stack, EntityPlayer player) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateManagerEU.FileInfo info = templateManager.getTemplateInfo(rl);
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, Mode.PASTE, true);
        if (tag.func_74763_f("Timestamp") != info.timestamp || tag.func_74763_f("FileSize") != info.fileSize) {
            TemplateMetadata meta = templateManager.getTemplateMetadata(rl);
            BlockPos size = meta.getRelativeEndPosition();
            tag.func_74772_a("TimeStamp", info.timestamp);
            tag.func_74772_a("FileSize", info.fileSize);
            tag.func_74768_a("endOffsetX", size.func_177958_n());
            tag.func_74768_a("endOffsetY", size.func_177956_o());
            tag.func_74768_a("endOffsetZ", size.func_177952_p());
            tag.func_74774_a("TemplateFacing", (byte)meta.getFacing().func_176745_a());
            tag.func_74778_a("TemplateName", meta.getTemplateName());
            this.setTemplateNameOnItem(stack, Mode.COPY, meta.getTemplateName());
        }
    }

    public EnumFacing getTemplateFacing(ItemStack stack) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, Mode.PASTE, true);
        return EnumFacing.func_82600_a((int)tag.func_74771_c("TemplateFacing"));
    }

    public EnumFacing getAreaFacing(ItemStack stack, Mode mode) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, true);
        if (tag.func_150297_b("Rotation", 1)) {
            return EnumFacing.func_82600_a((int)tag.func_74771_c("Rotation"));
        }
        BlockPosEU posStart = this.getPerTemplateAreaCorner(stack, mode, true);
        BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
        if (posStart != null && posEnd != null) {
            return PositionUtils.getFacingFromPositions(posStart, posEnd);
        }
        return null;
    }

    private void setAreaFacing(ItemStack stack, Mode mode, EntityPlayer player) {
        this.setAreaFacing(stack, mode, player.func_174811_aO());
    }

    private void setAreaFacing(ItemStack stack, Mode mode, EnumFacing facing) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, true);
        tag.func_74774_a("Rotation", (byte)facing.func_176745_a());
    }

    private void toggleMovePosition(ItemStack stack, Mode mode) {
        NBTTagCompound tag;
        tag.func_74757_a("Move", !(tag = this.getModeTag(stack, mode)).func_74767_n("Move"));
    }

    public boolean getMovePosition(ItemStack stack, Mode mode) {
        return this.getModeTag(stack, mode).func_74767_n("Move");
    }

    private void toggleAllowDiagonals(ItemStack stack, Mode mode) {
        NBTTagCompound tag;
        tag.func_74757_a("Diagonals", !(tag = this.getModeTag(stack, mode)).func_74767_n("Diagonals"));
    }

    public boolean getAllowDiagonals(ItemStack stack, Mode mode) {
        return this.getModeTag(stack, mode).func_74767_n("Diagonals");
    }

    public boolean getRenderGhostBlocks(ItemStack stack, Mode mode) {
        return this.getModeTag(stack, mode).func_74767_n("Ghost");
    }

    private void toggleRenderGhostBlocks(ItemStack stack, Mode mode) {
        NBTTagCompound tag;
        tag.func_74757_a("Ghost", !(tag = this.getModeTag(stack, mode)).func_74767_n("Ghost"));
    }

    private void toggleReplaceExisting(ItemStack stack, Mode mode) {
        NBTTagCompound tag;
        tag.func_74757_a("Replace", !(tag = this.getModeTag(stack, mode)).func_74767_n("Replace"));
    }

    public boolean getReplaceExisting(ItemStack stack, Mode mode) {
        return this.getModeTag(stack, mode).func_74767_n("Replace");
    }

    private void toggleRemoveEntities(ItemStack stack) {
        NBTTagCompound tag;
        tag.func_74757_a("RemoveEntities", !(tag = this.getModeTag(stack, Mode.DELETE)).func_74767_n("RemoveEntities"));
    }

    public boolean getRemoveEntities(ItemStack stack) {
        return this.getModeTag(stack, Mode.DELETE).func_74767_n("RemoveEntities");
    }

    private void toggleContinueThrough(ItemStack stack, Mode mode) {
        NBTTagCompound tag;
        tag.func_74757_a("GoThrough", !(tag = this.getModeTag(stack, mode)).func_74767_n("GoThrough"));
    }

    public boolean getContinueThrough(ItemStack stack, Mode mode) {
        return this.getModeTag(stack, mode).func_74767_n("GoThrough");
    }

    private void toggleReplaceModeIsArea(ItemStack stack) {
        NBTTagCompound tag;
        tag.func_74757_a("AreaMode", !(tag = this.getModeTag(stack, Mode.REPLACE)).func_74767_n("AreaMode"));
    }

    public boolean getReplaceModeIsArea(ItemStack stack) {
        return this.getModeTag(stack, Mode.REPLACE).func_74767_n("AreaMode");
    }

    private PlacementSettings getPasteModePlacement(ItemStack stack, EntityPlayer player) {
        EnumFacing facing = this.getTemplateFacing(stack);
        EnumFacing areaFacing = this.getAreaFacing(stack, Mode.PASTE);
        if (areaFacing == null) {
            areaFacing = facing;
        }
        Rotation rotation = PositionUtils.getRotation(facing, areaFacing);
        boolean ignoreEntities = player == null || !player.field_71075_bZ.field_75098_d;
        PlacementSettings placement = new PlacementSettings();
        placement.func_186214_a(this.getMirror(stack));
        placement.func_186220_a(rotation);
        placement.func_186222_a(ignoreEntities);
        placement.func_186225_a(Blocks.field_180401_cv);
        return placement;
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0x10000000) {
            this.placeHelperBlock(player);
            return;
        }
        Mode mode = Mode.getMode(stack);
        if (HotKeys.EnumKey.SCROLL.matches(key, 262144)) {
            this.changeSelectionIndex(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            if (mode == Mode.PASTE) {
                this.updateTemplateMetadata(stack, player);
            }
        } else if (HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            if (mode != Mode.PASTE && mode != Mode.MOVE_DST) {
                this.changeAreaDimensions(player, stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            }
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            if (mode.isAreaMode()) {
                this.toggleMirror(stack, mode, player);
            } else if (mode != Mode.WALLS || mode != Mode.CUBE) {
                this.toggleMovePosition(stack, mode);
            }
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            Mode.cycleMode(stack, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            if (Mode.getMode(stack) == Mode.PASTE) {
                this.updateTemplateMetadata(stack, player);
            }
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 458752) || HotKeys.EnumKey.SCROLL.matches(key, 458752)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, HotKeys.EnumKey.keypressActionIsReversed(key));
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 393216)) {
            if (mode == Mode.PASTE || mode == Mode.MOVE_DST) {
                this.toggleReplaceExisting(stack, mode);
            } else if (mode == Mode.DELETE) {
                this.toggleRemoveEntities(stack);
            } else if (mode == Mode.EXTEND_CONTINUOUS || mode == Mode.REPLACE) {
                this.toggleAllowDiagonals(stack, mode);
            } else if (mode == Mode.COLUMN || mode == Mode.LINE || mode == Mode.PLANE || mode == Mode.EXTEND_AREA) {
                this.toggleContinueThrough(stack, mode);
            }
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            this.toggleRenderGhostBlocks(stack, mode);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            if (mode == Mode.REPLACE) {
                this.toggleReplaceModeIsArea(stack);
            } else if (mode.isAreaMode() && mode != Mode.COPY) {
                this.setAreaFacing(stack, mode, player);
            } else if (!mode.isAreaMode()) {
                this.toggleAreaFlipped(stack, player);
            }
        }
    }

    @Override
    public void handleString(EntityPlayer player, ItemStack stack, String text) {
        if (stack != null) {
            this.setTemplateName(stack, player, text);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 600;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && imodule.getModuleTier(moduleStack) != 1) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("underutilities:usetime"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemBuildersWand.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 50.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("underutilities:inuse"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public static enum Mode {
        EXTEND_CONTINUOUS("extcont", "enderutilities.tooltip.item.build.extend.continuous"),
        EXTEND_AREA("extarea", "enderutilities.tooltip.item.build.extend.area"),
        LINE("line", "enderutilities.tooltip.item.build.line"),
        PLANE("plane", "enderutilities.tooltip.item.build.plane"),
        COLUMN("column", "enderutilities.tooltip.item.build.column"),
        WALLS("walls", "enderutilities.tooltip.item.build.walls", false, true, true),
        CUBE("cube", "enderutilities.tooltip.item.build.cube", false, true, true),
        COPY("copy", "enderutilities.tooltip.item.build.copy", true, true, true),
        PASTE("paste", "enderutilities.tooltip.item.build.paste", true, false, true),
        DELETE("delete", "enderutilities.tooltip.item.build.delete", true, true, true),
        MOVE_SRC("movesrc", "enderutilities.tooltip.item.build.move.source", true, true, false),
        MOVE_DST("movedst", "enderutilities.tooltip.item.build.move.destination", true, false, true),
        REPLACE("replace", "enderutilities.tooltip.item.build.replace");

        private final String name;
        private final String unlocName;
        private final boolean isAreaMode;
        private final boolean hasTwoCorners;
        private final boolean hasUseDelay;

        private Mode(String name, String unlocName) {
            this(name, unlocName, false, false, false);
        }

        private Mode(String name, String unlocName, boolean isAreaMode, boolean twoCorners, boolean useDelay) {
            this.name = name;
            this.unlocName = unlocName;
            this.isAreaMode = isAreaMode;
            this.hasTwoCorners = twoCorners;
            this.hasUseDelay = useDelay;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocName, (Object[])new Object[0]);
        }

        public boolean isAreaMode() {
            return this.isAreaMode;
        }

        public boolean hasTwoPlacableCorners() {
            return this.hasTwoCorners;
        }

        public boolean hasUseDelay() {
            return this.hasUseDelay;
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.values()[Mode.getModeOrdinal(stack)];
        }

        public static void cycleMode(ItemStack stack, boolean reverse) {
            NBTUtils.cycleByteValue(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE, Mode.values().length - 1, reverse);
        }

        public static int getModeOrdinal(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE);
            return id >= 0 && id < Mode.values().length ? (int)id : 0;
        }
    }

    public class Area {
        public int rPosH;
        public int rNegH;
        public int rPosV;
        public int rNegV;
        public int maxRadius;

        public Area(int packed) {
            this.init(packed);
        }

        public Area(NBTTagCompound tag) {
            if (tag != null) {
                this.init(tag.func_74762_e(ItemBuildersWand.TAG_NAME_DIMENSIONS));
            } else {
                this.init(0);
            }
        }

        public void init(int packed) {
            this.init(packed & 0xFF, packed >> 8 & 0xFF, packed >> 16 & 0xFF, packed >> 24 & 0xFF);
        }

        public void init(int rPosH, int rNegH, int rPosV, int rNegV) {
            this.rPosH = rPosH;
            this.rNegH = rNegH;
            this.rPosV = rPosV;
            this.rNegV = rNegV;
            this.maxRadius = 64;
        }

        public Area adjustFromPlanarizedFacing(EnumFacing facing, int amount, EnumFacing upAxis, EnumFacing rightAxis) {
            if (facing == upAxis) {
                this.rPosV = MathHelper.func_76125_a((int)(this.rPosV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == upAxis.func_176734_d()) {
                this.rNegV = MathHelper.func_76125_a((int)(this.rNegV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis) {
                this.rPosH = MathHelper.func_76125_a((int)(this.rPosH + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis.func_176734_d()) {
                this.rNegH = MathHelper.func_76125_a((int)(this.rNegH + amount), (int)0, (int)this.maxRadius);
            }
            return this;
        }

        public int getPacked() {
            return this.rPosH | this.rNegH << 8 | this.rPosV << 16 | this.rNegV << 24;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a(ItemBuildersWand.TAG_NAME_DIMENSIONS, this.getPacked());
        }
    }
}

