/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemEnderBow
extends ItemLocationBoundModular
implements IKeyBound {
    public static final int ENDER_CHARGE_COST_MOB_TP = 1000;
    public static final byte BOW_MODE_TP_TARGET = 0;
    public static final byte BOW_MODE_TP_SELF = 1;

    public ItemEnderBow() {
        this.func_77625_d(1);
        this.func_77656_e(384);
        this.setNoRepair();
        this.func_77655_b("enderbow");
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int itemInUseCount) {
        EntityPlayer player = null;
        if (livingBase instanceof EntityPlayer) {
            player = (EntityPlayer)livingBase;
        }
        if (this.isBroken(stack)) {
            return;
        }
        byte mode = this.getBowMode(stack);
        if (world.field_72995_K || mode == 0 && player != null && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return;
        }
        if (mode == 1 && !Configs.enderBowAllowSelfTP) {
            return;
        }
        if (player != null && !player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.enderArrow))) {
            return;
        }
        float f = (float)(this.func_77626_a(stack) - itemInUseCount) / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        EntityEnderArrow entityenderarrow = new EntityEnderArrow(world, livingBase, f * 2.0f);
        entityenderarrow.setTpMode(mode);
        if (mode == 0) {
            TargetData target = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null) {
                return;
            }
            entityenderarrow.setTpTarget(target);
            if (UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                entityenderarrow.setPersistence(true);
            }
        }
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            if (mode == 0 && !UtilItemModular.useEnderCharge(stack, 1000, false)) {
                return;
            }
            IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            InventoryUtils.extractItems(inv, EnderUtilitiesItems.enderArrow, 1);
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (this.isBroken(stack)) {
                player.func_70669_a(stack);
            }
        }
        if (f == 1.0f) {
            entityenderarrow.func_70243_d(true);
        }
        world.func_184148_a(null, livingBase.field_70165_t, livingBase.field_70163_u, livingBase.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        world.func_72838_d((Entity)entityenderarrow);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.isBroken(stack)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!(this.getBowMode(stack) != 0 || (player.field_71075_bZ.field_75098_d || UtilItemModular.useEnderCharge(stack, 1000, true)) && OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) && TargetData.selectedModuleHasTargetTag(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL))) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.enderArrow))) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean isBroken(ItemStack stack) {
        return stack.func_77952_i() >= this.getMaxDamage(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (this.getBowMode(stack) == 1) {
            return this.getBaseItemDisplayName(stack);
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        NBTTagCompound nbt = stack.func_77978_p();
        String rst = "" + TextFormatting.RESET + TextFormatting.GRAY;
        if (nbt != null && nbt.func_150297_b("Mode", 1) && nbt.func_74771_c("Mode") == 1) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.tpself", (Object[])new Object[0]) + rst);
        } else {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.tptarget", (Object[])new Object[0]) + rst);
        }
    }

    public byte getBowMode(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74771_c("Mode");
        }
        return 0;
    }

    public void toggleBowMode(EntityPlayer player, ItemStack stack) {
        if (!Configs.enderBowAllowSelfTP) {
            NBTUtils.setByte(stack, null, "Mode", (byte)0);
        } else {
            NBTUtils.cycleByteValue(stack, null, "Mode", 1);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            this.toggleBowMode(player, stack);
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public boolean useBindLocking(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 10;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 8;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("underutilities:pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemEnderBow.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("underutilities:pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("underutilities:broken"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return stack != null && ItemEnderBow.this.isBroken(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("underutilities:mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return stack != null && ItemEnderBow.this.getBowMode(stack) == 1 ? 1.0f : 0.0f;
            }
        });
    }
}

