/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderBucket
extends ItemLocationBoundModular
implements IKeyBound,
IFluidContainerItem {
    public static final int BUCKET_VOLUME = 1000;
    public static final double ENDER_CHARGE_COST = 0.2;
    public static final byte OPERATION_MODE_NORMAL = 0;
    public static final byte OPERATION_MODE_FILL_BUCKET = 1;
    public static final byte OPERATION_MODE_DRAIN_BUCKET = 2;
    public static final byte OPERATION_MODE_BINDING = 3;
    public static final byte LINK_MODE_DISABLED = 0;
    public static final byte LINK_MODE_ENABLED = 1;
    public static final int ENDER_BUCKET_MAX_AMOUNT = 16000;
    protected int capacity;

    public ItemEnderBucket() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("enderbucket");
        this.setCapacity(Configs.enderBucketCapacity);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (this.getBucketLinkMode(stack) == 1 && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return EnumActionResult.FAIL;
        }
        if (this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack)) == EnumActionResult.SUCCESS) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IFluidHandler) {
            if (this.getBucketMode(stack) == 3) {
                return super.func_180614_a(stack, player, world, pos, hand, side, hitX, hitY, hitZ);
            }
            return this.useBucketOnTank(stack, player, world, pos, side, this.getBucketMode(stack));
        }
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.setCapacity(Configs.enderBucketCapacity);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (this.getBucketLinkMode(stack) == 1 && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return EnumActionResult.FAIL;
        }
        if (this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack)) == EnumActionResult.SUCCESS) {
            return EnumActionResult.SUCCESS;
        }
        return this.useBucketOnBlock(stack, player, world, pos, side, hitX, hitY, hitZ, this.getBucketMode(stack));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        this.setCapacity(Configs.enderBucketCapacity);
        if (world.field_72995_K || this.getBucketLinkMode(stack) == 1 && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        EnumActionResult result = this.useBucketOnFluidBlock(stack, world, player, this.getBucketMode(stack));
        return new ActionResult(result, (Object)stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String baseName;
        FluidStack fluidStack = this.getFluidCached(stack);
        String string = baseName = this.getBucketLinkMode(stack) == 1 ? super.func_77653_i(stack) : this.getBaseItemDisplayName(stack);
        if (fluidStack != null && fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            String fluidName = fluidStack.getFluid().getLocalizedName(fluidStack);
            return baseName + " - " + TextFormatting.GREEN.toString() + fluidName + rst;
        }
        return baseName;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String fluidName;
        if (stack.func_77978_p() == null) {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
            return;
        }
        FluidStack fluidStack = this.getFluidCached(stack);
        String preNr = TextFormatting.BLUE.toString();
        String preTxt = TextFormatting.DARK_GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        int amount = 0;
        int capacity = this.getCapacityCached(stack, player);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            amount = fluidStack.amount;
            fluidName = preTxt + fluidStack.getFluid().getLocalizedName(fluidStack) + rst;
        } else {
            fluidName = I18n.func_135052_a((String)"enderutilities.tooltip.item.empty", (Object[])new Object[0]);
        }
        byte mode = this.getBucketMode(stack);
        byte linkMode = this.getBucketLinkMode(stack);
        String amountStr = String.format("%s%s%s mB / %s%s%s mB", preNr, EUStringUtils.formatNumberWithKSeparators(amount), rst, preNr, EUStringUtils.formatNumberWithKSeparators(capacity), rst);
        String modeStr = mode == 0 ? "enderutilities.tooltip.item.bucket.mode.normal" : (mode == 1 ? "enderutilities.tooltip.item.bucket.mode.fill" : (mode == 2 ? "enderutilities.tooltip.item.bucket.mode.drain" : (mode == 3 ? "enderutilities.tooltip.item.bucket.mode.bind" : "")));
        if (verbose) {
            if (linkMode == 1) {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.fluid", (Object[])new Object[0]) + ": " + fluidName);
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.amount", (Object[])new Object[0]) + ": " + amountStr);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.fluid", (Object[])new Object[0]) + ": " + fluidName);
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.amount", (Object[])new Object[0]) + ": " + amountStr);
            }
        } else if (linkMode == 1) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.fluid.compact", (Object[])new Object[0]) + ": " + fluidName + " - " + amountStr);
        } else {
            list.add(fluidName + " - " + amountStr);
        }
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)modeStr, (Object[])new Object[0]));
        if (linkMode == 1) {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderBucket.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public byte getBucketMode(ItemStack stack) {
        byte mode;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Mode") && (mode = nbt.func_74771_c("Mode")) >= 0 && mode <= 3) {
            return mode;
        }
        return 0;
    }

    public byte getBucketLinkMode(ItemStack stack) {
        byte mode;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Linked") && ((mode = nbt.func_74771_c("Linked")) == 0 || mode == 1)) {
            return mode;
        }
        return 0;
    }

    public boolean isTargetUsable(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (world == null) {
            return false;
        }
        return world.canMineBlockBody(player, pos) && player.func_175151_a(pos, side, stack);
    }

    public EnumActionResult useBucketOnTank(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, byte bucketMode) {
        if (!this.isTargetUsable(stack, player, world, pos, side)) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IFluidHandler) {
            FluidStack fluidStack;
            IFluidHandler iFluidHandler = (IFluidHandler)te;
            String blockName = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)world.func_180495_p(pos).func_177230_c()).toString();
            if (blockName != null && blockName.equals("ThermalExpansion:Tank")) {
                side = EnumFacing.UP;
            }
            FluidStack storedFluidStack = this.getFluidWorker(stack, player);
            int storedFluidAmount = 0;
            if (storedFluidStack != null) {
                storedFluidAmount = storedFluidStack.amount;
            }
            if (bucketMode == 1 || bucketMode == 0 && !player.func_70093_af()) {
                FluidStack fluidStack2 = iFluidHandler.drain(side, 1000, false);
                int amount = this.getCapacityAvailable(stack, fluidStack2, player);
                if (amount > 0) {
                    if (amount > 1000) {
                        amount = 1000;
                    }
                    if (fluidStack2 != null && (storedFluidAmount == 0 || fluidStack2.isFluidEqual(storedFluidStack)) && (fluidStack2 = iFluidHandler.drain(side, amount, false)) != null && this.fillWorker(stack, fluidStack2, false, player) == fluidStack2.amount) {
                        fluidStack2 = iFluidHandler.drain(side, amount, true);
                        this.fillWorker(stack, fluidStack2, true, player);
                        return EnumActionResult.SUCCESS;
                    }
                }
            } else if (storedFluidAmount > 0 && (fluidStack = this.drainWorker(stack, 1000, false, player)) != null && iFluidHandler.fill(side, fluidStack, false) > 0) {
                int amount = iFluidHandler.fill(side, fluidStack, true);
                this.drainWorker(stack, amount, true, player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult useBucketOnBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, byte bucketMode) {
        int storedFluidAmount;
        if (!this.isTargetUsable(stack, player, world, pos, side)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos = pos.func_177972_a(side));
        if (state.func_185904_a().func_76224_d()) {
            return this.useBucketOnFluidBlock(stack, world, player, pos, side, bucketMode);
        }
        FluidStack fluidStack = this.getFluidWorker(stack, player);
        int n = storedFluidAmount = fluidStack != null ? fluidStack.amount : 0;
        if (storedFluidAmount >= 1000 && bucketMode != 1 && (fluidStack = this.drainWorker(stack, 1000, false, player)) != null && fluidStack.amount == 1000 && this.tryPlaceFluidBlock(world, pos, fluidStack)) {
            this.drainWorker(stack, 1000, true, player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult useBucketOnFluidBlock(ItemStack stack, World world, EntityPlayer player, byte bucketMode) {
        RayTraceResult rayTrace = this.func_77621_a(world, player, true);
        if (rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return EnumActionResult.PASS;
        }
        return this.useBucketOnFluidBlock(stack, world, player, rayTrace.func_178782_a(), rayTrace.field_178784_b, bucketMode);
    }

    public EnumActionResult useBucketOnFluidBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, EnumFacing side, byte bucketMode) {
        int storedFluidAmount;
        IBlockState state = world.func_180495_p(pos);
        Block targetBlock = state.func_177230_c();
        if (!this.isTargetUsable(stack, player, world, pos, side) || !state.func_185904_a().func_76224_d()) {
            return EnumActionResult.PASS;
        }
        FluidStack storedFluidStack = this.getFluidWorker(stack, player);
        FluidStack targetFluidStack = null;
        IFluidBlock iFluidBlock = null;
        int n = storedFluidAmount = storedFluidStack != null ? storedFluidStack.amount : 0;
        if (targetBlock instanceof IFluidBlock) {
            iFluidBlock = (IFluidBlock)targetBlock;
            targetFluidStack = iFluidBlock.drain(world, pos, false);
        } else {
            if (targetBlock == Blocks.field_150358_i) {
                targetBlock = Blocks.field_150355_j;
            } else if (targetBlock == Blocks.field_150356_k) {
                targetBlock = Blocks.field_150353_l;
            }
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)targetBlock);
            if (fluid != null) {
                targetFluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)1000);
            }
        }
        if (bucketMode != 2 && (storedFluidAmount == 0 || this.getCapacityAvailable(stack, targetFluidStack, player) >= 1000 && storedFluidStack.isFluidEqual(targetFluidStack) && (!player.func_70093_af() || bucketMode == 1))) {
            SoundEvent sound;
            if (iFluidBlock != null) {
                if (iFluidBlock.canDrain(world, pos) && (targetFluidStack = iFluidBlock.drain(world, pos, false)) != null && this.fillWorker(stack, targetFluidStack, false, player) == targetFluidStack.amount) {
                    targetFluidStack = iFluidBlock.drain(world, pos, true);
                    this.fillWorker(stack, targetFluidStack, true, player);
                    sound = targetBlock == Blocks.field_150353_l ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            if (targetFluidStack != null && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && this.fillWorker(stack, targetFluidStack, false, player) == targetFluidStack.amount && world.func_175698_g(pos)) {
                this.fillWorker(stack, targetFluidStack, true, player);
                sound = targetBlock == Blocks.field_150353_l ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
        }
        if (storedFluidStack != null && storedFluidAmount >= 1000 && bucketMode != 1) {
            FluidStack fluidStack;
            if ((!storedFluidStack.isFluidEqual(targetFluidStack) || player.func_70093_af() || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) && (fluidStack = this.drainWorker(stack, 1000, false, player)) != null && fluidStack.amount == 1000 && this.tryPlaceFluidBlock(world, pos, storedFluidStack)) {
                this.drainWorker(stack, 1000, true, player);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean tryPlaceFluidBlock(World world, BlockPos pos, FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || !fluidStack.getFluid().canBePlacedInWorld()) {
            return false;
        }
        Block block = fluidStack.getFluid().getBlock();
        if (block == Blocks.field_150355_j) {
            block = Blocks.field_150358_i;
        } else if (block == Blocks.field_150353_l) {
            block = Blocks.field_150356_k;
        }
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && block == Blocks.field_150358_i) {
            float x = pos.func_177958_n();
            float y = pos.func_177956_o();
            float z = pos.func_177952_p();
            world.func_184148_a(null, (double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            world.func_180501_a(pos, block.func_176223_P(), 3);
            SoundEvent soundevent = block == Blocks.field_150356_k ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public ItemEnderBucket setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int getCapacityCached(ItemStack stack, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            NBTTagCompound moduleNbt;
            ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (moduleStack != null && (moduleNbt = moduleStack.func_77978_p()) != null && moduleNbt.func_150297_b("CapacityCached", 3)) {
                return moduleNbt.func_74762_e("CapacityCached");
            }
            return 0;
        }
        return this.getCapacityWorker(stack, player);
    }

    public int getCapacityAvailable(ItemStack stack, FluidStack fluidStackIn, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            TargetData targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                FluidTankInfo[] info = tank.getTankInfo(targetData.facing);
                FluidStack fluidStack = tank.drain(targetData.facing, Integer.MAX_VALUE, false);
                if (fluidStack != null) {
                    FluidStack fs;
                    if (fluidStackIn != null) {
                        if (!fluidStack.isFluidEqual(fluidStackIn)) {
                            return 0;
                        }
                        fs = fluidStackIn.copy();
                    } else {
                        fs = fluidStack.copy();
                    }
                    if (info != null && info.length > 0 && info[0] != null) {
                        return info[0].capacity - fluidStack.amount;
                    }
                    fs.amount = Integer.MAX_VALUE;
                    return tank.fill(targetData.facing, fs, false);
                }
                if (info != null && info.length > 0 && info[0] != null) {
                    return info[0].capacity;
                }
                if (fluidStackIn != null) {
                    FluidStack fs = fluidStackIn.copy();
                    fs.amount = Integer.MAX_VALUE;
                    return tank.fill(targetData.facing, fs, false);
                }
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)Blocks.field_150355_j);
                if (fluid != null && (fluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)Integer.MAX_VALUE)) != null) {
                    return tank.fill(targetData.facing, fluidStack, false);
                }
            }
            return 0;
        }
        FluidStack fluidStack = this.getFluidWorker(stack, player);
        if (fluidStack != null) {
            return this.getCapacityWorker(stack, player) - fluidStack.amount;
        }
        return this.getCapacityWorker(stack, player);
    }

    public void cacheFluid(ItemStack stack, FluidStack fluidStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (moduleNbt == null) {
                moduleNbt = new NBTTagCompound();
            }
            if (fluidStack != null) {
                moduleNbt.func_74782_a("FluidCached", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            } else {
                moduleNbt.func_82580_o("FluidCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
        this.cacheCapacity(stack);
    }

    public void cacheCapacity(ItemStack stack) {
        ItemStack moduleStack;
        if (this.getBucketLinkMode(stack) == 1 && (moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)) != null) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (moduleNbt == null) {
                return;
            }
            IFluidHandler tank = this.getLinkedTank(stack);
            TargetData targetData = this.getLinkedTankTargetData(stack);
            if (tank != null && targetData != null) {
                FluidTankInfo[] info = tank.getTankInfo(targetData.facing);
                if (info != null && info.length > 0 && info[0] != null) {
                    moduleNbt.func_74768_a("CapacityCached", info[0].capacity);
                } else {
                    moduleNbt.func_74768_a("CapacityCached", 0);
                }
            } else {
                moduleNbt.func_82580_o("CapacityCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
    }

    public TargetData getLinkedTankTargetData(ItemStack stack) {
        TargetData targetData = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null) {
            return null;
        }
        if ("ThermalExpansion:Tank".equals(targetData.blockName)) {
            targetData.facing = EnumFacing.UP;
        }
        return targetData;
    }

    public IFluidHandler getLinkedTank(ItemStack stack) {
        TargetData targetData = this.getLinkedTankTargetData(stack);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (targetData == null || server == null) {
            return null;
        }
        WorldServer world = server.func_71218_a(targetData.dimension);
        if (world == null) {
            return null;
        }
        if (!ChunkLoading.getInstance().loadChunkForcedWithModTicket(targetData.dimension, targetData.pos.func_177958_n() >> 4, targetData.pos.func_177952_p() >> 4, 30)) {
            return null;
        }
        TileEntity te = world.func_175625_s(targetData.pos);
        if (te == null || !(te instanceof IFluidHandler)) {
            return null;
        }
        return (IFluidHandler)te;
    }

    public FluidStack getFluidCached(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (moduleStack != null && moduleStack.func_77978_p() != null && moduleStack.func_77978_p().func_150297_b("FluidCached", 10)) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)moduleStack.func_77978_p().func_74775_l("FluidCached"));
            }
            return null;
        }
        if (nbt.func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public int getCapacity(ItemStack stack) {
        return this.getCapacityWorker(stack, null);
    }

    private int getCapacityWorker(ItemStack stack, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 0) {
            return this.capacity;
        }
        if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return 0;
        }
        TargetData targetData = this.getLinkedTankTargetData(stack);
        IFluidHandler tank = this.getLinkedTank(stack);
        if (targetData != null && tank != null) {
            FluidTankInfo[] info = tank.getTankInfo(targetData.facing);
            if (info != null && info.length > 0 && info[0] != null) {
                return info[0].capacity;
            }
            FluidStack fluidStack = tank.drain(targetData.facing, Integer.MAX_VALUE, false);
            if (fluidStack != null) {
                FluidStack fs = fluidStack.copy();
                fs.amount = Integer.MAX_VALUE;
                int space = tank.fill(targetData.facing, fs, false);
                return space + fluidStack.amount;
            }
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)Blocks.field_150355_j);
            if (fluid != null && (fluidStack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)Integer.MAX_VALUE)) != null) {
                return tank.fill(targetData.facing, fluidStack, false);
            }
        }
        return 0;
    }

    public FluidStack getFluid(ItemStack stack) {
        return this.getFluidWorker(stack, null);
    }

    private FluidStack getFluidWorker(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return null;
            }
            TargetData targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                FluidStack fluidStack = tank.drain(targetData.facing, Integer.MAX_VALUE, false);
                this.cacheFluid(stack, fluidStack);
                return fluidStack;
            }
            return null;
        }
        if (nbt.func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        return this.drainWorker(stack, maxDrain, doDrain, null);
    }

    private FluidStack drainWorker(ItemStack stack, int maxDrain, boolean doDrain, EntityPlayer player) {
        if (this.getBucketLinkMode(stack) == 1) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return null;
            }
            TargetData targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                if (!UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)maxDrain), !doDrain)) {
                    return null;
                }
                FluidStack fluidStack = tank.drain(targetData.facing, maxDrain, doDrain);
                this.cacheFluid(stack, tank.drain(targetData.facing, Integer.MAX_VALUE, false));
                return fluidStack;
            }
            return null;
        }
        int drained = 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
            return null;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        if (fluidStack == null) {
            return null;
        }
        drained = Math.min(fluidStack.amount, maxDrain);
        if (doDrain) {
            if (drained >= fluidStack.amount) {
                nbt.func_82580_o("Fluid");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            } else {
                NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
                fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        fluidStack.amount = drained;
        return fluidStack;
    }

    public int fill(ItemStack stack, FluidStack fluidStackIn, boolean doFill) {
        return this.fillWorker(stack, fluidStackIn, doFill, null);
    }

    private int fillWorker(ItemStack stack, FluidStack fluidStackIn, boolean doFill, EntityPlayer player) {
        if (fluidStackIn == null) {
            return 0;
        }
        if (this.getBucketLinkMode(stack) == 1) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return 0;
            }
            TargetData targetData = this.getLinkedTankTargetData(stack);
            IFluidHandler tank = this.getLinkedTank(stack);
            if (targetData != null && tank != null) {
                if (fluidStackIn != null && !UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)fluidStackIn.amount), !doFill)) {
                    return 0;
                }
                int amount = tank.fill(targetData.facing, fluidStackIn, doFill);
                this.cacheFluid(stack, tank.drain(targetData.facing, Integer.MAX_VALUE, false));
                return amount;
            }
            return 0;
        }
        int capacityAvailable = this.getCapacityAvailable(stack, fluidStackIn, player);
        NBTTagCompound nbt = stack.func_77978_p();
        if (!doFill) {
            if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
            if (storedFluidStack == null) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
                return 0;
            }
            return Math.min(capacityAvailable, fluidStackIn.amount);
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = fluidStackIn.writeToNBT(new NBTTagCompound());
            if (capacityAvailable < fluidStackIn.amount) {
                fluidTag.func_74768_a("Amount", capacityAvailable);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacityAvailable;
            }
            nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            return fluidStackIn.amount;
        }
        NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
        FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
            return 0;
        }
        int filled = 0;
        if (fluidStackIn.amount < capacityAvailable) {
            storedFluidStack.amount += fluidStackIn.amount;
            filled = fluidStackIn.amount;
        } else {
            storedFluidStack.amount += capacityAvailable;
        }
        nbt.func_74782_a("Fluid", (NBTBase)storedFluidStack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    private void changeLinkMode(ItemStack stack) {
        NBTUtils.toggleBoolean(stack, null, "Linked");
    }

    private void changeOperationMode(ItemStack stack) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, true);
        byte val = (byte)(nbt.func_74771_c("Mode") + 1);
        if (val > 3 || val == 3 && this.getBucketLinkMode(stack) == 0) {
            val = 0;
        }
        nbt.func_74774_a("Mode", val);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            this.changeOperationMode(stack);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            this.changeLinkMode(stack);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            if (this.getBucketLinkMode(stack) == 1) {
                super.doKeyBindingAction(player, stack, key);
            }
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ModelResourceLocation("enderutilities:item_enderbucket", "inventory")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return new ModelResourceLocation("enderutilities:item_enderbucket", "inventory");
    }
}

