/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderPorter
extends ItemLocationBoundModular {
    public static final int ENDER_CHARGE_COST_INTER_DIM_TP = 5000;
    public static final int ENDER_CHARGE_COST_CROSS_DIM_TP = 25000;
    private static final int USE_TIME = 40;

    public ItemEnderPorter() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("enderporter");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return super.func_77658_a() + "_advanced";
        }
        return super.func_77658_a();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player == null || player.field_70170_p.field_72995_K || !player.func_70093_af() || !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return false;
        }
        TargetData target = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities(entity) || stack.func_77960_j() != 1 && target.dimension != entity.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == entity.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, true)) {
                return false;
            }
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_70093_af()) {
                UtilItemModular.useEnderCharge(stack, cost, false);
                TeleportEntity.teleportEntityUsingModularItem(entity, stack, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult rayTraceResult;
        if (player == null || !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af() && (rayTraceResult = this.func_77621_a(world, player, true)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        TargetData target = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities((Entity)player) || stack.func_77960_j() != 1 && target.dimension != player.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, true)) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            player.func_184598_c(hand);
            if (!world.field_72995_K) {
                Effects.playSoundEffectServer(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187814_ei, SoundCategory.MASTER, 0.08f, 1.2f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int itemInUseCount) {
        if (!(livingBase instanceof EntityPlayer) || !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)((EntityPlayer)livingBase))) {
            return;
        }
        EntityPlayer player = (EntityPlayer)livingBase;
        int useTime = 40;
        if (player.field_71075_bZ.field_75098_d) {
            useTime >>= 2;
        }
        if (this.func_77626_a(stack) - itemInUseCount >= useTime) {
            int cost;
            TargetData target = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null || stack.func_77960_j() == 0 && target.dimension != player.field_71093_bK) {
                return;
            }
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, false)) {
                return;
            }
            TeleportEntity.teleportEntityUsingModularItem((Entity)player, stack, true, true);
        }
    }

    @Override
    public boolean useBindLocking(ItemStack stack) {
        return true;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 10;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 9;
        }
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ResourceLocation(this.getRegistryName() + "_basic"), new ResourceLocation(this.getRegistryName() + "_advanced")};
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("underutilities:usetime"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemEnderPorter.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 60.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("underutilities:inuse"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }
}

