/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.container.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemPickupManager
extends ItemLocationBoundModular
implements IKeyBound {
    public static final String TAG_NAME_CONTAINER = "PickupManager";
    public static final String TAG_NAME_TX_INVENTORY = "TransportItems";
    public static final String TAG_NAME_FILTER_INVENTORY_PRE = "FilterItems_";
    public static final String TAG_NAME_PRESET_SELECTION = "SelPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final String TAG_NAME_INVFILTER_ENABLED = "InvFiltEnabled";
    public static final String TAG_NAME_INVFILTER_MODE = "InvFiltMode";
    public static final String TAG_NAME_INVFILTER_META = "InvFiltMeta";
    public static final String TAG_NAME_INVFILTER_NBT = "InvFiltNBT";
    public static final String TAG_NAME_TXFILTER_ENABLED = "TxFiltEnabled";
    public static final String TAG_NAME_TXFILTER_MODE = "TxFiltMode";
    public static final String TAG_NAME_TXFILTER_META = "TxFiltMeta";
    public static final String TAG_NAME_TXFILTER_NBT = "TxFiltNBT";
    public static final int ENDER_CHARGE_COST_PER_SENT_ITEM = 2;
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_CHANGE_PRESET = 1;
    public static final int GUI_ACTION_TOGGLE_INVENTORY_SETTINGS = 2;
    public static final int GUI_ACTION_TOGGLE_TRANSPORT_SETTINGS = 3;
    public static final SlotRange TRANSPORT_FILTER_SLOTS = new SlotRange(0, 18);
    public static final SlotRange INVENTORY_FILTER_SLOTS = new SlotRange(18, 18);

    public ItemPickupManager() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("pickupmanager");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        player.openGui((Object)EnderUtilities.instance, 1004, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        byte preset = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        int lc = UtilItemModular.getStoredModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String pre = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String str = " - pre: " + pre + (preset + 1) + rst + " LC: " + pre + lc + rst;
        String target = this.getTargetDisplayName(stack);
        if (target != null) {
            str = str + " - " + pre + target + rst;
        }
        return this.getBaseItemDisplayName(stack) + str;
    }

    @Override
    public void addInformationSelective(ItemStack containerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String str = ItemPickupManager.isEnabled(containerStack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        list.add(str);
        int preset = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION) + 1;
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.preset", (Object[])new Object[0]) + ": " + TextFormatting.BLUE.toString() + preset + rst);
        super.addInformationSelective(containerStack, player, list, advancedTooltips, verbose);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemPickupManager.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public static NBTTagCompound getSelectedPresetTag(ItemStack stack, boolean create) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound containerTag = NBTUtils.getCompoundTag(stack, TAG_NAME_CONTAINER, create);
        if (containerTag != null) {
            byte selection = containerTag.func_74771_c(TAG_NAME_PRESET_SELECTION);
            if (containerTag.func_150297_b(TAG_NAME_PRESET + selection, 10)) {
                return containerTag.func_74775_l(TAG_NAME_PRESET + selection);
            }
            if (create) {
                NBTTagCompound tag = new NBTTagCompound();
                containerTag.func_74782_a(TAG_NAME_PRESET + selection, (NBTBase)tag);
                return tag;
            }
        }
        return null;
    }

    public static byte getSettingValue(ItemStack stack, String tagName) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, false);
        return tag != null ? tag.func_74771_c(tagName) : (byte)0;
    }

    public static void setSettingValue(ItemStack stack, String tagName, byte value) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, true);
        tag.func_74774_a(tagName, value);
    }

    public static boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    public static List<ItemStack> getEnabledItems(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.pickupManager);
        ArrayList<ItemStack> enabledItems = new ArrayList<ItemStack>();
        for (int slot : slots) {
            ItemStack stack = playerInv.getStackInSlot(slot);
            if (!ItemPickupManager.isEnabled(stack)) continue;
            enabledItems.add(stack);
        }
        return enabledItems;
    }

    public static ItemStack getFirstEnabledItem(EntityPlayer player) {
        List<ItemStack> items = ItemPickupManager.getEnabledItems(player);
        return items.size() > 0 ? items.get(0) : null;
    }

    public boolean tryTransportItemsFromTransportSlot(InventoryItem inv, EntityPlayer player, ItemStack manager) {
        ItemStack stack = inv.getStackInSlot(0);
        if (stack == null) {
            return false;
        }
        int sizeOrig = stack.field_77994_a;
        int max = stack.func_77976_d();
        stack = inv.extractItem(0, max, false);
        while (stack != null && stack.field_77994_a > 0) {
            if ((stack = this.tryTransportItems(player, manager, stack)) != null) {
                inv.insertItem(0, stack, false);
                break;
            }
            stack = inv.extractItem(0, max, false);
        }
        return (stack = inv.getStackInSlot(0)) == null || stack.field_77994_a != sizeOrig;
    }

    public ItemStack tryTransportItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        ItemStack moduleStack = this.getSelectedModuleStack(manager, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack == null || itemsIn == null) {
            return itemsIn;
        }
        OwnerData owner = OwnerData.getOwnerDataFromItem(moduleStack);
        if (owner != null && !owner.canAccess((Entity)player)) {
            return itemsIn;
        }
        TargetData target = TargetData.getTargetFromItem(moduleStack);
        if (target != null) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(target.dimension);
            if (world == null || !ChunkLoading.getInstance().loadChunkForcedWithModTicket(target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4, 30)) {
                return itemsIn;
            }
            TileEntity te = world.func_175625_s(target.pos);
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing)) {
                IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing);
                if (inv == null) {
                    return itemsIn;
                }
                ItemStack stackToSend = itemsIn.func_77946_l();
                int cost = 2;
                if (!UtilItemModular.useEnderCharge(manager, cost * itemsIn.field_77994_a, true)) {
                    int available = UtilItemModular.getAvailableEnderCharge(manager);
                    if (available < cost) {
                        return itemsIn;
                    }
                    stackToSend.field_77994_a = Math.min(itemsIn.field_77994_a, available / cost);
                }
                int numTransported = stackToSend.field_77994_a;
                ItemStack itemsRemaining = InventoryUtils.tryInsertItemStackToInventory(inv, stackToSend);
                if (itemsRemaining != null) {
                    numTransported -= itemsRemaining.field_77994_a;
                }
                itemsIn.field_77994_a -= numTransported;
                UtilItemModular.useEnderCharge(manager, numTransported * cost, false);
                if (itemsIn.field_77994_a <= 0) {
                    return null;
                }
            }
        }
        return itemsIn;
    }

    public Result handleItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        byte mode;
        boolean match;
        boolean ignoreNbt;
        boolean ignoreMeta;
        byte preset = NBTUtils.getByte(manager, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        InventoryItem inv = new InventoryItem(manager, 36, 1, false, player.field_70170_p.field_72995_K, player, TAG_NAME_FILTER_INVENTORY_PRE + preset);
        inv.readFromContainerItemStack();
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange((IItemHandler)inv, TRANSPORT_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_MODE);
            if (mode != 0 && match || mode == 0 && !match) {
                ItemStack stackTmp = this.tryTransportItems(player, manager, itemsIn);
                if (stackTmp == null) {
                    return Result.TRANSPORTED;
                }
                itemsIn.field_77994_a = stackTmp.field_77994_a;
            }
        }
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange((IItemHandler)inv, INVENTORY_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_MODE);
            if (mode != 0) {
                return match ? Result.WHITELISTED : Result.NOT_WHITELISTED;
            }
            if (mode == 0) {
                return match ? Result.BLACKLISTED : Result.NOT_BLACKLISTED;
            }
        }
        return Result.NOT_HANDLED;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return true;
        }
        EntityPlayer player = event.getEntityPlayer();
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        boolean blackListed = false;
        boolean transported = false;
        Iterator<ItemStack> iter = event.drops.iterator();
        block0: while (iter.hasNext()) {
            ItemStack stackIn = iter.next();
            for (ItemStack manager : managers) {
                Result result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stackIn);
                if (result == Result.BLACKLISTED) {
                    blackListed = true;
                    deny = true;
                    continue block0;
                }
                if (result == Result.TRANSPORTED) {
                    iter.remove();
                    transported = true;
                    continue block0;
                }
                if (result == Result.WHITELISTED && !blackListed) {
                    deny = false;
                    continue block0;
                }
                if (blackListed || result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
                deny = false;
            }
        }
        if (transported) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (deny) {
            event.setCanceled(true);
        }
        return !deny;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        EntityItem entityItem = event.getItem();
        if (event.getEntityPlayer().field_70170_p.field_72995_K || entityItem.field_70128_L || entityItem.func_92059_d() == null || entityItem.func_92059_d().func_77973_b() == null || entityItem.func_92059_d().field_77994_a <= 0) {
            return true;
        }
        ItemStack stack = entityItem.func_92059_d();
        int origStackSize = stack.field_77994_a;
        EntityPlayer player = event.getEntityPlayer();
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        for (ItemStack manager : managers) {
            Result result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stack);
            if (result == Result.BLACKLISTED || result == Result.TRANSPORTED) {
                if (result == Result.TRANSPORTED) {
                    entityItem.func_70106_y();
                }
                deny = true;
                break;
            }
            if (result == Result.WHITELISTED) {
                deny = false;
                break;
            }
            if (result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
            deny = false;
        }
        if (stack.field_77994_a != origStackSize || entityItem.field_70128_L) {
            if (!entityItem.func_174814_R()) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (stack.field_77994_a <= 0 || entityItem.field_70128_L) {
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, entityItem);
                player.func_71001_a((Entity)entityItem, origStackSize);
            }
        }
        if (deny) {
            event.setCanceled(true);
        }
        return !deny;
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, HotKeys.EnumKey.keypressActionIsReversed(key));
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (!(player.field_71070_bA instanceof ContainerPickupManager)) {
            return;
        }
        ContainerPickupManager container = (ContainerPickupManager)player.field_71070_bA;
        ItemStack stack = container.getContainerItem();
        if (stack == null || !(stack.func_77973_b() instanceof ItemPickupManager)) {
            return;
        }
        if (action == 0 && element >= 0 && element < 3) {
            UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, element);
            ((ItemPickupManager)stack.func_77973_b()).tryTransportItemsFromTransportSlot(container.inventoryItemTransmit, player, stack);
        } else if (action == 1 && element >= 0 && element < 4) {
            NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            container.inventoryItemFilters.setItemStorageTagName(TAG_NAME_FILTER_INVENTORY_PRE + element);
            container.inventoryItemFilters.readFromContainerItemStack();
        } else if (action == 2 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_INVFILTER_ENABLED : (element == 1 ? TAG_NAME_INVFILTER_MODE : (element == 2 ? TAG_NAME_INVFILTER_META : TAG_NAME_INVFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        } else if (action == 3 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_TXFILTER_ENABLED : (element == 1 ? TAG_NAME_TXFILTER_MODE : (element == 2 ? TAG_NAME_TXFILTER_META : TAG_NAME_TXFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
            return 3;
        }
        if (ItemModule.ModuleType.TYPE_ENDERCAPACITOR.equals(moduleType)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_77973_b() instanceof IModule) {
            IModule imodule = (IModule)moduleStack.func_77973_b();
            ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
            if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
                if (imodule.getModuleTier(moduleStack) == 1) {
                    return this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                }
            } else {
                return this.getMaxModules(containerStack, moduleType);
            }
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "locked=false"), new ModelResourceLocation(rl, "locked=true")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "locked=" + NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED));
    }

    public static enum Result {
        TRANSPORTED,
        WHITELISTED,
        NOT_WHITELISTED,
        BLACKLISTED,
        NOT_BLACKLISTED,
        NOT_HANDLED;

    }
}

