/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBound;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemLocationBoundModular
extends ItemLocationBound
implements IModular,
IKeyBound {
    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            if (!world.field_72995_K) {
                if (!this.useBindLocking(stack) || !this.isBindLocked(stack)) {
                    boolean adjustPosHit = UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0;
                    this.setTarget(stack, player, pos, side, hitX, hitY, hitZ, adjustPosHit, false);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.itemboundtolocation", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.itembindlocked", new Object[0]));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, entity, slot, isCurrent);
        if (!(world.field_72995_K || !EnergyBridgeTracker.dimensionHasEnergyBridge(world.field_73011_w.getDimension()) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184587_cr() && ((EntityPlayer)entity).func_184607_cu() == stack || world.field_73011_w.getDimension() != 1 && !EnergyBridgeTracker.dimensionHasEnergyBridge(1))) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    @Override
    public String getTargetDisplayName(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ILocationBound) {
            if (moduleStack.func_82837_s()) {
                NBTTagCompound tag = moduleStack.func_77978_p().func_74775_l("display");
                return TextFormatting.ITALIC.toString() + tag.func_74779_i("Name") + TextFormatting.RESET.toString();
            }
            return ((ILocationBound)moduleStack.func_77973_b()).getTargetDisplayName(moduleStack);
        }
        return null;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (this.shouldDisplayTargetName(stack)) {
            String preGreen = TextFormatting.GREEN.toString();
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            return this.getBaseItemDisplayName(stack) + " " + preGreen + this.getTargetDisplayName(stack) + rst;
        }
        return super.getBaseItemDisplayName(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String preBlue = TextFormatting.BLUE.toString();
        String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        if (linkCrystalStack != null) {
            if (TargetData.itemHasTargetTag(linkCrystalStack)) {
                super.addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.notargetset", (Object[])new Object[0]));
            }
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
                String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
            }
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nolinkcrystals", (Object[])new Object[0]));
        }
        if (verbose) {
            ItemStack capacitorStack;
            if (this.getMaxModules(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                String s = this.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0 ? I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
                list.add(s);
            }
            if (this.useBindLocking(stack)) {
                String s = this.isBindLocked(stack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.bindlocked", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.bindlocked", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
                list.add(s);
            }
            if ((capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
                ((ItemEnderCapacitor)capacitorStack.func_77973_b()).func_77624_a(capacitorStack, player, list, advancedTooltips);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        super.addTooltips(stack, list, verbose);
        ItemLocationBoundModular.addTooltips("enderutilities.tooltips.itemlocationboundmodular", list, verbose);
    }

    @Override
    public void setTarget(ItemStack stack, EntityPlayer player, boolean storeRotation) {
        UtilItemModular.setTarget(stack, player, storeRotation);
    }

    @Override
    public void setTarget(ItemStack toolStack, EntityPlayer player, BlockPos pos, EnumFacing side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        UtilItemModular.setTarget(toolStack, player, pos, side, hitX, hitY, hitZ, doHitOffset, storeRotation);
    }

    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return false;
    }

    public boolean useBindLocking(ItemStack stack) {
        return false;
    }

    public boolean isBindLocked(ItemStack stack) {
        return NBTUtils.getBoolean(stack, null, "BindLocked");
    }

    @Override
    public void changePrivacyMode(ItemStack containerStack, EntityPlayer player) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(containerStack, player, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        } else {
            OwnerData.togglePrivacyModeOnSelectedModule(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            if (this.useBindLocking(stack)) {
                NBTUtils.toggleBoolean(stack, null, "BindLocked");
            }
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public int getInstalledModuleCount(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getInstalledModuleCount(containerStack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(containerStack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.getSelectedModuleTierAbs(containerStack, moduleType);
        }
        return UtilItemModular.getSelectedModuleTier(containerStack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            return UtilItemModular.getSelectedModuleStackAbs(containerStack, moduleType);
        }
        return UtilItemModular.getSelectedModuleStack(containerStack, moduleType);
    }

    @Override
    public boolean setSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            UtilItemModular.setSelectedModuleStackAbs(containerStack, moduleType, moduleStack);
        }
        return UtilItemModular.setSelectedModuleStack(containerStack, moduleType, moduleStack);
    }

    @Override
    public boolean changeSelectedModule(ItemStack containerStack, ItemModule.ModuleType moduleType, boolean reverse) {
        if (this.useAbsoluteModuleIndexing(containerStack)) {
            return UtilItemModular.changeSelectedModuleAbs(containerStack, moduleType, reverse);
        }
        return UtilItemModular.changeSelectedModule(containerStack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack containerStack) {
        return UtilItemModular.getAllModules(containerStack);
    }

    @Override
    public boolean setAllModules(ItemStack containerStack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(containerStack, modules);
    }

    @Override
    public boolean setModule(ItemStack containerStack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(containerStack, index, nbt);
    }
}

