/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.part;

import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderPart
extends ItemModule {
    public static final int ENDER_CORE_TYPE_INACTIVE_BASIC = 10;
    public static final int ENDER_CORE_TYPE_INACTIVE_ENHANCED = 11;
    public static final int ENDER_CORE_TYPE_INACTIVE_ADVANCED = 12;
    public static final int ENDER_CORE_TYPE_ACTIVE_BASIC = 0;
    public static final int ENDER_CORE_TYPE_ACTIVE_ENHANCED = 1;
    public static final int ENDER_CORE_TYPE_ACTIVE_ADVANCED = 2;
    public static final int MEMORY_CARD_TYPE_MISC = 0;
    public static final int MEMORY_CARD_TYPE_ITEMS_6B = 6;
    public static final int MEMORY_CARD_TYPE_ITEMS_8B = 8;
    public static final int MEMORY_CARD_TYPE_ITEMS_10B = 10;
    public static final int MEMORY_CARD_TYPE_ITEMS_12B = 12;

    public ItemEnderPart() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("enderpart");
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        switch (damage) {
            case 0: 
            case 1: 
            case 2: {
                return super.func_77658_a() + "_" + "enderalloy" + "_" + damage;
            }
            case 10: 
            case 11: 
            case 12: {
                return super.func_77658_a() + "_" + "endercore" + "_" + (damage - 10) + "_inactive";
            }
            case 15: 
            case 16: 
            case 17: {
                return super.func_77658_a() + "_" + "endercore" + "_" + (damage - 15) + "_active";
            }
            case 20: {
                return super.func_77658_a() + "_" + "enderstick";
            }
            case 21: {
                return super.func_77658_a() + "_" + "enderrope";
            }
            case 40: {
                return super.func_77658_a() + "_" + "enderrelic";
            }
            case 45: {
                return super.func_77658_a() + "_" + "jailer";
            }
            case 50: {
                return super.func_77658_a() + "_" + "memorycard_misc";
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return super.func_77658_a() + "_" + "memorycard_items" + "_" + (damage - 51);
            }
        }
        return super.func_77658_a();
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (stack != null && stack.func_77960_j() == 40 && EntityUtils.spawnEnderCrystal(world, pos)) {
            --stack.field_77994_a;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && stack != null && this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS)) {
            OwnerData.togglePrivacyModeOnItem(stack, (Entity)playerIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, worldIn, playerIn, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase, EnumHand hand) {
        if (stack != null && this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE) && livingBase instanceof EntityLiving && EntityUtils.applyMobPersistence((EntityLiving)livingBase)) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String preWh = TextFormatting.WHITE.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strOwner = I18n.func_135052_a((String)"enderutilities.tooltip.item.owner", (Object[])new Object[0]);
        OwnerData ownerData = OwnerData.getOwnerDataFromItem(stack);
        if (ownerData != null && !ownerData.canAccess((Entity)player)) {
            list.add(String.format("%s: %s%s%s - %s%s%s", strOwner, preWh, ownerData.getOwnerName(), rst, preRed, I18n.func_135052_a((String)"enderutilities.tooltip.item.private", (Object[])new Object[0]), rst));
            return;
        }
        int meta = stack.func_77960_j();
        NBTTagCompound nbt = stack.func_77978_p();
        if (meta >= 50 && meta <= 54 && (nbt == null || nbt.func_82582_d())) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.nodata", (Object[])new Object[0]));
            return;
        }
        if (meta == 50) {
            ArrayList<String> listDataTypes = new ArrayList<String>();
            for (String key : nbt.func_150296_c()) {
                if (key == null || key.equals("display") || key.equals("RepairCost")) continue;
                listDataTypes.add("  " + key);
            }
            if (listDataTypes.size() > 0) {
                String str1 = I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.datatypecount.1", (Object[])new Object[0]);
                String str2 = I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.datatypecount.2", (Object[])new Object[0]);
                list.add(String.format("%s %d %s", str1, listDataTypes.size(), str2));
                list.addAll(listDataTypes);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.nodata", (Object[])new Object[0]));
            }
        } else if (meta >= 51 && meta <= 54) {
            ArrayList<String> lines = new ArrayList<String>();
            int itemCount = UtilItemModular.getFormattedItemListFromContainerItem(stack, lines, 20);
            if (lines.size() > 0) {
                NBTTagList tagList = NBTUtils.getStoredItemsList(stack, false);
                int stackCount = tagList != null ? tagList.func_74745_c() : 0;
                String str1 = I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.1", (Object[])new Object[0]);
                String str2 = I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.2", (Object[])new Object[0]);
                String str3 = I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.3", (Object[])new Object[0]);
                list.add(String.format("%s %d %s %d %s", str1, stackCount, str2, itemCount, str3));
                list.addAll(lines);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.noitems", (Object[])new Object[0]));
            }
        }
        if (ownerData != null) {
            String mode = ownerData.getIsPublic() ? I18n.func_135052_a((String)"enderutilities.tooltip.item.public", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.private", (Object[])new Object[0]);
            String modeColor = ownerData.getIsPublic() ? TextFormatting.GREEN.toString() : preRed;
            list.add(String.format("%s: %s%s%s - %s%s%s", strOwner, preWh, ownerData.getOwnerName(), rst, modeColor, mode, rst));
        }
    }

    public void activateEnderCore(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (stack != null && meta >= 10 && meta <= 12) {
            stack.func_77964_b(meta + 5);
        }
    }

    @Override
    public ItemModule.ModuleType getModuleType(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta >= 10 && meta <= 12 || meta >= 15 && meta <= 17) {
            return ItemModule.ModuleType.TYPE_ENDERCORE;
        }
        if (meta == 45) {
            return ItemModule.ModuleType.TYPE_MOBPERSISTENCE;
        }
        if (meta == 50) {
            return ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC;
        }
        if (meta >= 51 && meta <= 54) {
            return ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS;
        }
        return ItemModule.ModuleType.TYPE_INVALID;
    }

    @Override
    public int getModuleTier(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta >= 10 && meta <= 12) {
            return meta - 10 + 10;
        }
        if (meta >= 15 && meta <= 17) {
            return meta - 15 + 0;
        }
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 0;
        }
        if (meta == 50) {
            return 0;
        }
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS)) {
            int tier = meta - 51;
            switch (tier) {
                case 0: {
                    return 6;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 10;
                }
                case 3: {
                    return 12;
                }
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        int i;
        for (i = 0; i <= 2; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
        for (i = 10; i <= 12; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
        for (i = 15; i <= 17; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
        list.add(new ItemStack((Item)this, 1, 20));
        list.add(new ItemStack((Item)this, 1, 21));
        list.add(new ItemStack((Item)this, 1, 40));
        list.add(new ItemStack((Item)this, 1, 45));
        list.add(new ItemStack((Item)this, 1, 50));
        list.add(new ItemStack((Item)this, 1, 51));
        list.add(new ItemStack((Item)this, 1, 52));
        list.add(new ItemStack((Item)this, 1, 53));
        list.add(new ItemStack((Item)this, 1, 54));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "tex=enderalloy_0"), new ModelResourceLocation(rl, "tex=enderalloy_1"), new ModelResourceLocation(rl, "tex=enderalloy_2"), new ModelResourceLocation(rl, "tex=endercore_inactive_0"), new ModelResourceLocation(rl, "tex=endercore_inactive_1"), new ModelResourceLocation(rl, "tex=endercore_inactive_2"), new ModelResourceLocation(rl, "tex=endercore_active_0"), new ModelResourceLocation(rl, "tex=endercore_active_1"), new ModelResourceLocation(rl, "tex=endercore_active_2"), new ModelResourceLocation(rl, "tex=enderstick"), new ModelResourceLocation(rl, "tex=enderrope"), new ModelResourceLocation(rl, "tex=enderrelic"), new ModelResourceLocation(rl, "tex=jailer"), new ModelResourceLocation(rl, "tex=memorycard_misc"), new ModelResourceLocation(rl, "tex=memorycard_items_6b"), new ModelResourceLocation(rl, "tex=memorycard_items_8b"), new ModelResourceLocation(rl, "tex=memorycard_items_10b"), new ModelResourceLocation(rl, "tex=memorycard_items_12b")};
    }
}

