/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemEnderTool
extends ItemLocationBoundModular {
    public static final Item.ToolMaterial ENDER_ALLOY_ADVANCED = EnumHelper.addToolMaterial((String)"enderutilities_enderalloy_advanced", (int)Configs.harvestLevelEnderAlloyAdvanced, (int)3120, (float)12.0f, (float)0.0f, (int)15);
    public static final int ENDER_CHARGE_COST = 50;
    public float efficiencyOnProperMaterial;
    private final Item.ToolMaterial material = ENDER_ALLOY_ADVANCED;

    public ItemEnderTool() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setNoRepair();
        this.efficiencyOnProperMaterial = this.material.func_77998_b();
        this.func_77655_b("endertool");
    }

    public String func_77667_c(ItemStack stack) {
        ToolType toolType = ToolType.fromStack(stack);
        if (toolType != ToolType.INVALID) {
            return super.func_77658_a() + "_" + toolType.getName();
        }
        return super.func_77658_a();
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (player != null && player.func_70093_af() && te != null && (te.getClass() == TileEntityEnderChest.class || te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            if (!world.field_72995_K) {
                UtilItemModular.setTarget(stack, player, pos, side, hitX, hitY, hitZ, false, false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (ToolType.fromStack(stack).equals(ToolType.HOE)) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            if (PowerStatus.fromStack(stack) == PowerStatus.POWERED) {
                if (!this.useHoeArea(stack, player, world, pos, side, 1, 1)) {
                    this.useHoeToPlantArea(stack, player, world, pos, side, hitX, hitY, hitZ, 1, 1);
                }
            } else if (!this.useHoe(stack, player, world, pos, side)) {
                this.useHoeToPlant(stack, player, world, pos, side, hitX, hitY, hitZ);
            }
        } else if (player != null && !(player instanceof FakePlayer)) {
            if (!world.field_72995_K) {
                return this.placeBlock(stack, player, world, pos, side, hitX, hitY, hitZ);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult placeBlock(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int origSlot = playerIn.field_71071_by.field_70461_c;
        int slot = -1;
        ItemStack targetStack = playerIn.func_184592_cb();
        if (targetStack == null || !(targetStack.func_77973_b() instanceof ItemBlock)) {
            slot = origSlot >= InventoryPlayer.func_70451_h() - 1 ? 0 : origSlot + 1;
            targetStack = playerIn.field_71071_by.func_70301_a(slot);
            if (!(origSlot != 0 || targetStack != null && targetStack.func_77973_b() instanceof ItemBlock)) {
                slot = InventoryPlayer.func_70451_h() - 1;
                targetStack = playerIn.field_71071_by.func_70301_a(slot);
            }
        }
        if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock && BlockUtils.checkCanPlaceBlockAt(worldIn, pos, side, ((ItemBlock)targetStack.func_77973_b()).field_150939_a, targetStack)) {
            EnumActionResult success;
            if (slot == -1) {
                success = targetStack.func_179546_a(playerIn, worldIn, pos, EnumHand.OFF_HAND, side, hitX, hitY, hitZ);
                if (targetStack.field_77994_a <= 0) {
                    playerIn.func_184611_a(EnumHand.OFF_HAND, null);
                }
            } else {
                playerIn.field_71071_by.field_70461_c = slot;
                success = targetStack.func_179546_a(playerIn, worldIn, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ);
                if (targetStack.field_77994_a <= 0) {
                    playerIn.field_71071_by.func_70299_a(slot, null);
                }
                playerIn.field_71071_by.field_70461_c = origSlot;
            }
            playerIn.field_71071_by.func_70296_d();
            playerIn.field_71069_bz.func_75142_b();
            return success;
        }
        return EnumActionResult.PASS;
    }

    public boolean useHoeArea(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, int rWidth, int rHeight) {
        boolean northSouth = (MathHelper.func_76141_d((float)(player.field_70177_z * 4.0f / 360.0f + 0.5f)) & 1) == 0;
        boolean retValue = false;
        if (!northSouth) {
            int tmp = rWidth;
            rWidth = rHeight;
            rHeight = tmp;
        }
        for (int x = pos.func_177958_n() - rWidth; x <= pos.func_177958_n() + rWidth; ++x) {
            for (int z = pos.func_177952_p() - rHeight; z <= pos.func_177952_p() + rHeight; ++z) {
                retValue |= this.useHoe(stack, player, world, new BlockPos(x, pos.func_177956_o(), z), side);
            }
        }
        return retValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useHoe(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            if (hook <= 0) return false;
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (side == EnumFacing.DOWN) return false;
        if (!world.func_175623_d(pos.func_177984_a())) return false;
        IBlockState newBlockState = null;
        if (block == Blocks.field_150349_c) {
            newBlockState = Blocks.field_150458_ak.func_176223_P();
        } else {
            if (block != Blocks.field_150346_d) return false;
            if (state.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
                newBlockState = Blocks.field_150458_ak.func_176223_P();
            } else {
                if (state.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.COARSE_DIRT) return false;
                newBlockState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
            }
        }
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (world.field_72995_K) return true;
        world.func_175656_a(pos, newBlockState);
        world.func_184138_a(pos, state, state, 3);
        this.addToolDamage(stack, 1, (EntityLivingBase)player, (EntityLivingBase)player);
        return true;
    }

    public boolean useHoeToPlantArea(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int rWidth, int rHeight) {
        boolean northSouth = (MathHelper.func_76141_d((float)(player.field_70177_z * 4.0f / 360.0f + 0.5f)) & 1) == 0;
        boolean retValue = false;
        if (!northSouth) {
            int tmp = rWidth;
            rWidth = rHeight;
            rHeight = tmp;
        }
        for (int x = pos.func_177958_n() - rWidth; x <= pos.func_177958_n() + rWidth; ++x) {
            for (int z = pos.func_177952_p() - rHeight; z <= pos.func_177952_p() + rHeight; ++z) {
                retValue |= this.useHoeToPlant(stack, player, world, new BlockPos(x, pos.func_177956_o(), z), side, hitX, hitY, hitZ);
            }
        }
        return retValue;
    }

    public boolean useHoeToPlant(ItemStack toolStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!UtilItemModular.useEnderCharge(toolStack, 50, true)) {
            return false;
        }
        IItemHandler inv = this.getLinkedInventoryWithChecks(toolStack, player);
        if (inv != null) {
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                if (!this.plantItemFromInventorySlot(world, player, inv, slot, pos, side, hitX, hitY, hitZ)) continue;
                if (DropsMode.fromStack(toolStack) == DropsMode.REMOTE) {
                    UtilItemModular.useEnderCharge(toolStack, 50, false);
                }
                Effects.addItemTeleportEffects(world, pos);
                return true;
            }
        }
        return false;
    }

    private boolean plantItemFromInventorySlot(World world, EntityPlayer player, IItemHandler inv, int slot, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean ret = false;
        ItemStack plantStack = inv.getStackInSlot(slot);
        if (plantStack != null && plantStack.func_77973_b() instanceof IPlantable) {
            plantStack = inv.extractItem(slot, 1, false);
            if (plantStack == null) {
                return false;
            }
            if (plantStack.func_179546_a(player, world, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                ret = true;
            }
            if (plantStack.field_77994_a > 0) {
                inv.insertItem(slot, plantStack, false);
            }
            if (inv instanceof PlayerMainInvWrapper && player instanceof EntityPlayerMP) {
                player.field_71069_bz.func_75142_b();
            }
        }
        return ret;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        String tc = ToolType.fromStack(stack).getToolClass();
        return tc != null ? ImmutableSet.of((Object)tc) : super.getToolClasses(stack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_77997_a();
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }

    public int getDamage(ItemStack stack) {
        return NBTUtils.getShort(stack, null, "ToolDamage");
    }

    public void setDamage(ItemStack stack, int damage) {
        damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.material.func_77997_a());
        NBTUtils.setShort(stack, null, "ToolDamage", (short)damage);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.isDamaged(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getMaxDamage(stack);
    }

    public boolean isToolBroken(ItemStack stack) {
        return NBTUtils.getShort(stack, null, "ToolDamage") >= this.material.func_77997_a();
    }

    public boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (stack == null || this.isToolBroken(stack)) {
            return false;
        }
        if (amount > 0) {
            int unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"unbreaking"), (ItemStack)stack);
            int amountNegated = 0;
            for (int i = 0; unbreakingLevel > 0 && i < amount; ++i) {
                if (field_77697_d.nextInt(amount + 1) <= 0) continue;
                ++amountNegated;
            }
            if ((amount -= amountNegated) <= 0) {
                return false;
            }
        }
        int damage = this.getDamage(stack);
        damage = Math.min(damage + amount, this.material.func_77997_a());
        this.setDamage(stack, damage);
        if (damage == this.material.func_77997_a()) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    public void repairTool(ItemStack stack, int amount) {
        if (amount == -1) {
            amount = this.material.func_77997_a();
        }
        int damage = Math.max(NBTUtils.getShort(stack, null, "ToolDamage") - amount, 0);
        this.setDamage(stack, damage);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        this.addToolDamage(stack, 2, living1, living2);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase livingBase) {
        if (state.func_185904_a() == Material.field_151584_j && ToolType.fromStack(stack).equals(ToolType.AXE)) {
            return false;
        }
        if (!this.isToolBroken(stack) && state.func_185887_b(world, pos) > 0.0f) {
            int dmg = PowerStatus.fromStack(stack) == PowerStatus.POWERED ? 2 : 1;
            this.addToolDamage(stack, dmg, livingBase, livingBase);
            return true;
        }
        return false;
    }

    private IItemHandler getLinkedInventoryWithChecks(ItemStack toolStack, EntityPlayer player) {
        DropsMode mode = DropsMode.fromStack(toolStack);
        if (mode == DropsMode.NORMAL) {
            return null;
        }
        if (mode == DropsMode.PLAYER && !(player instanceof FakePlayer) && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 0) {
            return (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        }
        if (mode == DropsMode.REMOTE && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 1 && UtilItemModular.useEnderCharge(toolStack, 50, true)) {
            return UtilItemModular.getBoundInventory(toolStack, player, 15);
        }
        return null;
    }

    public void handleHarvestDropsEvent(ItemStack toolStack, BlockEvent.HarvestDropsEvent event) {
        if (this.isToolBroken(toolStack) || event.getWorld() == null || event.getWorld().field_72995_K) {
            return;
        }
        DropsMode mode = DropsMode.fromStack(toolStack);
        if (mode == DropsMode.NORMAL) {
            return;
        }
        List drops = event.getDrops();
        EntityPlayer player = event.getHarvester();
        boolean isSilk = event.isSilkTouching();
        boolean transported = false;
        if (mode == DropsMode.PLAYER && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 0 && MinecraftForge.EVENT_BUS.post((Event)new PlayerItemPickupEvent(player, drops))) {
            Effects.addItemTeleportEffects(event.getWorld(), event.getPos());
            return;
        }
        IItemHandler inv = this.getLinkedInventoryWithChecks(toolStack, player);
        if (inv != null) {
            Iterator iter = drops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (stack == null || !isSilk && !(event.getWorld().field_73012_v.nextFloat() < event.getDropChance())) continue;
                ItemStack stackTmp = InventoryUtils.tryInsertItemStackToInventory(inv, stack.func_77946_l());
                if (stackTmp == null) {
                    iter.remove();
                    transported = true;
                    continue;
                }
                if (stackTmp.field_77994_a == stack.field_77994_a) continue;
                stack.field_77994_a = stackTmp.field_77994_a;
                transported = true;
            }
        } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
            TargetData target = TargetData.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (!OwnerData.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) != 2) {
                return;
            }
            WorldServer targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(target.dimension);
            if (targetWorld == null) {
                return;
            }
            ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4, 30);
            Iterator iter = drops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (stack == null || !isSilk && !(event.getWorld().field_73012_v.nextFloat() < event.getDropChance())) continue;
                EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, stack.func_77946_l());
                entityItem.field_70179_y = 0.0;
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.15;
                if (!targetWorld.func_72838_d((Entity)entityItem)) continue;
                Effects.spawnParticles((World)targetWorld, EnumParticleTypes.PORTAL, target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
                iter.remove();
                transported = true;
            }
        }
        if (transported) {
            if (mode == DropsMode.REMOTE) {
                UtilItemModular.useEnderCharge(toolStack, 50, false);
            }
            Effects.addItemTeleportEffects(event.getWorld(), event.getPos());
        }
        if (drops.size() > 0 && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 0 && MinecraftForge.EVENT_BUS.post((Event)new PlayerItemPickupEvent(player, drops))) {
            Effects.addItemTeleportEffects(event.getWorld(), event.getPos());
        }
        if (drops.size() == 0) {
            event.setDropChance(0.0f);
        }
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        ToolType tool = ToolType.fromStack(stack);
        if (state.func_185904_a() == Material.field_151584_j && tool.equals(ToolType.AXE)) {
            return 100.0f;
        }
        float eff = this.efficiencyOnProperMaterial;
        if (PowerStatus.fromStack(stack) == PowerStatus.POWERED) {
            eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"efficiency"), (ItemStack)stack) >= 5 ? 124.0f : 24.0f;
        }
        if (state.func_177230_c().isToolEffective(tool.getToolClass(), state)) {
            return eff;
        }
        if (this.canHarvestBlock(state, stack)) {
            return eff;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        ToolType tool = ToolType.fromStack(stack);
        return tool.equals(ToolType.PICKAXE) ? state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151592_s || state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151598_x || state.func_185904_a() == Material.field_76233_E || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g : (tool.equals(ToolType.AXE) ? state.func_185904_a() == Material.field_151575_d || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151572_C || state.func_185904_a() == Material.field_151593_r || state.func_185904_a() == Material.field_151580_n || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l : tool.equals(ToolType.SHOVEL) && (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151596_z || state.func_185904_a() == Material.field_151571_B));
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack != null && !this.isToolBroken(stack) && toolClass.equals(ToolType.fromStack(stack).getToolClass())) {
            return this.material.func_77996_d();
        }
        return -1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        double dmg = 0.5;
        ToolType toolType = ToolType.fromStack(stack);
        if (!this.isToolBroken(stack)) {
            dmg = toolType.getAttackDamage();
        }
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            String modifierName = toolType == ToolType.HOE ? "Weapon modifier" : "Tool modifier";
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, modifierName, dmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, modifierName, (double)toolType.getAttackSpeed(), 0));
        }
        return multimap;
    }

    public void cyclePoweredMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "Powered", 1);
    }

    public void cycleDropsMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "DropsMode", 2);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            this.cyclePoweredMode(stack);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            this.cycleDropsMode(stack);
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        int tier = imodule.getModuleTier(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && tier != 0 && tier != 1) {
            return 0;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier < 0 || tier > 2)) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return DropsMode.fromStack(stack) == DropsMode.REMOTE ? super.func_77653_i(stack) : this.getBaseItemDisplayName(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        boolean powered;
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE);
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        DropsMode mode = DropsMode.fromStack(stack);
        boolean bl = powered = PowerStatus.fromStack(stack) == PowerStatus.POWERED;
        String str = mode == DropsMode.NORMAL ? "enderutilities.tooltip.item.normal" : (mode == DropsMode.PLAYER ? "enderutilities.tooltip.item.endertool.playerinv" : "enderutilities.tooltip.item.endertool.remote");
        str = I18n.func_135052_a((String)str, (Object[])new Object[0]);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.endertool.dropsmode", (Object[])new Object[0]) + ": " + preDGreen + str + rst);
        if (ToolType.fromStack(stack).equals(ToolType.HOE)) {
            str = powered ? "enderutilities.tooltip.item.3x3" : "enderutilities.tooltip.item.1x1";
            str = I18n.func_135052_a((String)str, (Object[])new Object[0]);
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + str + rst);
        } else {
            str = powered ? "enderutilities.tooltip.item.fast" : "enderutilities.tooltip.item.normal";
            str = I18n.func_135052_a((String)str, (Object[])new Object[0]);
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.endertool.digmode", (Object[])new Object[0]) + ": " + preDGreen + str + rst);
        }
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.endercore", (Object[])new Object[0]) + ": ";
        if (coreTier >= 0 && coreTier <= 2) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = I18n.func_135052_a((String)coreType, (Object[])new Object[0]);
            str = str + preDGreen + coreType + rst + " (" + preBlue + I18n.func_135052_a((String)"enderutilities.tooltip.item.tier", (Object[])new Object[0]) + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = TextFormatting.RED.toString();
            str = str + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.none", (Object[])new Object[0]) + rst;
        }
        list.add(str);
        if (linkCrystalStack != null && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
            if (TargetData.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.notargetset", (Object[])new Object[0]));
            }
            int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nolinkcrystals", (Object[])new Object[0]));
        }
        if (capacitorStack != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addInformationSelective(capacitorStack, player, list, advancedTooltips, verbose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ModelResourceLocation("enderutilities:item_endertool", "inventory")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return new ModelResourceLocation("enderutilities:item_endertool", "inventory");
    }

    public static enum ToolType {
        PICKAXE(0, "pickaxe", "enderpickaxe", 5.0f, -2.7f),
        AXE(1, "axe", "enderaxe", 9.0f, -2.9f),
        SHOVEL(2, "shovel", "endershovel", 5.5f, -2.9f),
        HOE(3, "hoe", "enderhoe", 1.0f, 0.1f),
        INVALID(-1, "null", "null", 0.0f, 0.0f);

        private final int id;
        private final String toolClass;
        private final String name;
        private final float attackDamage;
        private final float attackSpeed;
        private static final Map<String, ToolType> TYPES;

        private ToolType(int id, String toolClass, String name, float attackDamage, float attackSpeed) {
            this.id = id;
            this.toolClass = toolClass;
            this.name = name;
            this.attackDamage = attackDamage;
            this.attackSpeed = attackSpeed;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public float getAttackSpeed() {
            return this.attackSpeed;
        }

        public String getToolClass() {
            return this.toolClass;
        }

        public boolean equals(ToolType other) {
            return this.id == other.id;
        }

        public static ToolType fromToolClass(String toolClass) {
            ToolType type = TYPES.get(toolClass);
            return type != null ? type : SHOVEL;
        }

        public static ToolType fromStack(ItemStack stack) {
            int meta = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(ToolType.values().length - 2));
            return ToolType.values()[meta];
        }

        static {
            TYPES = new HashMap<String, ToolType>();
            for (ToolType type : ToolType.values()) {
                TYPES.put(type.getToolClass(), type);
            }
        }
    }

    public static enum PowerStatus {
        UNPOWERED,
        POWERED;


        public static PowerStatus fromStack(ItemStack stack) {
            int mode = MathHelper.func_76125_a((int)NBTUtils.getByte(stack, null, "Powered"), (int)0, (int)1);
            return PowerStatus.values()[mode];
        }
    }

    public static enum DropsMode {
        NORMAL("enderutilities.tooltip.item.normal"),
        PLAYER("enderutilities.tooltip.item.endertool.playerinv"),
        REMOTE("enderutilities.tooltip.item.endertool.remote");

        private final String unlocalized;

        private DropsMode(String unlocalized) {
            this.unlocalized = unlocalized;
        }

        public static DropsMode fromStack(ItemStack stack) {
            int mode = MathHelper.func_76125_a((int)NBTUtils.getByte(stack, null, "DropsMode"), (int)0, (int)2);
            return DropsMode.values()[mode];
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocalized, (Object[])new Object[0]);
        }
    }
}

