/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderElevator;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageKeyPressed
implements IMessage {
    private int keyPressed;

    public MessageKeyPressed() {
    }

    public MessageKeyPressed(int key) {
        this.keyPressed = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.keyPressed = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.keyPressed);
    }

    public static class Handler
    implements IMessageHandler<MessageKeyPressed, IMessage> {
        public IMessage onMessage(final MessageKeyPressed message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageKeyPressed: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("Sending player was null in MessageKeyPressed");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageKeyPressed");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageKeyPressed message, EntityPlayer player) {
            if (this.handleEnderElevator(message, player)) {
                return;
            }
            ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IKeyBound.class);
            if (stack != null) {
                ((IKeyBound)stack.func_77973_b()).doKeyBindingAction(player, stack, message.keyPressed);
            } else {
                stack = InventoryUtils.getFirstItemOfType(player, IKeyBoundUnselected.class);
                if (stack != null) {
                    ((IKeyBoundUnselected)stack.func_77973_b()).doUnselectedKeyAction(player, stack, message.keyPressed);
                }
            }
        }

        protected boolean handleEnderElevator(MessageKeyPressed message, EntityPlayer player) {
            BlockPos pos;
            TileEntity te;
            if ((message.keyPressed == 0x2000000 || message.keyPressed == 0x1000000) && (te = player.field_70170_p.func_175625_s((pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177977_b())) instanceof TileEntityEnderElevator) {
                ((TileEntityEnderElevator)te).activateForEntity((Entity)player, message.keyPressed == 0x2000000);
                return true;
            }
            return false;
        }
    }
}

