/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.proxy;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEnderArrow;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEndermanFighter;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEntityEnderPearl;
import fi.dy.masa.enderutilities.client.renderer.model.ItemMeshDefinitionWrapper;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderBucket;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderTools;
import fi.dy.masa.enderutilities.client.renderer.tileentity.TileEntityRendererEnergyBridge;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.entity.EntityEnderPearlReusable;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.event.InputEventHandler;
import fi.dy.masa.enderutilities.event.RenderEventHandler;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.proxy.CommonProxy;
import fi.dy.masa.enderutilities.setup.ConfigReader;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.Keybindings;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortalPanel;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    @Override
    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                return FMLClientHandler.instance().getClientPlayerEntity();
            }
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        EnderUtilities.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    @Override
    public void registerColorHandlers() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (tintIndex == 1) {
                    return ((EnumDyeColor)state.func_177229_b(BlockElevator.COLOR)).func_176768_e().field_76291_p;
                }
                return 0xFFFFFF;
            }
        }, new Block[]{EnderUtilitiesBlocks.blockElevator});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                TileEntity te;
                if (tintIndex == 1 && pos != null && (te = worldIn.func_175625_s(pos)) instanceof TileEntityPortal) {
                    return ((TileEntityPortal)te).getColor();
                }
                return 10490096;
            }
        }, new Block[]{EnderUtilitiesBlocks.blockPortal});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                TileEntity te;
                if (tintIndex >= 0 && tintIndex <= 8 && pos != null && (te = worldIn.func_175625_s(pos)) instanceof TileEntityPortalPanel) {
                    return ((TileEntityPortalPanel)te).getColor(tintIndex);
                }
                return 0xFFFFFF;
            }
        }, new Block[]{EnderUtilitiesBlocks.blockPortalPanel});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 1) {
                    return EnumDyeColor.func_176764_b((int)stack.func_77960_j()).func_176768_e().field_76291_p;
                }
                return 0xFFFFFF;
            }
        }, new Item[]{Item.func_150898_a((Block)EnderUtilitiesBlocks.blockElevator)});
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ConfigReader());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InputEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    @Override
    public void registerKeyBindings() {
        Keybindings.keyToggleMode = new KeyBinding("enderutilities.key.togglemode", 34, "category.enderutilities");
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.keyToggleMode);
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderArrow.class, (IRenderFactory)new IRenderFactory<EntityEnderArrow>(){

            public Render<? super EntityEnderArrow> createRenderFor(RenderManager manager) {
                return new RenderEnderArrow(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderPearlReusable.class, (IRenderFactory)new IRenderFactory<EntityEnderPearlReusable>(){

            public Render<? super EntityEnderPearlReusable> createRenderFor(RenderManager manager) {
                return new RenderEntityEnderPearl(manager, EnderUtilitiesItems.enderPearlReusable);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityEndermanFighter.class, (IRenderFactory)new IRenderFactory<EntityEndermanFighter>(){

            public Render<? super EntityEndermanFighter> createRenderFor(RenderManager manager) {
                return new RenderEndermanFighter(manager);
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyBridge.class, (TileEntitySpecialRenderer)new TileEntityRendererEnergyBridge());
    }

    @Override
    public boolean isShiftKeyDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isControlKeyDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isAltKeyDown() {
        return GuiScreen.func_175283_s();
    }

    @Override
    public void registerModels() {
        this.registerItemBlockModels();
        this.registerAllItemModels();
    }

    public void registerAllItemModels() {
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderCapacitor);
        this.registerItemModelWithVariants(EnderUtilitiesItems.enderPart);
        this.registerItemModelWithVariants(EnderUtilitiesItems.linkCrystal);
        this.registerItemModel(EnderUtilitiesItems.buildersWand);
        this.registerItemModel(EnderUtilitiesItems.enderArrow);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderBag);
        this.registerItemModel(EnderUtilitiesItems.enderBow);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderBucket);
        this.registerItemModel(EnderUtilitiesItems.enderLasso);
        this.registerItemModelWithVariants(EnderUtilitiesItems.enderPearlReusable);
        this.registerItemModelWithVariants(EnderUtilitiesItems.enderPorter);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderSword);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderTool);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.handyBag);
        this.registerItemModelWithVariants(EnderUtilitiesItems.iceMelter);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.inventorySwapper);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.livingManipulator);
        this.registerItemModel(EnderUtilitiesItems.mobHarness);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.pickupManager);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.quickStacker);
        this.registerItemModel(EnderUtilitiesItems.portalScaler);
        this.registerItemModel(EnderUtilitiesItems.ruler);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderBucket.LoaderEnderBucket.instance);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderTools.LoaderEnderTools.instance);
    }

    private void registerItemModel(ItemEnderUtilities item) {
        this.registerItemModel(item, 0);
    }

    private void registerItemModel(ItemEnderUtilities item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private void registerItemModelWithVariants(ItemEnderUtilities item) {
        ResourceLocation[] variants = item.getItemVariants();
        ArrayList items = new ArrayList();
        item.func_150895_a(item, item.func_77640_w(), items);
        int i = 0;
        for (ItemStack stack : items) {
            ModelResourceLocation mrl = variants[i] instanceof ModelResourceLocation ? (ModelResourceLocation)variants[i] : new ModelResourceLocation(variants[i], "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77960_j(), (ModelResourceLocation)mrl);
            ++i;
        }
    }

    private void registerItemModelWithVariantsAndMeshDefinition(ItemEnderUtilities item) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])item.getItemVariants());
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMeshDefinitionWrapper.instance());
    }

    private void registerItemBlockModels() {
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockElevator);
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.blockElevator, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockElevator.COLOR, BlockElevator.FACING}).func_178441_a());
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockEnergyBridge, "active=false,facing=north,type=", "");
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockMachine_1, "facing=north,type=", "");
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockStorage_0, "facing=north,type=", "");
        this.registerItemBlockModel(EnderUtilitiesBlocks.blockPortalFrame, 0, "inventory");
        this.registerItemBlockModel(EnderUtilitiesBlocks.blockMachine_0, 0, "facing=north,mode=off");
        this.registerItemBlockModel(EnderUtilitiesBlocks.blockPortalPanel, 0, "facing=north");
    }

    private void registerItemBlockModel(BlockEnderUtilities blockIn, int meta, String fullVariant) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blockIn), (int)meta, (ModelResourceLocation)new ModelResourceLocation(blockIn.getRegistryName(), fullVariant));
    }

    private void registerAllItemBlockModels(BlockEnderUtilities blockIn, String variantPre, String variantPost) {
        ArrayList stacks = new ArrayList();
        blockIn.func_149666_a(Item.func_150898_a((Block)blockIn), blockIn.func_149708_J(), stacks);
        String[] names = blockIn.getUnlocalizedNames();
        for (ItemStack stack : stacks) {
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            ModelResourceLocation mrl = new ModelResourceLocation(item.getRegistryName(), variantPre + names[meta] + variantPost);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)mrl);
        }
    }

    private void registerAllItemBlockModels(BlockEnderUtilities blockIn) {
        ArrayList stacks = new ArrayList();
        blockIn.func_149666_a(Item.func_150898_a((Block)blockIn), blockIn.func_149708_J(), stacks);
        for (ItemStack stack : stacks) {
            Item item = stack.func_77973_b();
            ModelResourceLocation mrl = new ModelResourceLocation(item.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77960_j(), (ModelResourceLocation)mrl);
        }
    }
}

