/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.proxy;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.effects.Sounds;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.entity.EntityEnderPearlReusable;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.event.AnvilUpdateEventHandler;
import fi.dy.masa.enderutilities.event.BlockEventHandler;
import fi.dy.masa.enderutilities.event.EntityEventHandler;
import fi.dy.masa.enderutilities.event.ItemPickupEventHandler;
import fi.dy.masa.enderutilities.event.LivingDropsEventHandler;
import fi.dy.masa.enderutilities.event.PlayerEventHandler;
import fi.dy.masa.enderutilities.event.TickHandler;
import fi.dy.masa.enderutilities.event.WorldEventHandler;
import fi.dy.masa.enderutilities.proxy.IProxy;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderElevator;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderInfuser;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortalPanel;
import fi.dy.masa.enderutilities.tileentity.TileEntityQuickStackerAdvanced;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class CommonProxy
implements IProxy {
    @Override
    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        EnderUtilities.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    @Override
    public void registerColorHandlers() {
    }

    @Override
    public void registerEntities() {
        int id = 0;
        EntityRegistry.registerModEntity(EntityEnderArrow.class, (String)"enderarrow", (int)id++, (Object)EnderUtilities.instance, (int)64, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderPearlReusable.class, (String)"enderpearlreusable", (int)id++, (Object)EnderUtilities.instance, (int)64, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityEndermanFighter.class, (String)"endermanfighter", (int)id++, (Object)EnderUtilities.instance, (int)64, (int)3, (boolean)true);
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new AnvilUpdateEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemPickupEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LivingDropsEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EnderUtilities.instance, (ForgeChunkManager.LoadingCallback)new ChunkLoading());
    }

    @Override
    public void registerKeyBindings() {
    }

    @Override
    public void registerModels() {
    }

    @Override
    public void registerRenderers() {
    }

    @Override
    public void registerSounds() {
        ResourceLocation resloc = new ResourceLocation("enderutilities", "jailer");
        Sounds.jailer = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(resloc), (ResourceLocation)resloc);
    }

    @Override
    public void registerTileEntities() {
        this.registerTileEntity(TileEntityCreationStation.class, "creationstation");
        this.registerTileEntity(TileEntityEnderElevator.class, "enderelevator");
        this.registerTileEntity(TileEntityEnderFurnace.class, "enderfurnace");
        this.registerTileEntity(TileEntityEnderInfuser.class, "enderinfuser");
        this.registerTileEntity(TileEntityEnergyBridge.class, "energybridge");
        this.registerTileEntity(TileEntityHandyChest.class, "handychest");
        this.registerTileEntity(TileEntityMemoryChest.class, "memorychest");
        this.registerTileEntity(TileEntityPortal.class, "portal");
        this.registerTileEntity(TileEntityPortalPanel.class, "portal_panel");
        this.registerTileEntity(TileEntityQuickStackerAdvanced.class, "quickstackeradvanced");
        this.registerTileEntity(TileEntityToolWorkstation.class, "toolworkstation");
    }

    @Override
    public void setupReflection() {
    }

    @Override
    public boolean isShiftKeyDown() {
        return false;
    }

    @Override
    public boolean isControlKeyDown() {
        return false;
    }

    @Override
    public boolean isAltKeyDown() {
        return false;
    }

    private void registerTileEntity(Class<? extends TileEntity> clazz, String id) {
        String oldName = "enderutilities." + id.replaceAll("_", ".");
        GameRegistry.registerTileEntityWithAlternatives(clazz, (String)ReferenceNames.getPrefixedName(id), (String[])new String[]{oldName});
    }
}

