/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import com.google.common.base.Predicate;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.BlockPosDistance;
import fi.dy.masa.enderutilities.util.PositionUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileEntityEnderElevator
extends TileEntityEnderUtilities {
    private boolean redstoneState;

    public static Predicate<TileEntity> isMatchingElevator(final EnumDyeColor color) {
        return new Predicate<TileEntity>(){

            public boolean apply(TileEntity te) {
                if (!(te instanceof TileEntityEnderElevator)) {
                    return false;
                }
                IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
                return state.func_177230_c() == EnderUtilitiesBlocks.blockElevator && state.func_177229_b(BlockElevator.COLOR) == color;
            }
        };
    }

    public TileEntityEnderElevator() {
        super("enderelevator");
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.redstoneState = nbt.func_74767_n("Redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Redstone", this.redstoneState);
        return nbt;
    }

    public void onNeighborBlockChange(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean redstone = worldIn.func_175640_z(pos);
        if (redstone != this.redstoneState && redstone) {
            this.activateByRedstone(worldIn.func_175687_A(pos) < 8);
        }
        this.redstoneState = redstone;
    }

    public void activateByRedstone(boolean goingUp) {
        List entities = this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
        for (Entity entity : entities) {
            this.activateForEntity(entity, goingUp);
        }
    }

    public void activateForEntity(Entity entity, boolean goingUp) {
        BlockPos targetPos = this.getMoveVector(goingUp);
        if (targetPos != null) {
            entity.func_70634_a(entity.field_70165_t + (double)targetPos.func_177958_n(), entity.field_70163_u + (double)targetPos.func_177956_o(), entity.field_70161_v + (double)targetPos.func_177952_p());
            this.func_145831_w().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.3f, 1.8f);
        }
    }

    private BlockPos getMoveVector(boolean goingUp) {
        BlockPos center = goingUp ? this.func_174877_v().func_177984_a() : this.func_174877_v().func_177977_b();
        int rangeHorizontal = 64;
        int rangeVerticalUp = goingUp ? 256 : 0;
        int rangeVerticalDown = goingUp ? 0 : 256;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() != EnderUtilitiesBlocks.blockElevator) {
            EnderUtilities.logger.warn("Wrong block in {}#getMoveVector", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            return null;
        }
        List<BlockPosDistance> elevators = PositionUtils.getTileEntityPositions(this.func_145831_w(), center, rangeHorizontal, rangeVerticalUp, rangeVerticalDown, TileEntityEnderElevator.isMatchingElevator((EnumDyeColor)state.func_177229_b(BlockElevator.COLOR)));
        if (elevators.size() > 0) {
            return elevators.get((int)0).pos.func_177973_b((Vec3i)this.func_174877_v());
        }
        return null;
    }
}

