/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;

public class TileEntityEnderUtilities
extends TileEntity {
    protected String tileEntityName;
    protected EnumFacing facing = BlockEnderUtilities.DEFAULT_FACING;
    protected OwnerData ownerData = null;
    protected String ownerName = null;

    public TileEntityEnderUtilities(String name) {
        this.tileEntityName = name;
    }

    public String getTEName() {
        return this.tileEntityName;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setOwner(EntityPlayer player) {
        this.ownerData = player != null ? new OwnerData((Entity)player) : null;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerData != null ? this.ownerData.getOwnerUUID() : null;
    }

    public void onLeftClickBlock(EntityPlayer player) {
    }

    public void readFromNBTCustom(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Rotation", 1)) {
            EnumFacing facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("Rotation"));
            if (this.facing != BlockEnderUtilities.DEFAULT_FACING) {
                Rotation rotation = PositionUtils.getRotation(BlockEnderUtilities.DEFAULT_FACING, facing);
                this.facing = rotation.func_185831_a(this.facing);
            } else {
                this.facing = facing;
            }
        }
        this.ownerData = OwnerData.getOwnerDataFromNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromNBTCustom(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("Version", "0.6.5");
        nbt.func_74774_a("Rotation", (byte)this.facing.func_176745_a());
        if (this.ownerData != null) {
            this.ownerData.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt.func_74774_a("r", (byte)(this.facing.func_176745_a() & 7));
        if (this.ownerData != null) {
            nbt.func_74778_a("o", this.ownerData.getOwnerName());
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        return this.getUpdatePacketTag(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.field_145850_b != null) {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.getUpdatePacketTag(new NBTTagCompound()));
        }
        return null;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        if (tag.func_74764_b("r")) {
            this.setFacing(EnumFacing.func_82600_a((int)((byte)(tag.func_74771_c("r") & 7))));
        }
        if (tag.func_150297_b("o", 8)) {
            this.ownerName = tag.func_74779_i("o");
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.func_174877_v() + ")@" + System.identityHashCode((Object)this);
    }
}

