/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiMemoryChest;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerMemoryChest;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMemoryChest
extends TileEntityEnderUtilitiesInventory
implements ITieredStorage {
    public static final int[] INV_SIZES = new int[]{9, 27, 54};
    protected ItemStack[] templateStacks;
    protected List<Integer> enabledTemplateSlots = new ArrayList<Integer>();
    protected int chestTier;
    protected long templateMask;
    protected int invSize;

    public TileEntityMemoryChest() {
        super("memorychest");
        this.initStorage(54);
    }

    private void initStorage(int invSize) {
        this.templateStacks = new ItemStack[invSize];
        this.itemHandlerBase = new ItemStackHandlerTileEntity(invSize, this);
        this.itemHandlerExternal = new ItemHandlerWrapperMemoryChestExternal((IItemHandler)this.getBaseItemHandler(), this);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.getBaseItemHandler(), new ItemHandlerWrapperMemoryChestContainer((IItemHandler)this.getBaseItemHandler(), this));
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.chestTier = MathHelper.func_76125_a((int)nbt.func_74771_c("ChestTier"), (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.setTemplateMask(nbt.func_74763_f("TemplateMask"));
        super.readFromNBTCustom(nbt);
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        this.initStorage(this.invSize);
        NBTUtils.readStoredItemsFromTag(nbt, this.templateStacks, "TemplateItems");
        super.readItemsFromNBT(nbt);
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        super.writeItemsToNBT(nbt);
        NBTUtils.writeItemsToTag(nbt, this.templateStacks, "TemplateItems", true);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        nbt.func_74772_a("TemplateMask", this.templateMask);
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.chestTier = tag.func_74771_c("tier");
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize);
        super.handleUpdateTag(tag);
    }

    @Override
    public int getStorageTier() {
        return this.chestTier;
    }

    @Override
    public void setStorageTier(int tier) {
        this.chestTier = tier = MathHelper.func_76125_a((int)tier, (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize);
    }

    public long getTemplateMask() {
        return this.templateMask;
    }

    public void toggleTemplateMask(int slotNum) {
        this.setTemplateMask(this.templateMask ^ 1L << slotNum);
    }

    public void setTemplateMask(long mask) {
        this.templateMask = mask;
        this.enabledTemplateSlots.clear();
        long bit = 1L;
        int i = 0;
        while (i < this.invSize) {
            if ((this.templateMask & bit) != 0L) {
                this.enabledTemplateSlots.add(i);
            }
            ++i;
            bit <<= 1;
        }
    }

    public ItemStack getTemplateStack(int slotNum) {
        if (this.templateStacks != null && slotNum < this.templateStacks.length) {
            return this.templateStacks[slotNum];
        }
        return null;
    }

    public void setTemplateStack(int slotNum, ItemStack stack) {
        if (this.templateStacks != null && slotNum < this.templateStacks.length) {
            this.templateStacks[slotNum] = stack;
        }
    }

    @Override
    public ContainerMemoryChest getContainer(EntityPlayer player) {
        return new ContainerMemoryChest(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiMemoryChest(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperMemoryChestContainer
    extends ItemHandlerWrapperSelective {
        private final TileEntityMemoryChest temc;

        public ItemHandlerWrapperMemoryChestContainer(IItemHandler baseHandler, TileEntityMemoryChest te) {
            super(baseHandler);
            this.temc = te;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (this.temc.templateMask == 0L || InventoryUtils.areItemStacksEqual(stack, this.getStackInSlot(slot))) {
                return true;
            }
            return (this.temc.templateMask & (long)(1 << slot)) == 0L || InventoryUtils.areItemStacksEqual(stack, this.temc.templateStacks[slot]);
        }
    }

    private class ItemHandlerWrapperMemoryChestExternal
    extends ItemHandlerWrapperSelective {
        private final TileEntityMemoryChest temc;

        public ItemHandlerWrapperMemoryChestExternal(IItemHandler baseHandler, TileEntityMemoryChest te) {
            super(baseHandler);
            this.temc = te;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (this.temc.templateMask == 0L || InventoryUtils.areItemStacksEqual(stack, this.getStackInSlot(slot))) {
                return true;
            }
            int max = stack.func_77976_d();
            for (int i : this.temc.enabledTemplateSlots) {
                if (slot == i) {
                    return InventoryUtils.areItemStacksEqual(stack, this.temc.templateStacks[slot]);
                }
                ItemStack stackTmp = this.getStackInSlot(i);
                if (stackTmp != null && stackTmp.field_77994_a >= max || !InventoryUtils.areItemStacksEqual(stack, this.temc.templateStacks[i])) continue;
                return false;
            }
            return true;
        }
    }
}

