/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.effects.Sounds;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityUtils {
    public static RayTraceResult getRayTraceFromPlayer(World world, EntityPlayer player, boolean useLiquids) {
        Vec3d vec3d = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float f2 = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)(-Math.PI) / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)(-Math.PI) / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(player.field_70125_A * ((float)(-Math.PI) / 180)));
        double f5 = MathHelper.func_76126_a((float)(player.field_70125_A * ((float)(-Math.PI) / 180)));
        double f6 = f3 * f4;
        double f7 = f2 * f4;
        double reach = 5.0;
        if (player instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c(f6 * reach, f5 * reach, f7 * reach);
        return world.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static Vec3d getEyesVec(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
    }

    public static int getPointedBox(Entity entity, double reach, List<AxisAlignedBB> boxes, float partialTicks) {
        Vec3d eyesVec = entity.func_174824_e(partialTicks);
        Vec3d lookVec = entity.func_70676_i(partialTicks);
        return EntityUtils.getPointedBox(eyesVec, lookVec, reach, boxes);
    }

    public static int getPointedBox(Vec3d eyesVec, Vec3d lookVec, double reach, List<AxisAlignedBB> boxes) {
        Vec3d lookEndVec = eyesVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        double distance = reach;
        int index = -1;
        for (int i = 0; i < boxes.size(); ++i) {
            double distanceTmp;
            AxisAlignedBB bb = boxes.get(i);
            RayTraceResult rayTrace = bb.func_72327_a(eyesVec, lookEndVec);
            if (bb.func_72318_a(eyesVec)) {
                if (!(distance >= 0.0)) continue;
                distance = 0.0;
                index = i;
                continue;
            }
            if (rayTrace == null || !((distanceTmp = eyesVec.func_72438_d(rayTrace.field_72307_f)) < distance)) continue;
            distance = distanceTmp;
            index = i;
        }
        return index;
    }

    public static boolean isHoldingItem(EntityLivingBase entity, Item item) {
        return EntityUtils.getHeldItemOfType(entity, item) != null;
    }

    public static ItemStack getHeldItemOfType(EntityLivingBase entity, Item item) {
        ItemStack stack = entity.func_184614_ca();
        if (stack != null && stack.func_77973_b() == item) {
            return stack;
        }
        stack = entity.func_184592_cb();
        if (stack != null && stack.func_77973_b() == item) {
            return stack;
        }
        return null;
    }

    public static boolean isHoldingItemOfType(EntityLivingBase entity, Class<?> clazz) {
        return EntityUtils.getHeldItemOfType(entity, clazz) != null;
    }

    public static ItemStack getHeldItemOfType(EntityLivingBase entity, Class<?> clazz) {
        Item item;
        ItemStack stack = entity.func_184614_ca();
        if (stack != null && (item = stack.func_77973_b()) != null && clazz.isAssignableFrom(item.getClass())) {
            return stack;
        }
        stack = entity.func_184592_cb();
        if (stack != null && (item = stack.func_77973_b()) != null && clazz.isAssignableFrom(item.getClass())) {
            return stack;
        }
        return null;
    }

    public static EnumFacing getLookingDirection(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return EnumFacing.UP;
        }
        if (entity.field_70125_A > 45.0f) {
            return EnumFacing.DOWN;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getHorizontalLookingDirection(Entity entity) {
        return EnumFacing.func_176733_a((double)entity.field_70177_z);
    }

    public static EnumFacing getVerticalLookingDirection(Entity entity) {
        return entity.field_70125_A > 0.0f ? EnumFacing.DOWN : EnumFacing.UP;
    }

    public static EnumFacing getClosestLookingDirection(Entity entity) {
        if (entity.field_70125_A > 60.0f) {
            return EnumFacing.DOWN;
        }
        if (-entity.field_70125_A > 60.0f) {
            return EnumFacing.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getClosesLookingDirectionPlanarized(Entity entity, boolean usePitch) {
        if (usePitch) {
            EnumFacing facing = EntityUtils.getClosestLookingDirection(entity);
            if (facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.DOWN) {
                facing = EnumFacing.SOUTH;
            }
            return facing;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getClosestLookingDirectionNotOnAxis(Entity entity, EnumFacing notOnAxis) {
        EnumFacing facing = EntityUtils.getClosestLookingDirection(entity);
        if (facing == notOnAxis || facing.func_176734_d() == notOnAxis) {
            facing = notOnAxis == EnumFacing.UP || notOnAxis == EnumFacing.DOWN ? EntityUtils.getHorizontalLookingDirection(entity) : EntityUtils.getVerticalLookingDirection(entity);
        }
        return facing;
    }

    public static LeftRight getLookLeftRight(Entity entity, EnumFacing axis) {
        LeftRight result;
        float yaw = (entity.field_70177_z % 360.0f + 360.0f) % 360.0f;
        switch (axis) {
            case NORTH: {
                result = yaw <= 180.0f ? LeftRight.RIGHT : LeftRight.LEFT;
                break;
            }
            case SOUTH: {
                result = yaw > 180.0f ? LeftRight.RIGHT : LeftRight.LEFT;
                break;
            }
            case WEST: {
                result = yaw >= 90.0f && yaw <= 270.0f ? LeftRight.LEFT : LeftRight.RIGHT;
                break;
            }
            case EAST: {
                result = yaw < 90.0f || yaw > 270.0f ? LeftRight.LEFT : LeftRight.RIGHT;
                break;
            }
            default: {
                result = LeftRight.LEFT;
            }
        }
        return result;
    }

    public static List<EnumFacing> getTransformationsToMatchPlanes(EnumFacing p1Up, EnumFacing p1Right, EnumFacing p2Up, EnumFacing p2Right) {
        int i;
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        EnumFacing tmp1 = p1Up;
        EnumFacing rot = p1Up;
        if (p2Up == p1Right) {
            rot = BlockPosEU.getRotation(p1Up, p1Right.func_176734_d());
            list.add(rot);
            p1Right = BlockPosEU.getRotation(p1Right, rot);
            p1Up = p2Up;
        } else if (p2Up == p1Right.func_176734_d()) {
            rot = BlockPosEU.getRotation(p1Up, p1Right);
            list.add(rot);
            p1Right = BlockPosEU.getRotation(p1Right, rot);
            p1Up = p2Up;
        } else {
            for (i = 0; i < 4 && tmp1 != p2Up; ++i) {
                tmp1 = BlockPosEU.getRotation(tmp1, p1Right);
                list.add(p1Right);
            }
        }
        p1Up = tmp1;
        tmp1 = p1Right;
        for (i = 0; i < 4 && tmp1 != p2Right; ++i) {
            tmp1 = BlockPosEU.getRotation(tmp1, p2Up);
            list.add(p2Up);
        }
        return list;
    }

    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    public static Entity findEntityFromStackByUUID(Entity entityInStack, UUID uuid) {
        return EntityUtils.findEntityFromStackByUUID(entityInStack, uuid, true);
    }

    private static Entity findEntityFromStackByUUID(Entity entityInStack, UUID uuid, boolean startFromBottom) {
        if (entityInStack == null) {
            return null;
        }
        if (uuid.equals(entityInStack.func_110124_au())) {
            return entityInStack;
        }
        if (startFromBottom) {
            entityInStack = EntityUtils.getBottomEntity(entityInStack);
        }
        if (entityInStack.func_184207_aI()) {
            List passengers = entityInStack.func_184188_bt();
            for (Entity passenger : passengers) {
                if (uuid.equals(passenger.func_110124_au())) {
                    return passenger;
                }
                entityInStack = EntityUtils.findEntityFromStackByUUID(passenger, uuid, false);
                if (entityInStack == null) continue;
                return entityInStack;
            }
        }
        return null;
    }

    public static Entity getBottomEntity(Entity entity) {
        return entity.func_184208_bv();
    }

    public static Entity getTopEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity ent = entity;
        while (ent.func_184207_aI()) {
            ent = (Entity)ent.func_184188_bt().get(0);
        }
        return ent;
    }

    public static boolean isEntityRiddenBy(Entity target, Entity rider) {
        if (target == null || rider == null) {
            return false;
        }
        if (target.func_184207_aI()) {
            List passengers = target.func_184188_bt();
            for (Entity passenger : passengers) {
                if (!passenger.equals((Object)rider) && !EntityUtils.isEntityRiddenBy(passenger, rider)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesEntityStackHavePlayers(Entity entity) {
        if (entity == null) {
            return false;
        }
        return EntityUtils.doesEntityStackHavePlayers(entity, true);
    }

    private static boolean doesEntityStackHavePlayers(Entity entity, boolean startFromBottom) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (startFromBottom) {
            entity = EntityUtils.getBottomEntity(entity);
        }
        if (entity.func_184207_aI()) {
            List passengers = entity.func_184188_bt();
            for (Entity passenger : passengers) {
                if (!(passenger instanceof EntityPlayer) && !EntityUtils.doesEntityStackHavePlayers(passenger, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Entity> getAllEntitiesInStack(Entity entity) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        EntityUtils.getAllEntitiesInStack(entity, entities, true);
        return entities;
    }

    private static void getAllEntitiesInStack(Entity entity, List<Entity> entities, boolean startFromBottom) {
        if (startFromBottom) {
            entity = EntityUtils.getBottomEntity(entity);
        }
        entities.add(entity);
        if (entity.func_184207_aI()) {
            for (Entity passenger : entity.func_184188_bt()) {
                EntityUtils.getAllEntitiesInStack(passenger, entities, false);
            }
        }
    }

    public static boolean doesEntityStackContainEntity(Entity entity, Entity entityInStack) {
        if (entity == null || entityInStack == null) {
            return false;
        }
        return EntityUtils.doesEntityStackContainEntity(entity, entityInStack, true);
    }

    private static boolean doesEntityStackContainEntity(Entity entity, Entity entityInStack, boolean startFromBottom) {
        if (startFromBottom) {
            entityInStack = EntityUtils.getBottomEntity(entityInStack);
        }
        if (entity == entityInStack) {
            return true;
        }
        if (entityInStack.func_184207_aI()) {
            List passengers = entityInStack.func_184188_bt();
            for (Entity passenger : passengers) {
                if (passenger != entity && !EntityUtils.doesEntityStackContainEntity(entity, passenger, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesEntityStackHaveBlacklistedEntities(Entity entity) {
        if (entity == null) {
            return false;
        }
        return EntityUtils.doesEntityStackHaveBlacklistedEntities(entity, true);
    }

    private static boolean doesEntityStackHaveBlacklistedEntities(Entity entity, boolean startFromBottom) {
        List<String> blacklist = Registry.getTeleportBlacklist();
        if (blacklist.contains(entity.getClass().getSimpleName())) {
            return true;
        }
        if (startFromBottom) {
            entity = EntityUtils.getBottomEntity(entity);
        }
        if (entity.func_184207_aI()) {
            List passengers = entity.func_184188_bt();
            for (Entity passenger : passengers) {
                if (!blacklist.contains(passenger.getClass().getSimpleName()) && !EntityUtils.doesEntityStackHaveBlacklistedEntities(passenger, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean unmountFirstRider(Entity entity) {
        if (entity != null && entity.func_184207_aI()) {
            ((Entity)entity.func_184188_bt().get(0)).func_184210_p();
            return true;
        }
        return false;
    }

    public static boolean isEntityCollidingWithBlockSpace(World world, Entity entity, Block block) {
        return EntityUtils.getPositionOfBlockEntityIsCollidingWith(world, entity, block) != null;
    }

    public static BlockPos getPositionOfBlockEntityIsCollidingWith(World world, Entity entity, Block block) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int minY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)bb.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)bb.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)bb.field_72334_f);
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    BlockPos pos = new BlockPos(x2, y2, z2);
                    if (world.func_180495_p(pos).func_177230_c() != block) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public static void copyDataFromOld(Entity target, Entity old) {
        Method method = ReflectionHelper.findMethod(Entity.class, (Object)target, (String[])new String[]{"func_180432_n", "copyDataFromOld", "a"}, (Class[])new Class[]{Entity.class});
        try {
            method.invoke((Object)target, old);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            EnderUtilities.logger.error("Error while trying reflect Entity.copyDataFromOld() (UnableToFindMethodException)");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            EnderUtilities.logger.error("Error while trying reflect Entity.copyDataFromOld() (InvocationTargetException)");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            EnderUtilities.logger.error("Error while trying reflect Entity.copyDataFromOld() (IllegalAccessException)");
            e.printStackTrace();
        }
    }

    public static boolean applyMobPersistence(EntityLiving living) {
        if (!living.func_104002_bU()) {
            boolean canDespawn;
            boolean bl = canDespawn = living instanceof EntityMob && living.func_184222_aU() || living instanceof EntityWaterMob || living instanceof EntityTameable && !((EntityTameable)living).func_70909_n();
            if (!canDespawn) {
                Method method = ReflectionHelper.findMethod(EntityLiving.class, (Object)living, (String[])new String[]{"func_70692_ba", "canDespawn", "C"}, (Class[])new Class[0]);
                try {
                    Object o = method.invoke((Object)living, new Object[0]);
                    if (o instanceof Boolean) {
                        canDespawn = (Boolean)o;
                    }
                }
                catch (ReflectionHelper.UnableToFindMethodException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (UnableToFindMethodException)");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (InvocationTargetException)");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (IllegalAccessException)");
                    e.printStackTrace();
                }
            }
            if (canDespawn) {
                living.func_110163_bv();
                living.field_70170_p.func_184133_a(null, living.func_180425_c(), Sounds.jailer, SoundCategory.MASTER, 0.8f, 1.2f);
                return true;
            }
        }
        return false;
    }

    public static boolean spawnEnderCrystal(World world, BlockPos pos) {
        if (world == null || world.field_73011_w == null) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world.field_73011_w.getDimension() == 1 && world.func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
            double r = 1.0;
            List entities = world.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB((double)x - r, (double)y - r, (double)z - r, (double)x + r, (double)y + r, (double)z + r));
            if (!entities.isEmpty()) {
                return false;
            }
            for (int by = y - 5; by <= y; ++by) {
                for (int bx = x - 1; bx <= x + 1; ++bx) {
                    for (int bz = z - 1; bz <= z + 1; ++bz) {
                        if (world.func_180495_p(new BlockPos(bx, by, bz)).func_177230_c() == Blocks.field_150343_Z) continue;
                        return false;
                    }
                }
            }
            world.func_72876_a(null, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 3.0f, true);
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
            entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityendercrystal);
            return true;
        }
        if (world.field_73011_w.getDimension() != 1) {
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
            entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityendercrystal);
            return true;
        }
        return false;
    }

    public static <T extends EntityAIBase> boolean addAITaskAfterTasks(EntityLiving living, EntityAIBase task, boolean replaceMatching, Class<T>[] afterTasks) {
        if (living == null) {
            return false;
        }
        int priority = -1;
        for (EntityAITasks.EntityAITaskEntry taskEntry : living.field_70714_bg.field_75782_a) {
            if (taskEntry.field_75733_a.getClass() == task.getClass()) {
                if (replaceMatching) {
                    int p = taskEntry.field_75731_b;
                    living.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
                    living.field_70714_bg.func_75776_a(p, task);
                }
                return true;
            }
            for (Class<T> clazz : afterTasks) {
                if (priority > taskEntry.field_75731_b || taskEntry.field_75733_a.getClass() != clazz) continue;
                priority = taskEntry.field_75731_b + 1;
            }
        }
        if (priority == -1) {
            priority = 0;
        }
        living.field_70714_bg.func_75776_a(priority, task);
        return true;
    }

    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks) {
        int max;
        if (stack == null) {
            return;
        }
        double xr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177958_n();
        double yr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177956_o();
        double zr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177952_p();
        double motionScale = 0.04;
        int amount = stack.field_77994_a;
        int num = max = stack.func_77976_d();
        if (amountOverride > 0) {
            amount = amountOverride;
        }
        while (amount > 0) {
            if (!dropFullStacks) {
                num = Math.min(worldIn.field_73012_v.nextInt(23) + 10, max);
            }
            num = Math.min(num, amount);
            ItemStack dropStack = stack.func_77946_l();
            dropStack.field_77994_a = num;
            amount -= num;
            EntityItem entityItem = new EntityItem(worldIn, xr, yr, zr, dropStack);
            entityItem.field_70159_w = worldIn.field_73012_v.nextGaussian() * motionScale;
            entityItem.field_70181_x = worldIn.field_73012_v.nextGaussian() * motionScale + 0.3;
            entityItem.field_70179_y = worldIn.field_73012_v.nextGaussian() * motionScale;
            worldIn.func_72838_d((Entity)entityItem);
        }
    }

    public static enum LeftRight {
        LEFT,
        RIGHT;


        public LeftRight opposite() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

