/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockEnderUtilitiesPortal;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PortalFormer {
    private final World world;
    private TargetData target;
    private OwnerData owner;
    private int portalColor;
    private final List<BlockPos> visited;
    private final List<BlockPos> branches;
    private final List<BlockPos> corners;
    private final Block blockFrame;
    private final Block blockPortal;
    private final BlockPos startPos;
    private BlockPos lastPos;
    private EnumFacing nextSide;
    private EnumFacing.Axis portalAxis;
    private int frameCheckLimit;
    private int frameLoopCheckLimit;
    private int portalAreaCheckLimit;
    private int portalsFound;
    private boolean analyzed;
    private boolean validated;
    private boolean formed;

    public PortalFormer(World world, BlockPos startPos, Block frameBlock, Block portalBlock) {
        this.world = world;
        this.portalColor = 8339378;
        this.visited = new ArrayList<BlockPos>();
        this.branches = new ArrayList<BlockPos>();
        this.corners = new ArrayList<BlockPos>();
        this.blockFrame = frameBlock;
        this.blockPortal = portalBlock;
        this.startPos = startPos;
        this.lastPos = startPos;
        this.frameCheckLimit = Configs.portalFrameCheckLimit;
        this.frameLoopCheckLimit = Configs.portalLoopCheckLimit;
        this.portalAreaCheckLimit = Configs.portalAreaCheckLimit;
        this.portalsFound = 0;
    }

    public void setPortalData(TargetData target, OwnerData owner, int color) {
        this.target = target;
        this.owner = owner;
        this.portalColor = color;
    }

    public void setLimits(int frameCheckLimit, int frameLoopCheckLimit, int portalAreaCheckLimit) {
        this.frameCheckLimit = frameCheckLimit;
        this.frameLoopCheckLimit = frameLoopCheckLimit;
        this.portalAreaCheckLimit = portalAreaCheckLimit;
    }

    public boolean getPortalState() {
        return this.portalsFound > 0;
    }

    public boolean togglePortalState(boolean recreate) {
        this.analyzePortal();
        if (this.getPortalState()) {
            this.destroyPortals();
            if (!recreate) {
                return true;
            }
        }
        this.validatePortalAreas();
        return this.formPortals();
    }

    public void analyzePortal() {
        if (this.analyzed) {
            return;
        }
        this.visited.clear();
        this.branches.clear();
        this.corners.clear();
        this.portalsFound = 0;
        if (this.world.func_180495_p(this.startPos).func_177230_c() != this.blockFrame) {
            this.analyzed = true;
            return;
        }
        int branchIndex = 0;
        BlockPos pos = this.startPos;
        EnumFacing side = null;
        for (int counter = 0; counter < this.frameCheckLimit; ++counter) {
            side = this.checkFramePositionIgnoringSide(pos, null);
            if (side == null) {
                if (branchIndex >= this.branches.size()) break;
                pos = this.branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = pos.func_177972_a(side);
        }
        this.analyzed = true;
    }

    private void validatePortalAreas() {
        if (this.validated) {
            return;
        }
        this.visited.clear();
        Iterator<BlockPos> iter = this.corners.iterator();
        while (iter.hasNext()) {
            BlockPos pos = iter.next();
            if (this.checkForCorner(pos, true)) {
                EnumFacing.Axis axis = this.getPortalAxisFromCorner(pos);
                if (axis == null) {
                    EnderUtilities.logger.warn("null axis in PortalFormer#validateCorners()");
                    break;
                }
                EnumFacing side = this.getSideWithFrame(pos, axis);
                if (side == null) {
                    EnderUtilities.logger.warn("Didn't find an adjacent portal frame in PortalFormer#validateCorners()");
                    break;
                }
                if (this.walkFrameLoop(pos, axis, side, this.frameLoopCheckLimit)) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        this.validated = true;
    }

    private boolean formPortals() {
        if (this.formed) {
            return false;
        }
        EnumFacing ignoreSide = null;
        boolean valid = false;
        boolean success = false;
        int counter = 0;
        for (BlockPos pos : this.corners) {
            this.branches.clear();
            this.visited.clear();
            this.portalAxis = this.getPortalAxisFromCorner(pos);
            if (this.portalAxis == null) continue;
            int branchIndex = 0;
            BlockPos posTmp = pos;
            for (counter = 0; counter < this.portalAreaCheckLimit; ++counter) {
                valid = this.checkForValidPortalPosition(posTmp, ignoreSide);
                if (!valid) break;
                if (this.nextSide == null) {
                    if (branchIndex >= this.branches.size()) break;
                    posTmp = this.branches.get(branchIndex);
                    ++branchIndex;
                    continue;
                }
                posTmp = posTmp.func_177972_a(this.nextSide);
            }
            if (!valid || counter >= this.portalAreaCheckLimit) continue;
            EnumFacing facing = this.portalAxis == EnumFacing.Axis.X ? EnumFacing.EAST : (this.portalAxis == EnumFacing.Axis.Z ? EnumFacing.NORTH : EnumFacing.UP);
            IBlockState state = EnderUtilitiesBlocks.blockPortal.func_176223_P().func_177226_a((IProperty)BlockEnderUtilitiesPortal.FACING, (Comparable)facing);
            for (BlockPos posPortal : this.visited) {
                this.world.func_180501_a(posPortal, state, 2);
                TileEntity te = this.world.func_175625_s(posPortal);
                if (!(te instanceof TileEntityPortal)) continue;
                ((TileEntityPortal)te).setDestination(this.target);
                ((TileEntityPortal)te).setOwner(this.owner);
                ((TileEntityPortal)te).setColor(this.portalColor);
            }
            success = true;
        }
        this.formed = true;
        return success;
    }

    private boolean destroyPortals() {
        boolean success = false;
        for (BlockPos pos : this.corners) {
            if (this.world.func_180495_p(pos).func_177230_c() != this.blockPortal) continue;
            this.world.func_175698_g(pos);
            success = true;
        }
        return success;
    }

    private boolean walkFrameLoop(BlockPos pos, EnumFacing.Axis axis, EnumFacing frameSide, int distanceLimit) {
        BlockPos startPos;
        int turns = 0;
        int tries = 0;
        BlockPos posLast = startPos = pos;
        EnumFacing firstTrySide = frameSide;
        EnumFacing moveDirection = frameSide;
        for (int counter = 0; counter < distanceLimit; ++counter) {
            moveDirection = firstTrySide;
            for (tries = 0; tries < 4; ++tries) {
                pos = posLast.func_177972_a(moveDirection);
                IBlockState state = this.world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block.isAir(state, (IBlockAccess)this.world, pos)) {
                    posLast = pos;
                    if (tries > 1) {
                        ++turns;
                    } else if (tries == 0) {
                        --turns;
                    }
                    firstTrySide = moveDirection.func_176732_a(axis).func_176734_d();
                    break;
                }
                if (block != this.blockFrame) {
                    return false;
                }
                moveDirection = moveDirection.func_176732_a(axis);
            }
            if ((tries != 4 || counter != 0) && !pos.equals((Object)startPos)) continue;
            return turns >= 0;
        }
        return false;
    }

    private EnumFacing checkFramePositionIgnoringSide(BlockPos posIn, EnumFacing ignoreSide) {
        BlockPos pos = posIn;
        EnumFacing continueTo = null;
        int frames = 0;
        if (this.visited.contains(posIn)) {
            return null;
        }
        for (EnumFacing side : EnumFacing.values()) {
            if (side == ignoreSide || (pos = posIn.func_177972_a(side)).equals((Object)this.lastPos)) continue;
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)this.world, pos) || block == this.blockPortal) {
                this.checkForCorner(pos, false);
                continue;
            }
            if (block != this.blockFrame) continue;
            if (!this.visited.contains(pos)) {
                if (frames == 0) {
                    continueTo = side;
                } else {
                    this.branches.add(pos);
                }
            }
            ++frames;
        }
        this.visited.add(posIn);
        this.lastPos = posIn;
        return continueTo;
    }

    private boolean checkForCorner(BlockPos posIn, boolean checkIsAir) {
        if (checkIsAir && !this.world.func_175623_d(posIn)) {
            return false;
        }
        if (this.corners.contains(posIn)) {
            return true;
        }
        int adjacents = 0;
        EnumFacing[] frames = new EnumFacing[6];
        for (EnumFacing side : EnumFacing.values()) {
            Block block = this.world.func_180495_p(posIn.func_177972_a(side)).func_177230_c();
            if (block == this.blockFrame) {
                frames[adjacents] = side;
                ++adjacents;
                continue;
            }
            if (block != this.blockPortal) continue;
            ++this.portalsFound;
        }
        if (adjacents >= 3 || adjacents == 2 && frames[0] != frames[1].func_176734_d()) {
            this.corners.add(posIn);
            return true;
        }
        return false;
    }

    private boolean checkForValidPortalPosition(BlockPos posIn, EnumFacing ignoreSide) {
        EnumFacing[] sides;
        BlockPos pos = posIn;
        EnumFacing continueTo = null;
        int adjacent = 0;
        if (this.visited.contains(posIn)) {
            return true;
        }
        for (EnumFacing side : sides = PositionUtils.getSidesForAxis(this.portalAxis)) {
            if (side == ignoreSide || (pos = posIn.func_177972_a(side)).equals((Object)this.lastPos)) continue;
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)this.world, pos)) {
                if (this.visited.contains(pos)) continue;
                if (adjacent == 0) {
                    continueTo = side;
                } else {
                    this.branches.add(pos);
                }
                ++adjacent;
                continue;
            }
            if (block == this.blockFrame) continue;
            return false;
        }
        this.visited.add(posIn);
        this.lastPos = posIn;
        this.nextSide = continueTo;
        return true;
    }

    private EnumFacing.Axis getPortalAxisFromCorner(BlockPos posIn) {
        int numAdjacents = 0;
        EnumFacing[] adjacents = new EnumFacing[6];
        for (EnumFacing side : EnumFacing.values()) {
            Block block;
            if (numAdjacents > 0 && adjacents[numAdjacents - 1] == side.func_176734_d() || (block = this.world.func_180495_p(posIn.func_177972_a(side)).func_177230_c()) != this.blockFrame) continue;
            adjacents[numAdjacents] = side;
            ++numAdjacents;
        }
        if (numAdjacents >= 3 || numAdjacents == 2 && adjacents[0] != adjacents[1].func_176734_d()) {
            if (adjacents[0] == EnumFacing.DOWN || adjacents[0] == EnumFacing.UP) {
                if (adjacents[1] == EnumFacing.NORTH || adjacents[1] == EnumFacing.SOUTH) {
                    return EnumFacing.Axis.X;
                }
                return EnumFacing.Axis.Z;
            }
            return EnumFacing.Axis.Y;
        }
        return null;
    }

    private EnumFacing getSideWithFrame(BlockPos pos, EnumFacing.Axis axis) {
        EnumFacing[] sides;
        for (EnumFacing side : sides = PositionUtils.getSidesForAxis(axis)) {
            if (this.world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this.blockFrame) continue;
            return side;
        }
        return null;
    }
}

