/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.base.Predicate;
import fi.dy.masa.enderutilities.util.BlockPosDistance;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PositionUtils {
    public static final AxisAlignedBB ZERO_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final EnumFacing[] ADJACENT_SIDES_ZY = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
    public static final EnumFacing[] ADJACENT_SIDES_XY = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST};
    public static final EnumFacing[] ADJACENT_SIDES_XZ = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
    public static final EnumFacing[] CORNERS_ZY = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.UP};
    public static final EnumFacing[] CORNERS_XY = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP};
    public static final EnumFacing[] CORNERS_XZ = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH};
    public static final EnumFacing[][] FROM_TO_CW_ROTATION_AXES = new EnumFacing[][]{{null, null, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH}, {null, null, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.EAST, EnumFacing.WEST, null, null, EnumFacing.DOWN, EnumFacing.UP}, {EnumFacing.WEST, EnumFacing.EAST, null, null, EnumFacing.UP, EnumFacing.DOWN}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN, null, null}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.UP, null, null}};

    public static EnumFacing[] getSidesForAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return ADJACENT_SIDES_ZY;
        }
        return axis == EnumFacing.Axis.Z ? ADJACENT_SIDES_XY : ADJACENT_SIDES_XZ;
    }

    private static EnumFacing[] getCornersForAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return CORNERS_ZY;
        }
        return axis == EnumFacing.Axis.Z ? CORNERS_XY : CORNERS_XZ;
    }

    public static BlockPosEU[] getAdjacentPositions(BlockPosEU center, EnumFacing front, boolean diagonals) {
        if (diagonals) {
            BlockPosEU[] positions = new BlockPosEU[8];
            EnumFacing[] corners = PositionUtils.getCornersForAxis(front.func_176740_k());
            int i = 0;
            for (EnumFacing side : PositionUtils.getSidesForAxis(front.func_176740_k())) {
                positions[i] = center.offset(side);
                positions[i + 1] = positions[i].offset(corners[i / 2]);
                i += 2;
            }
            return positions;
        }
        BlockPosEU[] positions = new BlockPosEU[4];
        int i = 0;
        for (EnumFacing side : PositionUtils.getSidesForAxis(front.func_176740_k())) {
            positions[i++] = center.offset(side);
        }
        return positions;
    }

    public static BlockPos[] getAdjacentPositions(BlockPos center, EnumFacing front, boolean diagonals) {
        if (diagonals) {
            BlockPos[] positions = new BlockPos[8];
            EnumFacing[] corners = PositionUtils.getCornersForAxis(front.func_176740_k());
            int i = 0;
            for (EnumFacing side : PositionUtils.getSidesForAxis(front.func_176740_k())) {
                positions[i] = center.func_177972_a(side);
                positions[i + 1] = positions[i].func_177972_a(corners[i / 2]);
                i += 2;
            }
            return positions;
        }
        BlockPos[] positions = new BlockPos[4];
        int i = 0;
        for (EnumFacing side : PositionUtils.getSidesForAxis(front.func_176740_k())) {
            positions[i++] = center.func_177972_a(side);
        }
        return positions;
    }

    public static BlockPos getAreaSizeFromRelativeEndPosition(BlockPos posEnd) {
        int x = posEnd.func_177958_n();
        int y = posEnd.func_177956_o();
        int z = posEnd.func_177952_p();
        x = x >= 0 ? x + 1 : x - 1;
        y = y >= 0 ? y + 1 : y - 1;
        z = z >= 0 ? z + 1 : z - 1;
        return new BlockPos(x, y, z);
    }

    public static BlockPos getMinCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getMaxCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static boolean isPositionInsideArea(BlockPos pos, BlockPos posMin, BlockPos posMax) {
        return pos.func_177958_n() >= posMin.func_177958_n() && pos.func_177958_n() <= posMax.func_177958_n() && pos.func_177956_o() >= posMin.func_177956_o() && pos.func_177956_o() <= posMax.func_177956_o() && pos.func_177952_p() >= posMin.func_177952_p() && pos.func_177952_p() <= posMax.func_177952_p();
    }

    public static boolean isPositionInsideArea(BlockPosEU pos, BlockPos posMin, BlockPos posMax) {
        return pos.posX >= posMin.func_177958_n() && pos.posX <= posMax.func_177958_n() && pos.posY >= posMin.func_177956_o() && pos.posY <= posMax.func_177956_o() && pos.posZ >= posMin.func_177952_p() && pos.posZ <= posMax.func_177952_p();
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity) {
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.field_70125_A >= 80.0f) {
            return pos.func_177977_b();
        }
        if (entity.field_70125_A <= -80.0f) {
            return new BlockPos(entity.field_70165_t, Math.ceil(entity.func_174813_aQ().field_72337_e), entity.field_70161_v);
        }
        double y = Math.floor(entity.field_70163_u + (double)entity.func_70047_e());
        switch (entity.func_174811_aO()) {
            case EAST: {
                return new BlockPos((int)Math.ceil(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f)), (int)y, (int)Math.floor(entity.field_70161_v));
            }
            case WEST: {
                return new BlockPos((int)Math.floor(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f)) - 1, (int)y, (int)Math.floor(entity.field_70161_v));
            }
            case SOUTH: {
                return new BlockPos((int)Math.floor(entity.field_70165_t), (int)y, (int)Math.ceil(entity.field_70161_v + (double)(entity.field_70130_N / 2.0f)));
            }
            case NORTH: {
                return new BlockPos((int)Math.floor(entity.field_70165_t), (int)y, (int)Math.floor(entity.field_70161_v - (double)(entity.field_70130_N / 2.0f)) - 1);
            }
        }
        return pos;
    }

    public static Rotation getReverseRotation(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case COUNTERCLOCKWISE_90: {
                return Rotation.CLOCKWISE_90;
            }
            case CLOCKWISE_180: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos getTransformedBlockPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean isMirrored = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                isMirrored = false;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return isMirrored ? new BlockPos(x, y, z) : pos;
    }

    public static BlockPosEU getTransformedBlockPos(BlockPosEU pos, Mirror mirror, Rotation rotation) {
        int x = pos.posX;
        int y = pos.posY;
        int z = pos.posZ;
        boolean isMirrored = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                isMirrored = false;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                return new BlockPosEU(-z, y, x, pos.dimension, pos.face);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPosEU(z, y, -x, pos.dimension, pos.face);
            }
            case CLOCKWISE_180: {
                return new BlockPosEU(-x, y, -z, pos.dimension, pos.face);
            }
        }
        return isMirrored ? new BlockPosEU(x, y, z, pos.dimension, pos.face) : pos;
    }

    public static BlockPosEU getOriginalPositionFromTransformed(BlockPosEU pos, Mirror mirror, Rotation rotation) {
        int x = pos.posX;
        int y = pos.posY;
        int z = pos.posZ;
        boolean noRotation = false;
        switch (rotation) {
            case CLOCKWISE_90: {
                int tmp = x;
                x = -z;
                z = tmp;
            }
            case COUNTERCLOCKWISE_90: {
                int tmp = x;
                x = z;
                z = -tmp;
            }
            case CLOCKWISE_180: {
                x = -x;
                z = -z;
            }
        }
        noRotation = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                if (!noRotation) break;
                return pos;
            }
        }
        return new BlockPosEU(x, y, z, pos.dimension, pos.face);
    }

    public static Vec3d transformedVec3d(Vec3d vec, Mirror mirrorIn, Rotation rotationIn) {
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        boolean isMirrored = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                z = 1.0 - z;
                break;
            }
            case FRONT_BACK: {
                x = 1.0 - x;
                break;
            }
            default: {
                isMirrored = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(z, y, 1.0 - x);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - z, y, x);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - x, y, 1.0 - z);
            }
        }
        return isMirrored ? new Vec3d(x, y, z) : vec;
    }

    public static EnumFacing getFacingFromPositions(BlockPosEU pos1, BlockPosEU pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return PositionUtils.getFacingFromPositions(pos1.posX, pos1.posZ, pos2.posX, pos2.posZ);
    }

    public static EnumFacing getFacingFromPositions(BlockPos pos1, BlockPos pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return PositionUtils.getFacingFromPositions(pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177952_p());
    }

    private static EnumFacing getFacingFromPositions(int x1, int z1, int x2, int z2) {
        if (x2 == x1) {
            return z2 > z1 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        if (z2 == z1) {
            return x2 > x1 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (x2 > x1) {
            return z2 > z1 ? EnumFacing.EAST : EnumFacing.NORTH;
        }
        return z2 > z1 ? EnumFacing.SOUTH : EnumFacing.WEST;
    }

    public static Vec3d rotatePointAroundAxis(Vec3d point, Vec3d reference, EnumFacing from, EnumFacing to) {
        if (from == to) {
            return point;
        }
        return PositionUtils.rotatePointAroundAxis(point.field_72450_a, point.field_72448_b, point.field_72449_c, reference, from, to);
    }

    public static Vec3d rotatePointAroundAxis(double x, double y, double z, Vec3d reference, EnumFacing from, EnumFacing to) {
        if (to == from.func_176734_d()) {
            double rx = reference.field_72450_a;
            if (from.func_176740_k().func_176722_c()) {
                double rz = reference.field_72449_c;
                x = rx + (rx - x);
                z = rz + (rz - z);
            } else {
                double ry = reference.field_72448_b;
                x = rx + (rx - x);
                y = ry + (ry - y);
            }
            return new Vec3d(x, y, z);
        }
        return PositionUtils.rotatePointCWAroundAxis(x, y, z, reference, FROM_TO_CW_ROTATION_AXES[from.func_176745_a()][to.func_176745_a()]);
    }

    public static Vec3d rotatePointCWAroundAxis(Vec3d point, Vec3d reference, EnumFacing facing) {
        return PositionUtils.rotatePointCWAroundAxis(point.field_72450_a, point.field_72448_b, point.field_72449_c, reference, facing);
    }

    public static Vec3d rotatePointCWAroundAxis(double x, double y, double z, Vec3d reference, EnumFacing facing) {
        double rx = reference.field_72450_a;
        double ry = reference.field_72448_b;
        double rz = reference.field_72449_c;
        double newX = x;
        double newY = y;
        double newZ = z;
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                newX = rx - (z - rz);
                newZ = rz + (x - rx);
            } else {
                newX = rx + (z - rz);
                newZ = rz - (x - rx);
            }
        } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                newX = rx + (y - ry);
                newY = ry - (x - rx);
            } else {
                newX = rx - (y - ry);
                newY = ry + (x - rx);
            }
        } else if (facing.func_176740_k() == EnumFacing.Axis.X) {
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                newZ = rz - (y - ry);
                newY = ry + (z - rz);
            } else {
                newZ = rz + (y - ry);
                newY = ry - (z - rz);
            }
        }
        return new Vec3d(newX, newY, newZ);
    }

    public static AxisAlignedBB rotateBoxAroundPoint(AxisAlignedBB bb, Vec3d reference, EnumFacing from, EnumFacing to) {
        if (from == to) {
            return bb;
        }
        Vec3d min = PositionUtils.rotatePointAroundAxis(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, reference, from, to);
        Vec3d max = PositionUtils.rotatePointAroundAxis(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f, reference, from, to);
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public static BlockPos.MutableBlockPos getOffsetPosition(BlockPos.MutableBlockPos pos, BlockPos posReference, EnumFacing side, int amount) {
        switch (side) {
            case NORTH: {
                pos.func_181079_c(posReference.func_177958_n(), posReference.func_177956_o(), posReference.func_177952_p() - amount);
            }
            case SOUTH: {
                pos.func_181079_c(posReference.func_177958_n(), posReference.func_177956_o(), posReference.func_177952_p() + amount);
            }
            case EAST: {
                pos.func_181079_c(posReference.func_177958_n() + amount, posReference.func_177956_o(), posReference.func_177952_p());
            }
            case WEST: {
                pos.func_181079_c(posReference.func_177958_n() - amount, posReference.func_177956_o(), posReference.func_177952_p());
            }
            case UP: {
                pos.func_181079_c(posReference.func_177958_n(), posReference.func_177956_o() + amount, posReference.func_177952_p());
            }
            case DOWN: {
                pos.func_181079_c(posReference.func_177958_n(), posReference.func_177956_o() - amount, posReference.func_177952_p());
            }
        }
        return pos;
    }

    public static Rotation getRotation(EnumFacing facingOriginal, EnumFacing facingRotated) {
        if (facingOriginal.func_176740_k() == EnumFacing.Axis.Y || facingRotated.func_176740_k() == EnumFacing.Axis.Y || facingOriginal == facingRotated) {
            return Rotation.NONE;
        }
        if (facingRotated == facingOriginal.func_176734_d()) {
            return Rotation.CLOCKWISE_180;
        }
        return facingRotated == facingOriginal.func_176746_e() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    public static boolean isWithinRange(BlockPos pos, Entity entity, int rangeH, int rangeV) {
        return PositionUtils.isWithinRange(pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, rangeH, rangeV);
    }

    public static boolean isWithinRange(BlockPos pos, double x, double y, double z, int rangeH, int rangeV) {
        return Math.abs((double)pos.func_177958_n() - x + 0.5) <= (double)rangeH && Math.abs((double)pos.func_177952_p() - z + 0.5) <= (double)rangeH && Math.abs((double)pos.func_177956_o() - y + 0.5) <= (double)rangeV;
    }

    public static boolean isWithinRange(BlockPos pos1, BlockPos pos2, int rangeH, int rangeVertPos, int rangeVertNeg) {
        return Math.abs(pos2.func_177958_n() - pos1.func_177958_n()) <= rangeH && Math.abs(pos2.func_177952_p() - pos1.func_177952_p()) <= rangeH && pos2.func_177956_o() - pos1.func_177956_o() <= rangeVertPos && pos1.func_177956_o() - pos2.func_177956_o() <= rangeVertNeg;
    }

    public static List<BlockPosDistance> getTileEntityPositions(World world, BlockPos centerPos, int rangeH, int rangeVertPos, int rangeVertNeg) {
        return PositionUtils.getTileEntityPositions(world, centerPos, rangeH, rangeVertPos, rangeVertNeg, null);
    }

    public static List<BlockPosDistance> getTileEntityPositions(World world, BlockPos centerPos, int rangeH, int rangeVertPos, int rangeVertNeg, Predicate<? super TileEntity> filter) {
        ArrayList<BlockPosDistance> posDist = new ArrayList<BlockPosDistance>();
        for (int cx = centerPos.func_177958_n() - rangeH >> 4; cx <= centerPos.func_177958_n() + rangeH >> 4; ++cx) {
            for (int cz = centerPos.func_177952_p() - rangeH >> 4; cz <= centerPos.func_177952_p() + rangeH >> 4; ++cz) {
                Chunk chunk;
                if (!world.func_175668_a(new BlockPos(cx << 4, centerPos.func_177956_o(), cz << 4), world.field_72995_K) || (chunk = world.func_72964_e(cx, cz)) == null) continue;
                Map map = chunk.func_177434_r();
                for (BlockPos pos : map.keySet()) {
                    if (!PositionUtils.isWithinRange(centerPos, pos, rangeH, rangeVertPos, rangeVertNeg) || filter != null && !filter.apply(map.get(pos))) continue;
                    posDist.add(new BlockPosDistance(pos, centerPos));
                }
            }
        }
        Collections.sort(posDist);
        return posDist;
    }

    public static void getPositionsInBoxSpiralingOutwards(List<BlockPos> positions, int vertR, int horizR, int yLevel, int centerX, int centerZ) {
        PositionUtils.getPositionsOnPlaneSpiralingOutwards(positions, horizR, yLevel, centerX, centerZ);
        for (int y = 1; y <= vertR; ++y) {
            PositionUtils.getPositionsOnPlaneSpiralingOutwards(positions, horizR, yLevel + y, centerX, centerZ);
            PositionUtils.getPositionsOnPlaneSpiralingOutwards(positions, horizR, yLevel - y, centerX, centerZ);
        }
    }

    public static void getPositionsOnPlaneSpiralingOutwards(List<BlockPos> positions, int radius, int yLevel, int centerX, int centerZ) {
        positions.add(new BlockPos(centerX, yLevel, centerZ));
        for (int r = 1; r <= radius; ++r) {
            PositionUtils.getPositionsOnRing(positions, r, yLevel, centerX, centerZ);
        }
    }

    public static void getPositionsOnRing(List<BlockPos> positions, int radius, int yLevel, int centerX, int centerZ) {
        int z;
        int x;
        int minX = centerX - radius;
        int minZ = centerZ - radius;
        int maxX = centerX + radius;
        int maxZ = centerZ + radius;
        for (x = minX; x <= maxX; ++x) {
            positions.add(new BlockPos(x, yLevel, minZ));
        }
        for (z = minZ + 1; z <= maxZ; ++z) {
            positions.add(new BlockPos(maxX, yLevel, z));
        }
        for (x = maxX - 1; x >= minX; --x) {
            positions.add(new BlockPos(x, yLevel, maxZ));
        }
        for (z = maxZ - 1; z > minZ; --z) {
            positions.add(new BlockPos(minX, yLevel, z));
        }
    }

    public static Vec3d getScaledClampedPosition(EntityPlayer player, int destDimension, double scaleX, double scaleY, double scaleZ, int margin) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        int worldLimit = 29999984;
        double posX = MathHelper.func_151237_a((double)(player.field_70165_t * scaleX), (double)(-worldLimit), (double)worldLimit);
        double posY = MathHelper.func_151237_a((double)(player.field_70163_u * scaleY), (double)0.0, (double)(world != null ? (double)(world.func_72940_L() - 1) : 255.0));
        double posZ = MathHelper.func_151237_a((double)(player.field_70161_v * scaleZ), (double)(-worldLimit), (double)worldLimit);
        if (world != null) {
            WorldBorder border = world.func_175723_af();
            margin = Math.min(margin, (int)(border.func_177741_h() / 2.0));
            posX = MathHelper.func_151237_a((double)(player.field_70165_t * scaleX), (double)(border.func_177726_b() + (double)margin), (double)(border.func_177728_d() - (double)margin));
            posZ = MathHelper.func_151237_a((double)(player.field_70161_v * scaleZ), (double)(border.func_177736_c() + (double)margin), (double)(border.func_177733_e() - (double)margin));
        }
        return new Vec3d(posX, posY, posZ);
    }
}

