/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.collect.Maps;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.TemplateEnderUtilities;
import fi.dy.masa.enderutilities.util.TemplateMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;

public class TemplateManagerEU {
    protected final MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
    protected final Map<String, TemplateEnderUtilities> templates = Maps.newHashMap();
    protected final Map<String, TemplateMetadata> templateMetas = Maps.newHashMap();
    protected final File directory;

    public TemplateManagerEU(File directory) {
        this.directory = directory;
    }

    public TemplateEnderUtilities getTemplate(ResourceLocation id) {
        String s = id.func_110623_a();
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        this.readTemplate(id);
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        TemplateEnderUtilities template = new TemplateEnderUtilities();
        this.templates.put(s, template);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean readTemplate(ResourceLocation id) {
        boolean bl;
        String fileName = id.func_110623_a();
        File templateFile = new File(this.directory, fileName + ".nbt");
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(templateFile);
            this.readTemplateFromStream(fileName, inputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)inputStream);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(inputStream);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return bl;
        return false;
    }

    private void readTemplateFromStream(String id, InputStream stream) throws IOException {
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        TemplateEnderUtilities template = new TemplateEnderUtilities();
        template.read(nbt);
        this.templates.put(id, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeTemplate(ResourceLocation id) {
        boolean bl;
        String fileName = id.func_110623_a();
        if (!this.templates.containsKey(fileName)) {
            return false;
        }
        if (!this.directory.exists() ? !this.directory.mkdirs() : !this.directory.isDirectory()) {
            return false;
        }
        File templateFile = new File(this.directory, fileName + ".nbt");
        NBTTagCompound nbt = new NBTTagCompound();
        TemplateEnderUtilities template = this.templates.get(fileName);
        FileOutputStream outputStream = null;
        try {
            template.write(nbt);
            outputStream = new FileOutputStream(templateFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)outputStream);
            bl = true;
        }
        catch (IOException e) {
            try {
                EnderUtilities.logger.warn("Failed to write template to file '{}'", new Object[]{templateFile});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return false;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }

    public TemplateMetadata getTemplateMetadata(ResourceLocation rl) {
        String s = rl.func_110623_a();
        if (this.templateMetas.containsKey(s)) {
            return this.templateMetas.get(s);
        }
        this.readTemplateMetadata(rl);
        if (this.templateMetas.containsKey(s)) {
            return this.templateMetas.get(s);
        }
        TemplateMetadata templateMeta = new TemplateMetadata();
        this.templateMetas.put(s, templateMeta);
        return templateMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean readTemplateMetadata(ResourceLocation rl) {
        boolean bl;
        File templateFile = this.getTemplateMetadataFile(rl);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(templateFile);
            this.readTemplateMetadataFromStream(rl.func_110623_a(), inputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)inputStream);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(inputStream);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return bl;
        return false;
    }

    protected File getTemplateMetadataFile(ResourceLocation rl) {
        return new File(this.directory, rl.func_110623_a() + "_meta.nbt");
    }

    private void readTemplateMetadataFromStream(String id, InputStream stream) throws IOException {
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        TemplateMetadata templateMeta = new TemplateMetadata();
        templateMeta.read(nbt);
        this.templateMetas.put(id, templateMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeTemplateMetadata(ResourceLocation rl) {
        boolean bl;
        String fileName = rl.func_110623_a();
        if (!this.templateMetas.containsKey(fileName)) {
            return false;
        }
        if (!this.directory.exists() ? !this.directory.mkdirs() : !this.directory.isDirectory()) {
            return false;
        }
        File templateFile = new File(this.directory, fileName + "_meta.nbt");
        NBTTagCompound nbt = new NBTTagCompound();
        TemplateMetadata templateMeta = this.templateMetas.get(fileName);
        FileOutputStream outputStream = null;
        try {
            templateMeta.write(nbt);
            outputStream = new FileOutputStream(templateFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)outputStream);
            bl = true;
        }
        catch (Throwable e) {
            try {
                EnderUtilities.logger.warn("Failed to write template metadata to file '{}'", new Object[]{templateFile});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return false;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }

    public FileInfo getTemplateInfo(ResourceLocation rl) {
        File file = this.getTemplateMetadataFile(rl);
        return new FileInfo(file.lastModified(), file.length());
    }

    public class FileInfo {
        public final long timestamp;
        public final long fileSize;

        public FileInfo(long timestamp, long fileSize) {
            this.timestamp = timestamp;
            this.fileSize = fileSize;
        }
    }
}

