/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TargetData {
    public BlockPos pos = new BlockPos(0, 0, 0);
    public double dPosX = 0.0;
    public double dPosY = 0.0;
    public double dPosZ = 0.0;
    public int dimension = 0;
    public String dimensionName = "";
    public boolean hasRotation = false;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public String blockName = "";
    public int blockMeta = 0;
    public int itemMeta = 0;
    public int blockFace = -1;
    public EnumFacing facing = EnumFacing.UP;

    public static TargetData getTargetFromItem(ItemStack stack) {
        TargetData target;
        if (stack != null && (target = new TargetData()).readTargetTagFromNBT(stack.func_77978_p()) != null) {
            return target;
        }
        return null;
    }

    public static TargetData getTargetFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return TargetData.getTargetFromItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public static boolean nbtHasTargetTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Target", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        return tag != null && tag.func_150297_b("posX", 3) && tag.func_150297_b("posY", 3) && tag.func_150297_b("posZ", 3) && tag.func_150297_b("Dim", 3) && tag.func_150297_b("BlockFace", 1);
    }

    public static boolean itemHasTargetTag(ItemStack stack) {
        return stack != null && TargetData.nbtHasTargetTag(stack.func_77978_p());
    }

    public static boolean selectedModuleHasTargetTag(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return TargetData.itemHasTargetTag(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public NBTTagCompound readTargetTagFromNBT(NBTTagCompound nbt) {
        if (!TargetData.nbtHasTargetTag(nbt)) {
            return null;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        this.pos = new BlockPos(tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ"));
        this.dimension = tag.func_74762_e("Dim");
        this.dimensionName = tag.func_74779_i("DimName");
        this.blockName = tag.func_74779_i("BlockName");
        this.blockMeta = tag.func_74771_c("BlockMeta");
        this.itemMeta = tag.func_74771_c("ItemMeta");
        this.blockFace = tag.func_74771_c("BlockFace");
        this.facing = EnumFacing.func_82600_a((int)this.blockFace);
        this.dPosX = tag.func_150297_b("dPosX", 6) ? tag.func_74769_h("dPosX") : (double)this.pos.func_177958_n() + 0.5;
        this.dPosY = tag.func_150297_b("dPosY", 6) ? tag.func_74769_h("dPosY") : (double)this.pos.func_177956_o();
        double d = this.dPosZ = tag.func_150297_b("dPosZ", 6) ? tag.func_74769_h("dPosZ") : (double)this.pos.func_177952_p() + 0.5;
        if (tag.func_150297_b("Yaw", 5) && tag.func_150297_b("Pitch", 5)) {
            this.hasRotation = true;
            this.yaw = tag.func_74760_g("Yaw");
            this.pitch = tag.func_74760_g("Pitch");
        }
        return tag;
    }

    public static TargetData readTargetFromNBT(NBTTagCompound nbt) {
        if (!TargetData.nbtHasTargetTag(nbt)) {
            return null;
        }
        TargetData target = new TargetData();
        target.readTargetTagFromNBT(nbt);
        return target;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, BlockPos pos, double dx, double dy, double dz, int dim, String dimName, String blockName, int blockMeta, int itemMeta, EnumFacing side, float yaw, float pitch, boolean hasAngle) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("posX", pos.func_177958_n());
        tag.func_74768_a("posY", pos.func_177956_o());
        tag.func_74768_a("posZ", pos.func_177952_p());
        tag.func_74780_a("dPosX", dx);
        tag.func_74780_a("dPosY", dy);
        tag.func_74780_a("dPosZ", dz);
        tag.func_74768_a("Dim", dim);
        tag.func_74778_a("DimName", dimName);
        tag.func_74778_a("BlockName", blockName);
        tag.func_74774_a("BlockMeta", (byte)blockMeta);
        tag.func_74777_a("ItemMeta", (short)itemMeta);
        tag.func_74774_a("BlockFace", (byte)side.func_176745_a());
        if (hasAngle) {
            tag.func_74776_a("Yaw", yaw);
            tag.func_74776_a("Pitch", pitch);
        }
        nbt.func_74782_a("Target", (NBTBase)tag);
        return nbt;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, BlockPos pos, int dim, EnumFacing side, EntityPlayer player, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        WorldServer world;
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        double dPosX = pos.func_177958_n();
        double dPosY = pos.func_177956_o();
        double dPosZ = pos.func_177952_p();
        if (doHitOffset) {
            dPosX += hitX;
            dPosY += hitY;
            dPosZ += hitZ;
        }
        String dimName = "";
        String blockName = "";
        int blockMeta = 0;
        int itemMeta = 0;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (world = server.func_71218_a(dim)) != null && world.field_73011_w != null) {
            ResourceLocation rl;
            dimName = world.field_73011_w.func_186058_p().func_186065_b();
            IBlockState iBlockState = world.func_180495_p(pos);
            Block block = iBlockState.func_177230_c();
            blockMeta = block.func_176201_c(iBlockState);
            ItemStack stack = block.getPickBlock(iBlockState, EntityUtils.getRayTraceFromPlayer((World)world, player, false), (World)world, pos, player);
            if (stack != null) {
                itemMeta = stack.func_77960_j();
            }
            if ((rl = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)) != null) {
                blockName = rl.toString();
            }
        }
        return TargetData.writeTargetTagToNBT(nbt, pos, dPosX, dPosY, dPosZ, dim, dimName, blockName, blockMeta, itemMeta, side, yaw, pitch, hasAngle);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return TargetData.writeTargetTagToNBT(nbt, this.pos, this.dPosX, this.dPosY, this.dPosZ, this.dimension, this.dimensionName, this.blockName, this.blockMeta, this.itemMeta, this.facing, this.yaw, this.pitch, this.hasRotation);
    }

    public static NBTTagCompound removeTargetTagFromNBT(NBTTagCompound nbt) {
        return NBTUtils.writeTagToNBT(nbt, "Target", null);
    }

    public static void removeTargetTagFromItem(ItemStack stack) {
        if (stack != null) {
            stack.func_77982_d(TargetData.removeTargetTagFromNBT(stack.func_77978_p()));
        }
    }

    public static boolean removeTargetTagFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            TargetData.removeTargetTagFromItem(moduleStack);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public static void writeTargetTagToItem(ItemStack stack, BlockPos pos, int dim, EnumFacing side, EntityPlayer player, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        if (stack != null) {
            stack.func_77982_d(TargetData.writeTargetTagToNBT(stack.func_77978_p(), pos, dim, side, player, hitX, hitY, hitZ, doHitOffset, yaw, pitch, hasAngle));
        }
    }

    public static boolean writeTargetTagToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, BlockPos pos, int dim, EnumFacing side, EntityPlayer player, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            TargetData.writeTargetTagToItem(moduleStack, pos, dim, side, player, hitX, hitY, hitZ, doHitOffset, yaw, pitch, hasAngle);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public boolean isTargetBlockUnchanged() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return false;
        }
        WorldServer world = server.func_71218_a(this.dimension);
        if (world == null) {
            return false;
        }
        IBlockState iBlockState = world.func_180495_p(this.pos);
        Block block = iBlockState.func_177230_c();
        int meta = block.func_176201_c(iBlockState);
        return this.blockMeta == meta && this.blockName.equals(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public String getTargetBlockDisplayName() {
        Block block = Block.func_149684_b((String)this.blockName);
        ItemStack targetStack = new ItemStack(block, 1, this.itemMeta);
        if (targetStack != null && targetStack.func_77973_b() != null) {
            return targetStack.func_82833_r();
        }
        return null;
    }

    public String getDimensionName(boolean useFallback) {
        try {
            DimensionType type = DimensionType.func_186069_a((int)this.dimension);
            return type.func_186065_b();
        }
        catch (IllegalArgumentException e) {
            EnderUtilities.logger.debug("Failed to get DimensionType by id (" + this.dimension + ")");
            return useFallback ? "DIM: " + this.dimension : "";
        }
    }
}

