/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class UtilItemModular {
    public static boolean moduleTypeEquals(ItemStack moduleStack, ItemModule.ModuleType moduleType) {
        return moduleStack != null && moduleStack.func_77973_b() instanceof IModule && ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(moduleType);
    }

    public static int getInstalledModuleCount(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return 0;
        }
        int count = 0;
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType)) continue;
            ++count;
        }
        return count;
    }

    public static int getMaxModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        int tier = -1;
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return tier;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            int t;
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType) || (t = ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack)) <= tier) continue;
            tier = t;
        }
        return tier;
    }

    public static int getSelectedModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(containerStack, moduleType);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return -1;
        }
        return ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack);
    }

    public static int getSelectedModuleTierAbs(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(containerStack, slotNum += UtilItemModular.getFirstIndexOfModuleType(containerStack, moduleType), moduleType);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return -1;
        }
        return ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack);
    }

    public static int getClampedModuleSelection(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        int num;
        int selected = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        if (selected >= (num = UtilItemModular.getInstalledModuleCount(containerStack, moduleType))) {
            selected = num > 0 ? num - 1 : 0;
        }
        return selected;
    }

    public static int getStoredModuleSelection(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        int max;
        if (containerStack == null || containerStack.func_77978_p() == null || !(containerStack.func_77973_b() instanceof IModular)) {
            return 0;
        }
        int selected = containerStack.func_77978_p().func_74771_c("Selected_" + moduleType.getName());
        return selected < (max = ((IModular)containerStack.func_77973_b()).getMaxModules(containerStack, moduleType)) ? selected : max - 1;
    }

    public static ItemStack getModuleStackBySlotNumber(ItemStack containerStack, int slotNum, ItemModule.ModuleType moduleType) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return null;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            if (moduleTag.func_74771_c("Slot") != slotNum) continue;
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)moduleTag);
            if (moduleType.equals(ItemModule.ModuleType.TYPE_ANY) || UtilItemModular.moduleTypeEquals(moduleStack, moduleType)) {
                return moduleStack;
            }
            return null;
        }
        return null;
    }

    public static ItemStack getSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return null;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        int selected = UtilItemModular.getClampedModuleSelection(containerStack, moduleType);
        int count = -1;
        for (int i = 0; i < listNumStacks && count < selected; ++i) {
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType) || ++count < selected) continue;
            return moduleStack;
        }
        return null;
    }

    public static ItemStack getSelectedModuleStackAbs(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        return UtilItemModular.getModuleStackBySlotNumber(containerStack, slotNum += UtilItemModular.getFirstIndexOfModuleType(containerStack, moduleType), moduleType);
    }

    public static boolean setSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType, ItemStack newModuleStack) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, true);
        int listNumStacks = nbtTagList.func_74745_c();
        int selected = UtilItemModular.getClampedModuleSelection(containerStack, moduleType);
        int count = -1;
        for (int i = 0; i < listNumStacks && count < selected; ++i) {
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            if (!UtilItemModular.moduleTypeEquals(ItemStack.func_77949_a((NBTTagCompound)moduleTag), moduleType) || ++count < selected) continue;
            nbtTagList.func_150304_a(i, (NBTBase)newModuleStack.func_77955_b(moduleTag));
            return true;
        }
        return false;
    }

    public static boolean setSelectedModuleStackAbs(ItemStack containerStack, ItemModule.ModuleType moduleType, ItemStack newModuleStack) {
        int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        return UtilItemModular.setModuleStackBySlotNumber(containerStack, slotNum += UtilItemModular.getFirstIndexOfModuleType(containerStack, moduleType), newModuleStack);
    }

    public static boolean setModuleStackBySlotNumber(ItemStack containerStack, int slotNum, ItemStack moduleStack) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, true);
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            if (!moduleTag.func_150297_b("Slot", 1) || moduleTag.func_74771_c("Slot") != slotNum) continue;
            nbtTagList.func_150304_a(i, (NBTBase)moduleStack.func_77955_b(moduleTag));
            return true;
        }
        NBTTagCompound moduleTag = new NBTTagCompound();
        moduleTag.func_74774_a("Slot", (byte)slotNum);
        moduleStack.func_77955_b(moduleTag);
        nbtTagList.func_74742_a((NBTBase)moduleTag);
        return false;
    }

    public static List<NBTTagCompound> getAllModules(ItemStack containerStack) {
        if (containerStack == null) {
            return null;
        }
        return null;
    }

    public static boolean setAllModules(ItemStack containerStack, List<NBTTagCompound> modules) {
        if (containerStack == null) {
            return false;
        }
        return false;
    }

    public static boolean setModule(ItemStack containerStack, int index, NBTTagCompound nbt) {
        if (containerStack == null) {
            return false;
        }
        return false;
    }

    public static boolean changeSelectedModule(ItemStack containerStack, ItemModule.ModuleType moduleType, boolean reverse) {
        int moduleCount = UtilItemModular.getInstalledModuleCount(containerStack, moduleType);
        NBTTagCompound nbt = containerStack.func_77978_p();
        if (moduleCount == 0 || nbt == null) {
            return false;
        }
        int selected = UtilItemModular.getClampedModuleSelection(containerStack, moduleType);
        if (reverse) {
            if (--selected < 0) {
                selected = moduleCount - 1;
            }
        } else if (++selected >= moduleCount) {
            selected = 0;
        }
        nbt.func_74774_a("Selected_" + moduleType.getName(), (byte)selected);
        return true;
    }

    public static boolean changeSelectedModuleAbs(ItemStack containerStack, ItemModule.ModuleType moduleType, boolean reverse) {
        if (!(containerStack.func_77973_b() instanceof IModular) || ((IModular)containerStack.func_77973_b()).getMaxModules(containerStack, moduleType) <= 0) {
            return false;
        }
        int maxOfType = ((IModular)containerStack.func_77973_b()).getMaxModules(containerStack, moduleType);
        int current = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        if (reverse) {
            if (--current < 0) {
                current = maxOfType - 1;
            }
        } else if (++current >= maxOfType) {
            current = 0;
        }
        UtilItemModular.setModuleSelection(containerStack, moduleType, current);
        return true;
    }

    public static void setModuleSelection(ItemStack containerStack, ItemModule.ModuleType moduleType, int index) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, null, true);
        if (containerStack.func_77973_b() instanceof IModular) {
            index = Math.min(index, ((IModular)containerStack.func_77973_b()).getMaxModules(containerStack, moduleType) - 1);
        }
        if (index < 0) {
            index = 0;
        }
        nbt.func_74774_a("Selected_" + moduleType.getName(), (byte)index);
    }

    public static int getTotalNumberOfStoredItems(ItemStack containerStack) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return 0;
        }
        int count = 0;
        int num = nbtTagList.func_74745_c();
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            if (tag.func_150297_b("ActualCount", 3)) {
                count += tag.func_74762_e("ActualCount");
                continue;
            }
            count += tag.func_74771_c("Count");
        }
        return count;
    }

    public static void readItemNamesFromContainerItem(ItemStack containerStack, List<String> listNames) {
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList == null) {
            return;
        }
        int num = nbtTagList.func_74745_c();
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (stack == null) continue;
            listNames.add(stack.func_82833_r());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getFormattedItemListFromContainerItem(ItemStack containerStack, List<String> listLines, int maxLines) {
        int itemCount = 0;
        int overflow = 0;
        String preWhite = TextFormatting.WHITE.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        NBTTagList nbtTagList = NBTUtils.getStoredItemsList(containerStack, false);
        if (nbtTagList != null && nbtTagList.func_74745_c() > 0) {
            int num = nbtTagList.func_74745_c();
            for (int i = 0; i < num; ++i) {
                ItemStack tmpStack;
                NBTTagCompound tag = nbtTagList.func_150305_b(i);
                if (tag == null || (tmpStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                int stackSize = tmpStack.field_77994_a;
                if (tag.func_150297_b("ActualCount", 3)) {
                    stackSize = tag.func_74762_e("ActualCount");
                }
                itemCount += stackSize;
                if (i < maxLines) {
                    listLines.add(String.format("  %s%4d%s %s", preWhite, stackSize, rst, tmpStack.func_82833_r()));
                    continue;
                }
                ++overflow;
            }
        }
        if (overflow > 0) {
            String str1 = I18n.func_135052_a((String)"enderutilities.tooltip.item.and", (Object[])new Object[0]);
            String str2 = I18n.func_135052_a((String)"enderutilities.tooltip.item.morestacksnotlisted", (Object[])new Object[0]);
            listLines.add(String.format("     ... %s %s%d%s %s", str1, preWhite, overflow, rst, str2));
        }
        return itemCount;
    }

    public static int getListPositionOfStackInSlot(NBTTagList nbtTagList, int slotNum) {
        int size = nbtTagList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            if (!tag.func_150297_b("Slot", 1) || tag.func_74771_c("Slot") != slotNum) continue;
            return i;
        }
        return -1;
    }

    public static int addEnderCharge(ItemStack containerStack, int amount, boolean doCharge) {
        if (!(containerStack.func_77973_b() instanceof IModular)) {
            return 0;
        }
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IChargeable)) {
            return 0;
        }
        IChargeable cap = (IChargeable)moduleStack.func_77973_b();
        if (cap.addCharge(moduleStack, amount, false) == 0) {
            return 0;
        }
        int added = 0;
        if (doCharge) {
            added = cap.addCharge(moduleStack, amount, true);
            UtilItemModular.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR, moduleStack);
        }
        return added;
    }

    public static int getAvailableEnderCharge(ItemStack containerStack) {
        if (!(containerStack.func_77973_b() instanceof IModular)) {
            return 0;
        }
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IChargeable)) {
            return 0;
        }
        return ((IChargeable)moduleStack.func_77973_b()).getCharge(moduleStack);
    }

    public static boolean useEnderCharge(ItemStack containerStack, int amount, boolean simulate) {
        if (!Configs.useEnderCharge) {
            return true;
        }
        if (!(containerStack.func_77973_b() instanceof IModular)) {
            return false;
        }
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof ItemEnderCapacitor)) {
            return false;
        }
        ItemEnderCapacitor cap = (ItemEnderCapacitor)moduleStack.func_77973_b();
        if (cap.useCharge(moduleStack, amount, false) < amount) {
            return false;
        }
        if (!simulate) {
            cap.useCharge(moduleStack, amount, true);
            UtilItemModular.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR, moduleStack);
        }
        return true;
    }

    public static void setTarget(ItemStack containerStack, EntityPlayer player, boolean storeRotation) {
        BlockPos pos = player.func_180425_c();
        double hitX = player.field_70165_t - (double)pos.func_177958_n();
        double hitY = player.field_70163_u - (double)pos.func_177956_o();
        double hitZ = player.field_70161_v - (double)pos.func_177952_p();
        boolean adjustPosHit = UtilItemModular.getSelectedModuleTier(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0;
        UtilItemModular.setTarget(containerStack, player, pos, EnumFacing.UP, hitX, hitY, hitZ, adjustPosHit, storeRotation);
    }

    public static void setTarget(ItemStack containerStack, EntityPlayer player, BlockPos pos, EnumFacing side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        if (!OwnerData.canAccessSelectedModule(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return;
        }
        TargetData.writeTargetTagToSelectedModule(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, pos, player.field_71093_bK, side, player, hitX, hitY, hitZ, doHitOffset, player.field_70177_z, player.field_70125_A, storeRotation);
        OwnerData.addOwnerDataToSelectedModuleOptional(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player, true);
    }

    public static void changePrivacyModeOnSelectedModuleAbs(ItemStack containerStack, EntityPlayer player, ItemModule.ModuleType moduleType) {
        int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, moduleType);
        ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(containerStack, slotNum, moduleType);
        if (moduleStack == null) {
            return;
        }
        OwnerData.togglePrivacyModeOnItem(moduleStack, (Entity)player);
        UtilItemModular.setModuleStackBySlotNumber(containerStack, slotNum, moduleStack);
    }

    public static int getFirstIndexOfModuleType(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (containerStack == null || !(containerStack.func_77973_b() instanceof IModular)) {
            return 0;
        }
        IModular item = (IModular)containerStack.func_77973_b();
        int start = 0;
        for (ItemModule.ModuleType type : ItemModule.ModuleType.values()) {
            if (type.equals(moduleType)) break;
            start += item.getMaxModules(containerStack, type);
        }
        return start;
    }

    public static IItemHandler getBoundInventory(ItemStack modularStack, EntityPlayer player, int chunkLoadDuration) {
        TileEntity te;
        if (modularStack == null || !(modularStack.func_77973_b() instanceof IModular)) {
            return null;
        }
        IModular iModular = (IModular)modularStack.func_77973_b();
        TargetData target = TargetData.getTargetFromSelectedModule(modularStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (iModular.getSelectedModuleTier(modularStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) != 1 || target == null) {
            return null;
        }
        if ("minecraft:ender_chest".equals(target.blockName)) {
            return new InvWrapper((IInventory)player.func_71005_bN());
        }
        if (!OwnerData.canAccessSelectedModule(modularStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) || target.dimension != player.field_71093_bK && iModular.getMaxModuleTier(modularStack, ItemModule.ModuleType.TYPE_ENDERCORE) != 2) {
            return null;
        }
        WorldServer targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(target.dimension);
        if (targetWorld == null) {
            return null;
        }
        if (chunkLoadDuration > 0) {
            ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4, chunkLoadDuration);
        }
        if ((te = targetWorld.func_175625_s(target.pos)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing) || !target.isTargetBlockUnchanged()) {
            TargetData.removeTargetTagFromSelectedModule(modularStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.bound.block.changed", new Object[0]));
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, target.facing);
    }
}

