/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.config.Config;
import mezz.jei.gui.RecipeClickableArea;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.RecipeCategoryComparator;
import mezz.jei.util.RecipeMap;
import mezz.jei.util.StackHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeRegistry
implements IRecipeRegistry {
    private final List<IRecipeHandler> recipeHandlers;
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMultimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap;
    private final ImmutableMultimap<IRecipeCategory, ItemStack> craftItemsForCategories;
    private final ImmutableMultimap<String, String> categoriesForCraftItemKeys;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final ListMultimap<IRecipeCategory, Object> recipesForCategories;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Set<Class> unhandledRecipeClasses;

    public RecipeRegistry(List<IRecipeCategory> recipeCategories, List<IRecipeHandler> recipeHandlers, List<IRecipeTransferHandler> recipeTransferHandlers, List<Object> recipes, Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap, Multimap<String, ItemStack> craftItemsForCategories) {
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = RecipeRegistry.buildRecipeTransferHandlerTable(recipeTransferHandlers);
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersList(recipeHandlers);
        this.recipeClickableAreasMap = ImmutableMultimap.copyOf(recipeClickableAreasMap);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator);
        this.unhandledRecipeClasses = new HashSet<Class>();
        this.recipesForCategories = ArrayListMultimap.create();
        this.addRecipes(recipes);
        StackHelper stackHelper = Internal.getStackHelper();
        ImmutableMultimap.Builder craftItemsForCategoriesBuilder = ImmutableMultimap.builder();
        ImmutableMultimap.Builder categoriesForCraftItemKeysBuilder = ImmutableMultimap.builder();
        for (Map.Entry recipeCategoryEntry : craftItemsForCategories.asMap().entrySet()) {
            String recipeCategoryUid = (String)recipeCategoryEntry.getKey();
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null) continue;
            Collection craftItems = (Collection)recipeCategoryEntry.getValue();
            craftItemsForCategoriesBuilder.putAll((Object)recipeCategory, (Iterable)craftItems);
            for (ItemStack craftItem : craftItems) {
                this.recipeInputMap.addRecipeCategory(recipeCategory, craftItem);
                String craftItemKey = stackHelper.getUniqueIdentifierForStack(craftItem);
                categoriesForCraftItemKeysBuilder.put((Object)craftItemKey, (Object)recipeCategoryUid);
            }
        }
        this.craftItemsForCategories = craftItemsForCategoriesBuilder.build();
        this.categoriesForCraftItemKeys = categoriesForCraftItemKeysBuilder.build();
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(List<IRecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableList<IRecipeHandler> buildRecipeHandlersList(List<IRecipeHandler> recipeHandlers) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (recipeHandler == null) continue;
            Class recipeClass = recipeHandler.getRecipeClass();
            if (recipeHandlerClasses.contains(recipeClass)) {
                throw new IllegalArgumentException("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName());
            }
            recipeHandlerClasses.add(recipeClass);
            listBuilder.add((Object)recipeHandler);
        }
        return listBuilder.build();
    }

    private static ImmutableTable<Class, String, IRecipeTransferHandler> buildRecipeTransferHandlerTable(List<IRecipeTransferHandler> recipeTransferHandlers) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (IRecipeTransferHandler recipeTransferHelper : recipeTransferHandlers) {
            builder.put(recipeTransferHelper.getContainerClass(), (Object)recipeTransferHelper.getRecipeCategoryUid(), (Object)recipeTransferHelper);
        }
        return builder.build();
    }

    private void addRecipes(@Nullable List<Object> recipes) {
        if (recipes == null) {
            return;
        }
        for (Object recipe : recipes) {
            this.addRecipe(recipe);
        }
    }

    @Override
    public void addRecipe(@Nullable Object recipe) {
        if (recipe == null) {
            Log.error("Null recipe", new NullPointerException());
            return;
        }
        this.addRecipe(recipe, recipe.getClass());
    }

    private <T> void addRecipe(T recipe, Class<? extends T> recipeClass) {
        String recipeCategoryUid;
        IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass);
        if (recipeHandler == null) {
            if (!this.unhandledRecipeClasses.contains(recipeClass)) {
                this.unhandledRecipeClasses.add(recipeClass);
                if (Config.isDebugModeEnabled()) {
                    Log.debug("Can't handle recipe: {}", recipeClass);
                }
            }
            return;
        }
        try {
            recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
        }
        catch (AbstractMethodError ignored) {
            recipeCategoryUid = recipeHandler.getRecipeCategoryUid();
        }
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        if (!recipeHandler.isRecipeValid(recipe)) {
            return;
        }
        try {
            this.addRecipeUnchecked(recipe, recipeCategory, recipeHandler);
        }
        catch (RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            String errorMessage = e.getMessage();
            if ("Found an itemStack with a null item. This is an error from another mod.".equals(errorMessage)) {
                Log.error("Found a broken recipe: {}\n", recipeInfo);
            } else {
                Log.error("Found a broken recipe: {}\n", recipeInfo, e);
            }
        }
        catch (LinkageError e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            String errorMessage = e.getMessage();
            if ("Found an itemStack with a null item. This is an error from another mod.".equals(errorMessage)) {
                Log.error("Found a broken recipe: {}\n", recipeInfo);
            }
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
    }

    private <T> void addRecipeUnchecked(T recipe, IRecipeCategory recipeCategory, IRecipeHandler<T> recipeHandler) {
        StackHelper stackHelper = Internal.getStackHelper();
        IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        List inputs = recipeWrapper.getInputs();
        List<Object> fluidInputs = recipeWrapper.getFluidInputs();
        if (inputs != null || fluidInputs != null) {
            List<ItemStack> inputStacks = stackHelper.toItemStackList(inputs);
            if (fluidInputs == null) {
                fluidInputs = Collections.emptyList();
            }
            this.recipeInputMap.addRecipe(recipe, recipeCategory, inputStacks, fluidInputs);
        }
        List outputs = recipeWrapper.getOutputs();
        List<Object> fluidOutputs = recipeWrapper.getFluidOutputs();
        if (outputs != null || fluidOutputs != null) {
            List<ItemStack> outputStacks = stackHelper.toItemStackList(outputs);
            if (fluidOutputs == null) {
                fluidOutputs = Collections.emptyList();
            }
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, outputStacks, fluidOutputs);
        }
        this.recipesForCategories.put((Object)recipeCategory, recipe);
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IRecipeCategory recipeCategory : this.recipeCategoriesMap.values()) {
            if (this.getRecipes(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories(@Nullable List<String> recipeCategoryUids) {
        if (recipeCategoryUids == null) {
            Log.error("Null recipeCategoryUids", new NullPointerException());
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || this.getRecipes(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public <T> IRecipeHandler<T> getRecipeHandler(@Nullable Class<? extends T> recipeClass) {
        if (recipeClass == null) {
            Log.error("Null recipeClass", new NullPointerException());
            return null;
        }
        for (IRecipeHandler recipeHandler : this.recipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        return null;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        ImmutableCollection recipeClickableAreas = this.recipeClickableAreasMap.get(gui.getClass());
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable ItemStack input) {
        if (input == null) {
            Log.error("Null ItemStack input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipeCategories(input);
    }

    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable FluidStack input) {
        if (input == null) {
            Log.error("Null Fluid input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipeCategories(input);
    }

    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable ItemStack output) {
        if (output == null) {
            Log.error("Null ItemStack output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipeCategories(output);
    }

    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable FluidStack output) {
        if (output == null) {
            Log.error("Null Fluid output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipeCategories(output);
    }

    @Override
    public List<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack input) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (input == null) {
            Log.error("Null ItemStack input", new NullPointerException());
            return ImmutableList.of();
        }
        ImmutableList<Object> recipes = this.recipeInputMap.getRecipes(recipeCategory, input);
        String recipeCategoryUid = recipeCategory.getUid();
        for (String inputKey : Internal.getStackHelper().getUniqueIdentifiersWithWildcard(input)) {
            if (!this.categoriesForCraftItemKeys.get((Object)inputKey).contains((Object)recipeCategoryUid)) continue;
            ImmutableSet specificRecipes = ImmutableSet.copyOf(recipes);
            List recipesForCategory = this.recipesForCategories.get((Object)recipeCategory);
            ArrayList<Object> allRecipes = new ArrayList<Object>((Collection<Object>)recipes);
            for (Object recipe : recipesForCategory) {
                if (specificRecipes.contains(recipe)) continue;
                allRecipes.add(recipe);
            }
            return allRecipes;
        }
        return recipes;
    }

    @Override
    public List<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable FluidStack input) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (input == null) {
            Log.error("Null Fluid input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipes(recipeCategory, input);
    }

    public ImmutableList<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack output) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (output == null) {
            Log.error("Null ItemStack output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, output);
    }

    @Override
    public List<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable FluidStack output) {
        if (recipeCategory == null) {
            return ImmutableList.of();
        }
        if (output == null) {
            Log.error("Null Fluid output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, output);
    }

    @Override
    public List<Object> getRecipes(@Nullable IRecipeCategory recipeCategory) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.recipesForCategories.get((Object)recipeCategory));
    }

    public ImmutableCollection<ItemStack> getCraftingItems(IRecipeCategory recipeCategory) {
        return this.craftItemsForCategories.get((Object)recipeCategory);
    }

    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(@Nullable Container container, @Nullable IRecipeCategory recipeCategory) {
        if (container == null) {
            Log.error("Null container", new NullPointerException());
            return null;
        }
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return null;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(container.getClass(), (Object)recipeCategory.getUid());
    }
}

