/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.Constants;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.IShowsRecipeFocuses;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RecipeCategoryCraftingItemsArea
implements IShowsRecipeFocuses {
    private final IDrawable leftDrawable;
    private final IDrawable spacerDrawable;
    private final IDrawable rightDrawable;
    private final IDrawable boxDrawable;
    private GuiItemStackGroup craftingItems = new GuiItemStackGroup((IFocus<ItemStack>)new Focus<Object>(null));
    private int left = 0;
    private int top = 0;

    public RecipeCategoryCraftingItemsArea() {
        ResourceLocation recipeBackgroundResource = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.leftDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 15, 5, 25);
        this.spacerDrawable = guiHelper.createDrawable(recipeBackgroundResource, 204, 15, 2, 25);
        this.rightDrawable = guiHelper.createDrawable(recipeBackgroundResource, 209, 15, 5, 25);
        this.boxDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 40, 18, 25);
    }

    public void updateLayout(Collection<ItemStack> itemStacks, GuiProperties guiProperties) {
        this.craftingItems = new GuiItemStackGroup((IFocus<ItemStack>)new Focus<Object>(null));
        if (!itemStacks.isEmpty()) {
            int totalWidth = this.leftDrawable.getWidth() + this.boxDrawable.getWidth() + this.rightDrawable.getWidth();
            int ingredientCount = 1;
            int extraBoxWidth = this.boxDrawable.getWidth() + this.spacerDrawable.getWidth();
            for (int i = 1; i < itemStacks.size() && totalWidth + extraBoxWidth <= guiProperties.getGuiXSize() - 8; ++i) {
                totalWidth += extraBoxWidth;
                ++ingredientCount;
            }
            this.left = guiProperties.getGuiLeft() + (guiProperties.getGuiXSize() - totalWidth) / 2;
            this.top = guiProperties.getGuiTop() - this.boxDrawable.getHeight() + 3;
            ArrayList<ItemStack> itemStacksCopy = new ArrayList<ItemStack>(itemStacks);
            for (int i = 0; i < ingredientCount; ++i) {
                this.craftingItems.init(i, true, this.left + 5 + i * 20, this.top + 5);
                if (i + 1 >= ingredientCount) {
                    this.craftingItems.set(i, itemStacksCopy);
                    break;
                }
                ItemStack itemStack = (ItemStack)itemStacksCopy.remove(0);
                this.craftingItems.set(i, itemStack);
            }
        }
    }

    @Nullable
    public GuiIngredient<ItemStack> draw(Minecraft minecraft, int mouseX, int mouseY) {
        int ingredientCount = this.craftingItems.getGuiIngredients().keySet().size();
        if (ingredientCount > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            int left = this.left;
            this.leftDrawable.draw(minecraft, left, this.top);
            this.boxDrawable.draw(minecraft, left += this.leftDrawable.getWidth(), this.top);
            left += this.boxDrawable.getWidth();
            while (--ingredientCount > 0) {
                this.spacerDrawable.draw(minecraft, left, this.top);
                this.boxDrawable.draw(minecraft, left += this.spacerDrawable.getWidth(), this.top);
                left += this.boxDrawable.getWidth();
            }
            this.rightDrawable.draw(minecraft, left, this.top);
            GlStateManager.func_179118_c();
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            Object hovered = this.craftingItems.draw(minecraft, 0, 0, mouseX, mouseY);
            RenderHelper.func_74518_a();
            return hovered;
        }
        return null;
    }

    @Override
    @Nullable
    public Focus<?> getFocusUnderMouse(int mouseX, int mouseY) {
        return this.craftingItems.getFocusUnderMouse(0, 0, mouseX, mouseY);
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }
}

