/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.IRecipeGuiLogic;
import mezz.jei.gui.MasterFocus;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final RecipeRegistry recipeRegistry;
    @Nullable
    private State state = null;
    private final Stack<State> history = new Stack();
    private List<Object> recipes = Collections.emptyList();
    private Collection<ItemStack> recipeCategoryCraftingItems = Collections.emptyList();

    public RecipeGuiLogic(RecipeRegistry recipeRegistry) {
        this.recipeRegistry = recipeRegistry;
    }

    @Override
    public boolean setFocus(MasterFocus focus) {
        return this.setFocus(focus, true);
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        State state = this.history.pop();
        this.setState(state);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private boolean setFocus(MasterFocus focus, boolean saveHistory) {
        if (this.state != null && this.state.focus.equalsFocus(focus)) {
            return true;
        }
        List<IRecipeCategory> recipeCategories = focus.getCategories();
        if (recipeCategories.isEmpty()) {
            return false;
        }
        int recipeCategoryIndex = this.getRecipeCategoryIndex(recipeCategories);
        if (this.state != null && saveHistory) {
            this.history.push(this.state);
        }
        State state = new State(focus, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    private void setState(State state) {
        this.state = state;
        this.updateRecipes();
    }

    private int getRecipeCategoryIndex(List<IRecipeCategory> recipeCategories) {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container == null) {
            return 0;
        }
        for (int i = 0; i < recipeCategories.size(); ++i) {
            IRecipeCategory recipeCategory = recipeCategories.get(i);
            if (this.recipeRegistry.getRecipeTransferHandler(container, recipeCategory) == null) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        ImmutableList<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories();
        int recipeCategoryIndex = recipeCategories.indexOf(recipeCategory);
        State state = new State(new MasterFocus(this.recipeRegistry), (List<IRecipeCategory>)recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<String> recipeCategoryUids) {
        ImmutableList<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        State state = new State(new MasterFocus(this.recipeRegistry), (List<IRecipeCategory>)recipeCategories, 0, 0);
        this.setState(state);
        return true;
    }

    @Override
    public MasterFocus getFocus() {
        if (this.state == null) {
            return null;
        }
        return this.state.focus;
    }

    @Override
    public Collection<ItemStack> getRecipeCategoryCraftingItems() {
        return this.recipeCategoryCraftingItems;
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state == null) {
            return;
        }
        if (this.state.recipesPerPage != recipesPerPage) {
            int recipeIndex = this.state.pageIndex * this.state.recipesPerPage;
            this.state.pageIndex = recipeIndex / recipesPerPage;
            this.state.recipesPerPage = recipesPerPage;
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        if (this.state == null) {
            return;
        }
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            this.recipes = Collections.emptyList();
            this.recipeCategoryCraftingItems = Collections.emptyList();
        } else {
            MasterFocus focus = this.state.focus;
            this.recipes = focus.getRecipes(recipeCategory);
            this.recipeCategoryCraftingItems = focus.getRecipeCategoryCraftingItems(recipeCategory);
        }
    }

    @Override
    @Nullable
    public IRecipeCategory getRecipeCategory() {
        if (this.state == null || this.state.recipeCategories.size() == 0) {
            return null;
        }
        return (IRecipeCategory)this.state.recipeCategories.get(this.state.recipeCategoryIndex);
    }

    @Override
    public List<RecipeLayout> getRecipeWidgets(int posX, int posY, int spacingY) {
        if (this.state == null) {
            return Collections.emptyList();
        }
        ArrayList<RecipeLayout> recipeWidgets = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return recipeWidgets;
        }
        int recipeWidgetIndex = 0;
        for (int recipeIndex = this.state.pageIndex * this.state.recipesPerPage; recipeIndex < this.recipes.size() && recipeWidgets.size() < this.state.recipesPerPage; ++recipeIndex) {
            Object recipe = this.recipes.get(recipeIndex);
            IRecipeWrapper recipeWrapper = this.getRecipeWrapper(this.recipeRegistry, recipe, recipe.getClass());
            if (recipeWrapper == null) continue;
            RecipeLayout recipeWidget = new RecipeLayout(recipeWidgetIndex++, posX, posY, recipeCategory, recipeWrapper, this.state.focus);
            recipeWidgets.add(recipeWidget);
            posY += spacingY;
        }
        return recipeWidgets;
    }

    @Nullable
    private <T> IRecipeWrapper getRecipeWrapper(IRecipeRegistry recipeRegistry, T recipe, Class<? extends T> recipeClass) {
        IRecipeHandler<T> recipeHandler = recipeRegistry.getRecipeHandler(recipeClass);
        if (recipeHandler == null) {
            Log.error("Couldn't find recipe handler for recipe: {}", recipe);
            return null;
        }
        return recipeHandler.getRecipeWrapper(recipe);
    }

    @Override
    public void nextRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (this.state.recipeCategoryIndex + 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.state != null && this.recipes.size() > this.state.recipesPerPage;
    }

    @Override
    public void previousRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (recipesTypesCount + this.state.recipeCategoryIndex - 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public void nextPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.state.recipesPerPage);
        this.state.pageIndex = (this.state.pageIndex + 1) % pageCount;
        this.updateRecipes();
    }

    @Override
    public void previousPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.state.recipesPerPage);
        this.state.pageIndex = (pageCount + this.state.pageIndex - 1) % pageCount;
        this.updateRecipes();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    public String getPageString() {
        if (this.state == null) {
            return "1/1";
        }
        return this.state.pageIndex + 1 + "/" + this.pageCount(this.state.recipesPerPage);
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state != null && this.state.recipeCategories.size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        return this.state != null && this.state.recipeCategories.size() == this.recipeRegistry.getRecipeCategories().size();
    }

    private static class State {
        @Nonnull
        public final MasterFocus focus;
        @Nonnull
        public final ImmutableList<IRecipeCategory> recipeCategories;
        public int recipeCategoryIndex;
        public int pageIndex;
        public int recipesPerPage;

        public State(MasterFocus focus, List<IRecipeCategory> recipeCategories, int recipeCategoryIndex, int pageIndex) {
            this.focus = focus;
            this.recipeCategories = ImmutableList.copyOf(recipeCategories);
            this.recipeCategoryIndex = recipeCategoryIndex;
            this.pageIndex = pageIndex;
        }
    }
}

