/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.MasterFocus;
import mezz.jei.gui.RecipeTransferButton;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLayout
implements IRecipeLayout {
    private static final int RECIPE_BUTTON_SIZE = 12;
    public static final int recipeTransferButtonIndex = 100;
    private final IRecipeCategory recipeCategory;
    private final GuiItemStackGroup guiItemStackGroup;
    private final GuiFluidStackGroup guiFluidStackGroup;
    private final RecipeTransferButton recipeTransferButton;
    private final IRecipeWrapper recipeWrapper;
    private final int posX;
    private final int posY;

    public <T extends IRecipeWrapper> RecipeLayout(int index, int posX, int posY, IRecipeCategory<T> recipeCategory, T recipeWrapper, MasterFocus focus) {
        this.recipeCategory = recipeCategory;
        this.guiItemStackGroup = new GuiItemStackGroup((IFocus<ItemStack>)new Focus<ItemStack>(focus.getMode(), focus.getItemStack()));
        this.guiFluidStackGroup = new GuiFluidStackGroup((IFocus<FluidStack>)new Focus<FluidStack>(focus.getMode(), focus.getFluidStack()));
        int width = recipeCategory.getBackground().getWidth();
        int height = recipeCategory.getBackground().getHeight();
        this.recipeTransferButton = new RecipeTransferButton(100 + index, posX + width + 2, posY + height - 12, 12, 12, "+");
        this.posX = posX;
        this.posY = posY;
        this.recipeWrapper = recipeWrapper;
        recipeCategory.setRecipe(this, recipeWrapper);
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        List<String> tooltipStrings;
        IDrawable background = this.recipeCategory.getBackground();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        this.recipeCategory.drawAnimations(minecraft);
        this.recipeWrapper.drawAnimations(minecraft, background.getWidth(), background.getHeight());
        GlStateManager.func_179121_F();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight(), recipeMouseX, recipeMouseY);
        GlStateManager.func_179121_F();
        RenderHelper.func_74520_c();
        Object hoveredItemStack = this.guiItemStackGroup.draw(minecraft, this.posX, this.posY, mouseX, mouseY);
        RenderHelper.func_74518_a();
        Object hoveredFluidStack = this.guiFluidStackGroup.draw(minecraft, this.posX, this.posY, mouseX, mouseY);
        this.recipeTransferButton.func_146112_a(minecraft, mouseX, mouseY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        if (hoveredItemStack != null) {
            RenderHelper.func_74520_c();
            ((GuiIngredient)hoveredItemStack).drawHovered(minecraft, this.posX, this.posY, recipeMouseX, recipeMouseY);
            RenderHelper.func_74518_a();
        } else if (hoveredFluidStack != null) {
            ((GuiIngredient)hoveredFluidStack).drawHovered(minecraft, this.posX, this.posY, recipeMouseX, recipeMouseY);
        } else if (this.isMouseOver(mouseX, mouseY) && (tooltipStrings = this.recipeWrapper.getTooltipStrings(recipeMouseX, recipeMouseY)) != null && !tooltipStrings.isEmpty()) {
            TooltipRenderer.drawHoveringText(minecraft, tooltipStrings, mouseX, mouseY);
        }
        GlStateManager.func_179118_c();
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        IDrawable background = this.recipeCategory.getBackground();
        return recipeMouseX >= 0 && recipeMouseX < background.getWidth() && recipeMouseY >= 0 && recipeMouseY < background.getHeight();
    }

    @Nullable
    public Focus<?> getFocusUnderMouse(int mouseX, int mouseY) {
        Focus focus = this.guiItemStackGroup.getFocusUnderMouse(this.posX, this.posY, mouseX, mouseY);
        if (focus == null) {
            focus = this.guiFluidStackGroup.getFocusUnderMouse(this.posX, this.posY, mouseX, mouseY);
        }
        return focus;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return this.recipeWrapper.handleClick(minecraft, mouseX - this.posX, mouseY - this.posY, mouseButton);
    }

    @Override
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    public IGuiFluidStackGroup getFluidStacks() {
        return this.guiFluidStackGroup;
    }

    @Override
    public void setRecipeTransferButton(int posX, int posY) {
        this.recipeTransferButton.field_146128_h = posX + this.posX;
        this.recipeTransferButton.field_146129_i = posY + this.posY;
    }

    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    public IRecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    public IRecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

