/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackRenderer
implements IIngredientRenderer<FluidStack> {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private final int capacityMb;
    private final boolean showCapacity;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public FluidStackRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        this.capacityMb = capacityMb;
        this.showCapacity = showCapacity;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    @Override
    public void setIngredients(Collection<FluidStack> ingredients) {
    }

    @Override
    public void draw(Minecraft minecraft, int xPosition, int yPosition, @Nullable FluidStack fluidStack) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawFluid(minecraft, xPosition, yPosition, fluidStack);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlay != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.overlay.draw(minecraft, xPosition, yPosition);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawFluid(Minecraft minecraft, int xPosition, int yPosition, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        int fluidColor = fluid.getColor(fluidStack);
        int scaledAmount = fluidStack.amount * this.height / this.capacityMb;
        if (fluidStack.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        FluidStackRenderer.setGLColorFromInt(fluidColor);
        int xTileCount = this.width / 16;
        int xRemainder = this.width - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + this.height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidStackRenderer.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public List<String> getTooltip(Minecraft minecraft, FluidStack fluidStack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        Fluid fluidType = fluidStack.getFluid();
        if (fluidType == null) {
            return tooltip;
        }
        String fluidName = fluidType.getLocalizedName(fluidStack);
        tooltip.add(fluidName);
        String amount = this.showCapacity ? Translator.translateToLocalFormatted("jei.tooltip.liquid.amount.with.capacity", fluidStack.amount, this.capacityMb) : Translator.translateToLocalFormatted("jei.tooltip.liquid.amount", fluidStack.amount);
        tooltip.add(TextFormatting.GRAY + amount);
        return tooltip;
    }

    @Override
    public FontRenderer getFontRenderer(Minecraft minecraft, FluidStack fluidStack) {
        return minecraft.field_71466_p;
    }
}

