/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientHelper;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.util.CycleTimer;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class GuiIngredient<T>
extends Gui
implements IGuiIngredient<T> {
    private final int slotIndex;
    private final boolean input;
    private final int xPosition;
    private final int yPosition;
    private final int width;
    private final int height;
    private final int padding;
    private final CycleTimer cycleTimer;
    private final List<T> displayIngredients = new ArrayList<T>();
    private final List<T> allIngredients = new ArrayList<T>();
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientHelper<T> ingredientHelper;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;
    private boolean enabled;

    public GuiIngredient(IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper, int slotIndex, boolean input, int xPosition, int yPosition, int width, int height, int padding, int itemCycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.padding = padding;
        this.cycleTimer = new CycleTimer(itemCycleOffset);
    }

    public boolean isMouseOver(int xOffset, int yOffset, int mouseX, int mouseY) {
        return this.enabled && mouseX >= xOffset + this.xPosition && mouseY >= yOffset + this.yPosition && mouseX < xOffset + this.xPosition + this.width && mouseY < yOffset + this.yPosition + this.height;
    }

    @Nullable
    public T getIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    @Nullable
    public Focus<T> getCurrentlyDisplayed() {
        T ingredient = this.getIngredient();
        if (ingredient == null) {
            return null;
        }
        return this.ingredientHelper.createFocus(ingredient);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    public void set(T ingredient, IFocus<T> focus) {
        this.set((Collection<T>)Collections.singleton(ingredient), focus);
    }

    public void set(Collection<T> ingredients, IFocus<T> focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        ingredients = this.ingredientHelper.expandSubtypes(ingredients);
        Object match = null;
        if (this.isInput() && focus.getMode() == IFocus.Mode.INPUT || !this.isInput() && focus.getMode() == IFocus.Mode.OUTPUT) {
            match = this.ingredientHelper.getMatch(ingredients, focus);
        }
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            this.displayIngredients.addAll(ingredients);
        }
        this.ingredientRenderer.setIngredients(ingredients);
        this.allIngredients.addAll(ingredients);
        this.enabled = !this.displayIngredients.isEmpty();
    }

    public void setTooltipCallback(@Nullable ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        this.cycleTimer.onDraw();
        T value = this.getIngredient();
        this.ingredientRenderer.draw(minecraft, xOffset + this.xPosition + this.padding, yOffset + this.yPosition + this.padding, value);
    }

    public void drawHovered(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY) {
        T value = this.getIngredient();
        if (value == null) {
            return;
        }
        this.draw(minecraft, xOffset, yOffset);
        this.drawTooltip(minecraft, xOffset, yOffset, mouseX, mouseY, value);
    }

    @Override
    public void drawHighlight(Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.xPosition + xOffset + this.padding;
        int y = this.yPosition + yOffset + this.padding;
        GlStateManager.func_179140_f();
        GuiIngredient.func_73734_a((int)x, (int)y, (int)(x + this.width - this.padding * 2), (int)(y + this.height - this.padding * 2), (int)color.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawTooltip(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY, T value) {
        try {
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GuiIngredient.func_73734_a((int)(xOffset + this.xPosition + this.padding), (int)(yOffset + this.yPosition + this.padding), (int)(xOffset + this.xPosition + this.width - this.padding), (int)(yOffset + this.yPosition + this.height - this.padding), (int)Integer.MAX_VALUE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            List<String> tooltip = this.ingredientRenderer.getTooltip(minecraft, value);
            if (this.tooltipCallback != null) {
                this.tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, value);
            if (value instanceof ItemStack) {
                TooltipRenderer.drawHoveringText((ItemStack)value, minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            } else {
                TooltipRenderer.drawHoveringText(minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            }
            GlStateManager.func_179126_j();
        }
        catch (RuntimeException e) {
            Log.error("Exception when rendering tooltip on {}.", value, e);
        }
    }

    @Override
    public boolean isInput() {
        return this.input;
    }
}

