/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiIngredient;
import net.minecraft.client.Minecraft;

public abstract class GuiIngredientGroup<T, V extends GuiIngredient<T>>
implements IGuiIngredientGroup<T> {
    protected final int itemCycleOffset = (int)(Math.random() * 1000.0);
    protected final Map<Integer, V> guiIngredients = new HashMap<Integer, V>();
    protected final IFocus<T> focus;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;

    public GuiIngredientGroup(IFocus<T> focus) {
        this.focus = focus;
    }

    @Override
    public IFocus<T> getFocus() {
        return this.focus;
    }

    @Override
    public void set(int slotIndex, Collection<T> values) {
        ((GuiIngredient)this.guiIngredients.get(slotIndex)).set(values, this.focus);
    }

    @Override
    public void set(int slotIndex, T value) {
        ((GuiIngredient)this.guiIngredients.get(slotIndex)).set(value, this.focus);
    }

    @Override
    public void addTooltipCallback(ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    @Override
    public Map<Integer, V> getGuiIngredients() {
        return this.guiIngredients;
    }

    @Nullable
    public Focus<T> getFocusUnderMouse(int xOffset, int yOffset, int mouseX, int mouseY) {
        for (GuiIngredient widget : this.guiIngredients.values()) {
            if (widget == null || !widget.isMouseOver(xOffset, yOffset, mouseX, mouseY)) continue;
            return widget.getCurrentlyDisplayed();
        }
        return null;
    }

    @Nullable
    public V draw(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY) {
        GuiIngredient hovered = null;
        for (GuiIngredient ingredient : this.guiIngredients.values()) {
            if (hovered == null && ingredient.isMouseOver(xOffset, yOffset, mouseX, mouseY)) {
                hovered = ingredient;
                hovered.setTooltipCallback(this.tooltipCallback);
                continue;
            }
            ingredient.draw(minecraft, xOffset, yOffset);
        }
        return (V)hovered;
    }
}

