/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.base.Joiner;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.util.Translator;
import mezz.jei.util.color.ColorNamer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;

public class GuiItemStackFast {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final int blacklistItemColor = Color.yellow.getRGB();
    private static final int blacklistWildColor = Color.red.getRGB();
    private static final int blacklistModColor = Color.blue.getRGB();
    private final Rectangle area;
    private final int padding;
    private final ItemModelMesher itemModelMesher;
    @Nullable
    private ItemStack itemStack;

    public GuiItemStackFast(int xPosition, int yPosition, int padding) {
        this.padding = padding;
        int size = 16 + 2 * padding;
        this.area = new Rectangle(xPosition, yPosition, size, size);
        this.itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void clear() {
        this.itemStack = null;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.itemStack != null && this.area.contains(mouseX, mouseY);
    }

    public void renderItemAndEffectIntoGUI() {
        if (this.itemStack == null) {
            return;
        }
        IBakedModel bakedModel = this.itemModelMesher.func_178089_a(this.itemStack);
        bakedModel = bakedModel.func_188617_f().handleItemState(bakedModel, this.itemStack, null, null);
        if (Config.isEditModeEnabled()) {
            this.renderEditMode();
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(this.area.x + this.padding) + 8.0f), (float)((float)(this.area.y + this.padding) + 8.0f), (float)150.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_175036_a(bakedModel, this.itemStack);
        if (this.itemStack.func_77962_s()) {
            this.renderEffect(bakedModel);
        }
        GlStateManager.func_179121_F();
    }

    private void renderEffect(IBakedModel model) {
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        RenderItem renderItem = minecraft.func_175599_af();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179112_b((int)768, (int)1);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_175035_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_175035_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    public void renderSlow() {
        if (Config.isEditModeEnabled()) {
            this.renderEditMode();
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_184391_a(null, this.itemStack, this.area.x + this.padding, this.area.y + this.padding);
        GlStateManager.func_179084_k();
    }

    public void renderOverlay(Minecraft minecraft) {
        if (this.itemStack == null) {
            return;
        }
        FontRenderer font = GuiItemStackFast.getFontRenderer(minecraft, this.itemStack);
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_180453_a(font, this.itemStack, this.area.x + this.padding, this.area.y + this.padding, null);
    }

    private void renderEditMode() {
        if (this.itemStack == null) {
            return;
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.ITEM)) {
            GuiScreen.func_73734_a((int)(this.area.x + this.padding), (int)(this.area.y + this.padding), (int)(this.area.x + 8 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistItemColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.WILDCARD)) {
            GuiScreen.func_73734_a((int)(this.area.x + 8 + this.padding), (int)(this.area.y + this.padding), (int)(this.area.x + 16 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistWildColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.MOD_ID)) {
            GuiScreen.func_73734_a((int)(this.area.x + this.padding), (int)(this.area.y + 8 + this.padding), (int)(this.area.x + 16 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistModColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public void drawHovered(Minecraft minecraft) {
        if (this.itemStack == null) {
            return;
        }
        this.renderSlow();
        this.renderOverlay(minecraft);
        this.drawHighlight();
    }

    public void drawHighlight() {
        if (this.itemStack == null) {
            return;
        }
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + this.area.width), (int)(this.area.y + this.area.height), (int)Integer.MAX_VALUE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    public void drawTooltip(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.itemStack == null) {
            return;
        }
        List<String> tooltip = GuiItemStackFast.getTooltip(minecraft, this.itemStack);
        FontRenderer fontRenderer = GuiItemStackFast.getFontRenderer(minecraft, this.itemStack);
        TooltipRenderer.drawHoveringText(this.itemStack, minecraft, tooltip, mouseX, mouseY, fontRenderer);
    }

    private static List<String> getTooltip(Minecraft minecraft, ItemStack itemStack) {
        Collection<String> colorNames;
        ColorNamer colorNamer;
        List list = itemStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, minecraft.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, itemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        int maxWidth = 125;
        for (String tooltipLine : list) {
            int width = minecraft.field_71466_p.func_78256_a(tooltipLine);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (Config.isColorSearchEnabled() && (colorNamer = Internal.getColorNamer()) != null && !(colorNames = colorNamer.getColorNames(itemStack)).isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            String colorNamesLocalizedString = TextFormatting.GRAY + Translator.translateToLocalFormatted("jei.tooltip.item.colors", colorNamesString);
            list.addAll(minecraft.field_71466_p.func_78271_c(colorNamesLocalizedString, maxWidth));
        }
        if (Config.isEditModeEnabled()) {
            String description;
            list.add("");
            list.add(TextFormatting.ITALIC + Translator.translateToLocal("gui.jei.editMode.description"));
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.ITEM)) {
                description = TextFormatting.YELLOW + Translator.translateToLocal("gui.jei.editMode.description.show");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = TextFormatting.YELLOW + Translator.translateToLocal("gui.jei.editMode.description.hide");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.WILDCARD)) {
                description = TextFormatting.RED + Translator.translateToLocal("gui.jei.editMode.description.show.wild");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = TextFormatting.RED + Translator.translateToLocal("gui.jei.editMode.description.hide.wild");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.MOD_ID)) {
                description = TextFormatting.BLUE + Translator.translateToLocal("gui.jei.editMode.description.show.mod.id");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = TextFormatting.BLUE + Translator.translateToLocal("gui.jei.editMode.description.hide.mod.id");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
        }
        return list;
    }
}

