/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipeClickableArea;
import mezz.jei.gui.RecipesGui;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.Commands;
import mezz.jei.util.MouseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputHandler {
    private final RecipeRegistry recipeRegistry;
    private final RecipesGui recipesGui;
    private final ItemListOverlay itemListOverlay;
    private MouseHelper mouseHelper;
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private boolean clickHandled = false;

    public InputHandler(RecipeRegistry recipeRegistry, RecipesGui recipesGui, ItemListOverlay itemListOverlay) {
        this.recipeRegistry = recipeRegistry;
        this.recipesGui = recipesGui;
        this.itemListOverlay = itemListOverlay;
        this.mouseHelper = new MouseHelper();
        this.showsRecipeFocuses.add(recipesGui);
        this.showsRecipeFocuses.add(itemListOverlay);
        this.showsRecipeFocuses.add(new GuiContainerWrapper());
    }

    public void onScreenResized() {
        this.mouseHelper = new MouseHelper();
    }

    public boolean handleMouseEvent(GuiScreen guiScreen, int mouseX, int mouseY) {
        boolean cancelEvent = false;
        if (Mouse.getEventButton() > -1) {
            if (Mouse.getEventButtonState()) {
                if (!this.clickHandled) {
                    this.clickHandled = cancelEvent = this.handleMouseClick(guiScreen, Mouse.getEventButton(), mouseX, mouseY);
                }
            } else if (this.clickHandled) {
                this.clickHandled = false;
                cancelEvent = true;
            }
        } else if (Mouse.getEventDWheel() != 0) {
            cancelEvent = this.handleMouseScroll(Mouse.getEventDWheel(), mouseX, mouseY);
        }
        return cancelEvent;
    }

    private boolean handleMouseScroll(int dWheel, int mouseX, int mouseY) {
        return this.itemListOverlay.handleMouseScrolled(mouseX, mouseY, dWheel);
    }

    private boolean handleMouseClick(GuiScreen guiScreen, int mouseButton, int mouseX, int mouseY) {
        GuiContainer guiContainer;
        RecipeClickableArea clickableArea;
        if (this.itemListOverlay.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        Focus<?> focus = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (focus != null && this.handleMouseClickedFocus(mouseButton, focus)) {
            return true;
        }
        if (guiScreen instanceof GuiContainer && (clickableArea = this.recipeRegistry.getRecipeClickableArea(guiContainer = (GuiContainer)guiScreen, mouseX - guiContainer.field_147003_i, mouseY - guiContainer.field_147009_r)) != null) {
            List<String> recipeCategoryUids = clickableArea.getRecipeCategoryUids();
            this.recipesGui.showCategories(recipeCategoryUids);
        }
        return false;
    }

    @Nullable
    private Focus<?> getFocusUnderMouseForClick(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus<?> focus;
            if (!gui.canSetFocusWithMouse() || (focus = gui.getFocusUnderMouse(mouseX, mouseY)) == null) continue;
            return focus;
        }
        return null;
    }

    @Nullable
    private IFocus<?> getFocusUnderMouseForKey(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus<?> focus = gui.getFocusUnderMouse(mouseX, mouseY);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    private boolean handleMouseClickedFocus(int mouseButton, Focus<?> focus) {
        Object focusValue;
        if (Config.isEditModeEnabled() && this.handleClickEditStack(mouseButton, focus)) {
            return true;
        }
        if (Config.isCheatItemsEnabled() && focus.allowsCheating() && !this.recipesGui.isOpen() && (focusValue = focus.getValue()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)focusValue;
            if (mouseButton == 0) {
                Commands.giveFullStack(itemStack);
                return true;
            }
            if (mouseButton == 1) {
                Commands.giveOneFromStack(itemStack);
                return true;
            }
        }
        if (mouseButton == 0) {
            this.recipesGui.showRecipes(focus);
            return true;
        }
        if (mouseButton == 1) {
            this.recipesGui.showUses(focus);
            return true;
        }
        return false;
    }

    private boolean handleClickEditStack(int mouseButton, IFocus<?> focus) {
        Object focusValue = focus.getValue();
        if (!(focusValue instanceof ItemStack)) {
            return false;
        }
        ItemStack itemStack = (ItemStack)focusValue;
        Config.ItemBlacklistType blacklistType = null;
        if (GuiScreen.func_146271_m()) {
            if (GuiScreen.func_146272_n()) {
                if (mouseButton == 0) {
                    blacklistType = Config.ItemBlacklistType.MOD_ID;
                }
            } else if (mouseButton == 0) {
                blacklistType = Config.ItemBlacklistType.ITEM;
            } else if (mouseButton == 1) {
                blacklistType = Config.ItemBlacklistType.WILDCARD;
            }
        }
        if (blacklistType == null) {
            return false;
        }
        if (Config.isItemOnConfigBlacklist(itemStack, blacklistType)) {
            Config.removeItemFromConfigBlacklist(itemStack, blacklistType);
        } else {
            Config.addItemToConfigBlacklist(itemStack, blacklistType);
        }
        return true;
    }

    public boolean handleKeyEvent() {
        char typedChar = Keyboard.getEventCharacter();
        int eventKey = Keyboard.getEventKey();
        if (eventKey == 0 && typedChar >= ' ' || Keyboard.getEventKeyState()) {
            return this.handleKeyDown(typedChar, eventKey);
        }
        return false;
    }

    private boolean handleKeyDown(char typedChar, int eventKey) {
        if (this.itemListOverlay.isOpen() && this.itemListOverlay.hasKeyboardFocus()) {
            if (InputHandler.isInventoryCloseKey(eventKey) || InputHandler.isEnterKey(eventKey)) {
                this.itemListOverlay.setKeyboardFocus(false);
                return true;
            }
            if (this.itemListOverlay.onKeyPressed(typedChar, eventKey)) {
                return true;
            }
        }
        if (KeyBindings.toggleOverlay.isActiveAndMatches(eventKey)) {
            Config.toggleOverlayEnabled();
            return false;
        }
        if (this.itemListOverlay.isOpen()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(eventKey)) {
                Config.toggleCheatItemsEnabled();
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(eventKey)) {
                this.itemListOverlay.setKeyboardFocus(true);
                return true;
            }
        }
        if (!this.isContainerTextFieldFocused()) {
            IFocus<?> focus;
            if (KeyBindings.showRecipe.isActiveAndMatches(eventKey)) {
                IFocus<?> focus2 = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY());
                if (focus2 != null) {
                    this.recipesGui.showRecipes(focus2);
                    return true;
                }
            } else if (KeyBindings.showUses.isActiveAndMatches(eventKey) && (focus = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY())) != null) {
                this.recipesGui.showUses(focus);
                return true;
            }
            if (this.itemListOverlay.isOpen() && this.itemListOverlay.onKeyPressed(typedChar, eventKey)) {
                return true;
            }
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        GuiTextField textField = null;
        if (gui instanceof GuiContainerCreative) {
            textField = ((GuiContainerCreative)gui).field_147062_A;
        } else if (gui instanceof GuiRepair) {
            textField = ((GuiRepair)gui).field_147091_w;
        }
        return textField != null && textField.func_146176_q() && textField.field_146226_p && textField.func_146206_l();
    }

    public static boolean isInventoryToggleKey(int keyCode) {
        return Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    public static boolean isInventoryCloseKey(int keyCode) {
        return keyCode == 1;
    }

    public static boolean isEnterKey(int keyCode) {
        return keyCode == 28;
    }
}

