/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.debug;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.JeiRuntime;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.plugins.jei.debug.DebugRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DebugRecipeCategory
extends BlankRecipeCategory<DebugRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 60;
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;

    public DebugRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.localizedName = "debug";
        ResourceLocation backgroundTexture = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 176, 0, 20, 55);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 176, 55, 12, 47);
    }

    @Override
    public String getUid() {
        return "debug";
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.tankBackground.draw(minecraft);
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null) {
            IItemListOverlay itemListOverlay = runtime.getItemListOverlay();
            minecraft.field_71466_p.func_78276_b(itemListOverlay.getFilterText(), 20, 52, 0);
            minecraft.field_71466_p.func_78276_b(String.valueOf(itemListOverlay.getStackUnderMouse()), 50, 52, 0);
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, DebugRecipe recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback(new ITooltipCallback<ItemStack>(){

            @Override
            public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
                if (input) {
                    tooltip.add(slotIndex + " Input itemStack");
                } else {
                    tooltip.add(slotIndex + " Output itemStack");
                }
            }
        });
        guiItemStacks.init(0, false, 70, 0);
        guiItemStacks.init(1, true, 110, 0);
        guiItemStacks.set(0, new ItemStack(Items.field_151131_as));
        guiItemStacks.set(1, new ItemStack(Items.field_151129_at));
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.addTooltipCallback(new ITooltipCallback<FluidStack>(){

            @Override
            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
                if (input) {
                    tooltip.add(slotIndex + " Input fluidStack");
                } else {
                    tooltip.add(slotIndex + " Output fluidStack");
                }
            }
        });
        guiFluidStacks.init(0, true, 4, 4, 12, 47, 2000, true, this.tankOverlay);
        guiFluidStacks.init(1, true, 24, 0, 12, 47, 16000, true, null);
        guiFluidStacks.init(2, false, 50, 0, 24, 24, 2000, true, this.tankOverlay);
        guiFluidStacks.init(3, false, 90, 0, 12, 47, 100, false, this.tankOverlay);
        List<FluidStack> fluidInputs = recipeWrapper.getFluidInputs();
        guiFluidStacks.set(0, fluidInputs.get(0));
        guiFluidStacks.set(1, fluidInputs.get(1));
        guiFluidStacks.set(3, fluidInputs.get(0));
    }
}

