/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import com.google.common.base.Objects;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.plugins.vanilla.VanillaRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class BrewingRecipeWrapper
extends VanillaRecipeWrapper {
    private final List<ItemStack> ingredients;
    private final ItemStack potionInput;
    private final ItemStack potionOutput;
    private final List<Object> inputs;
    private final int brewingSteps;
    private final int hashCode;

    public BrewingRecipeWrapper(ItemStack ingredient, ItemStack potionInput, ItemStack potionOutput, int brewingSteps) {
        this(Collections.singletonList(ingredient), potionInput, potionOutput, brewingSteps);
    }

    public BrewingRecipeWrapper(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput, int brewingSteps) {
        this.ingredients = ingredients;
        this.potionInput = potionInput;
        this.potionOutput = potionOutput;
        this.brewingSteps = brewingSteps;
        this.inputs = new ArrayList<Object>();
        this.inputs.add(potionInput);
        this.inputs.add(potionInput);
        this.inputs.add(potionInput);
        this.inputs.add(ingredients);
        ItemStack firstIngredient = ingredients.get(0);
        PotionType typeIn = PotionUtils.func_185191_c((ItemStack)potionInput);
        PotionType typeOut = PotionUtils.func_185191_c((ItemStack)potionOutput);
        this.hashCode = Objects.hashCode((Object[])new Object[]{potionInput.func_77973_b(), PotionType.func_185171_a((PotionType)typeIn), potionOutput.func_77973_b(), PotionType.func_185171_a((PotionType)typeOut), firstIngredient.func_77973_b(), firstIngredient.func_77960_j()});
    }

    @Override
    public List getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.potionOutput);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.brewingSteps > 0) {
            String steps = Translator.translateToLocalFormatted("gui.jei.category.brewing.steps", this.brewingSteps);
            minecraft.field_71466_p.func_78276_b(steps, 70, 28, Color.gray.getRGB());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrewingRecipeWrapper)) {
            return false;
        }
        BrewingRecipeWrapper other = (BrewingRecipeWrapper)obj;
        if (!BrewingRecipeWrapper.arePotionsEqual(other.potionInput, this.potionInput)) {
            return false;
        }
        if (!BrewingRecipeWrapper.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(ItemStack potion1, ItemStack potion2) {
        if (potion1.func_77973_b() != potion2.func_77973_b()) {
            return false;
        }
        PotionType type1 = PotionUtils.func_185191_c((ItemStack)potion1);
        PotionType type2 = PotionUtils.func_185191_c((ItemStack)potion2);
        return PotionType.func_185171_a((PotionType)type1) == PotionType.func_185171_a((PotionType)type2);
    }

    public int getBrewingSteps() {
        return this.brewingSteps;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        PotionType inputType = PotionUtils.func_185191_c((ItemStack)this.potionInput);
        PotionType outputType = PotionUtils.func_185191_c((ItemStack)this.potionOutput);
        return this.ingredients + " + [" + this.potionInput.func_77973_b() + " " + inputType.func_185174_b("") + "] = [" + this.potionOutput + " " + outputType.func_185174_b("") + "]";
    }
}

