/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.RecipeTransferHandlerHelper;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandler<C extends Container>
implements IRecipeTransferHandler<C> {
    private final IRecipeTransferInfo<C> transferHelper;

    public BasicRecipeTransferHandler(IRecipeTransferInfo<C> transferHelper) {
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<C> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public String getRecipeCategoryUid() {
        return this.transferHelper.getRecipeCategoryUid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        void var10_14;
        RecipeTransferHandlerHelper handlerHelper = Internal.getHelpers().recipeTransferHandlerHelper();
        StackHelper stackHelper = Internal.getStackHelper();
        if (!SessionData.isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.no.server");
            return handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(slot.field_75222_d, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        boolean bl = false;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++var10_14;
        }
        if (var10_14 > craftingSlots.size()) {
            Log.error("Recipe Transfer helper {} does not work for container {}", this.transferHelper.getClass(), container.getClass());
            return handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.func_75211_c();
            if (stack == null) continue;
            if (!slot.func_82869_a(player)) {
                Log.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), slot.field_75222_d);
                return handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (stack != null) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - var10_14 > emptySlotCount) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.inventory.full");
            return handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.missing");
            return handlerHelper.createUserErrorForSlots(message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, Integer> entry : matchingItemsResult.matchingItems.entrySet()) {
            ItemStack stack2;
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber < 0 || slotNumber >= ((Container)container).field_75151_b.size()) {
                Log.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), slotNumber, ((Container)container).field_75151_b.size());
                return handlerHelper.createInternalError();
            }
            Slot slot = container.func_75139_a(slotNumber);
            if (slot.func_75214_a(stack2 = container.func_75139_a(entry.getValue().intValue()).func_75211_c())) continue;
            Log.error("The ItemStack {} is not valid for the slot number {}", stack2, slotNumber);
            return handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        }
        return null;
    }
}

