/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.util.StackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandlerServer {
    public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        Container container = player.field_71070_bA;
        StackHelper stackHelper = Internal.getStackHelper();
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.func_75139_a(entry.getValue().intValue());
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null) {
                return;
            }
            ItemStack stack = itemStack.func_77946_l();
            stack.field_77994_a = 1;
            slotMap.put(entry.getKey(), stack);
        }
        int removedSets = BasicRecipeTransferHandlerServer.removeSetsFromInventory(container, slotMap.values(), craftingSlots, inventorySlots, maxTransfer);
        if (removedSets == 0) {
            return;
        }
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Integer n : craftingSlots) {
            Slot craftingSlot = container.func_75139_a(n.intValue());
            if (!craftingSlot.func_75216_d()) continue;
            ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            Integer craftNumber = (Integer)entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_77985_e()) {
                int maxStackSize = Math.min(slot.func_178170_b(stack), stack.func_77976_d());
                int maxSets = maxStackSize / stack.field_77994_a;
                stack.field_77994_a *= Math.min(maxSets, removedSets);
            }
            slot.func_75215_d(stack);
        }
        for (ItemStack itemStack : clearedCraftingItems) {
            stackHelper.addStack(container, inventorySlots, itemStack, true);
        }
        container.func_75142_b();
    }

    private static int removeSetsFromInventory(Container container, Collection<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        if (maxTransfer) {
            ArrayList<ItemStack> requiredCopy = new ArrayList<ItemStack>();
            requiredCopy.addAll(required);
            int removedSets = 0;
            while (!requiredCopy.isEmpty() && BasicRecipeTransferHandlerServer.removeSetsFromInventory(container, requiredCopy, craftingSlots, inventorySlots)) {
                ++removedSets;
                Iterator iterator = requiredCopy.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    if (stack.func_77985_e() && stack.field_77994_a * (removedSets + 1) <= stack.func_77976_d()) continue;
                    iterator.remove();
                }
            }
            return removedSets;
        }
        boolean success = BasicRecipeTransferHandlerServer.removeSetsFromInventory(container, required, craftingSlots, inventorySlots);
        return success ? 1 : 0;
    }

    private static boolean removeSetsFromInventory(Container container, Iterable<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
        for (ItemStack matchingStack : required) {
            ItemStack requiredStack = matchingStack.func_77946_l();
            while (requiredStack.field_77994_a > 0) {
                Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                if (slot == null || slot.func_75211_c() == null) {
                    for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                        ItemStack stack = (ItemStack)slotEntry.getValue();
                        ((Slot)slotEntry.getKey()).func_75215_d(stack);
                    }
                    return false;
                }
                if (!originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                }
                ItemStack removed = slot.func_75209_a(requiredStack.field_77994_a);
                requiredStack.field_77994_a -= removed.field_77994_a;
            }
        }
        return true;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        StackHelper stackHelper = Internal.getStackHelper();
        Slot slot = stackHelper.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = stackHelper.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }
}

