/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ErrorUtil {
    public static <T> String getInfoFromBrokenRecipe(T recipe, IRecipeHandler<T> recipeHandler) {
        List<String> itemStackIngredientsInfo;
        IRecipeWrapper recipeWrapper;
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        try {
            recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutput ItemStacks: ");
        try {
            List outputs = recipeWrapper.getOutputs();
            itemStackIngredientsInfo = ErrorUtil.getItemStackIngredientsInfo(outputs);
            recipeInfoBuilder.append(itemStackIngredientsInfo);
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nOutput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidOutputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput ItemStacks: ");
        try {
            List inputs = recipeWrapper.getInputs();
            itemStackIngredientsInfo = ErrorUtil.getItemStackIngredientsInfo(inputs);
            recipeInfoBuilder.append(itemStackIngredientsInfo);
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidInputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        return recipeInfoBuilder.toString();
    }

    @Nullable
    public static List<String> getItemStackIngredientsInfo(@Nullable List list) {
        if (list == null) {
            return null;
        }
        StackHelper stackHelper = Internal.getStackHelper();
        ArrayList<String> ingredientsInfo = new ArrayList<String>();
        for (Object ingredient : list) {
            ArrayList<String> ingredientInfo = new ArrayList<String>();
            List<ItemStack> stacks = stackHelper.toItemStackList(ingredient);
            String oreDict = stackHelper.getOreDictEquivalent(stacks);
            if (oreDict != null) {
                ingredientInfo.add("OreDict: " + oreDict);
            }
            for (ItemStack stack : stacks) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(stack);
                ingredientInfo.add(itemStackInfo);
            }
            ingredientsInfo.add(((Object)ingredientInfo).toString() + "\n");
        }
        return ingredientsInfo;
    }

    public static String getItemStackInfo(ItemStack itemStack) {
        String itemName;
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return itemStack.field_77994_a + "x (null)";
        }
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof ItemBlock) {
            ResourceLocation blockRegistryName;
            Block block = ((ItemBlock)item).func_179223_d();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "ItemBlock(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }
}

