/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IItemRegistry;
import mezz.jei.config.Config;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.color.ColorNamer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackElement {
    private final ItemStack itemStack;
    private final String searchString;
    private final String modNameString;
    private final String tooltipString;
    private final String oreDictString;
    private final String creativeTabsString;
    private final String colorString;

    @Nullable
    public static ItemStackElement create(ItemStack itemStack, IItemRegistry itemRegistry) {
        try {
            return new ItemStackElement(itemStack, itemRegistry);
        }
        catch (RuntimeException e) {
            try {
                String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.warning("Found a broken itemStack {}", itemStackInfo, e);
            }
            catch (RuntimeException e2) {
                Log.warning("Found a broken itemStack.", e2);
            }
            return null;
        }
    }

    private ItemStackElement(ItemStack itemStack, IItemRegistry itemRegistry) {
        String tooltipString;
        this.itemStack = itemStack;
        Item item = itemStack.func_77973_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new NullPointerException("No registry name for item. " + stackInfo);
        }
        String modId = itemResourceLocation.func_110624_b().toLowerCase(Locale.ENGLISH);
        String modName = itemRegistry.getModNameForModId(modId).toLowerCase(Locale.ENGLISH);
        String displayName = itemStack.func_82833_r();
        if (displayName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new NullPointerException("No display name for item. " + stackInfo);
        }
        displayName = displayName.toLowerCase();
        this.modNameString = modId + ' ' + modName;
        try {
            List tooltip = itemStack.func_82840_a((EntityPlayer)player, false);
            tooltipString = Joiner.on((char)' ').join((Iterable)tooltip).toLowerCase();
            tooltipString = TextFormatting.func_110646_a((String)tooltipString);
            if (tooltipString != null) {
                tooltipString = tooltipString.replace(modId, "");
                tooltipString = tooltipString.replace(modName, "");
                tooltipString = tooltipString.replace(displayName, "");
            }
        }
        catch (RuntimeException ignored) {
            tooltipString = "";
        }
        catch (LinkageError ignored) {
            tooltipString = "";
        }
        this.tooltipString = tooltipString;
        StringBuilder oreDictStringBuilder = new StringBuilder();
        for (int oreId : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            String oreName = OreDictionary.getOreName((int)oreId).toLowerCase(Locale.ENGLISH);
            oreDictStringBuilder.append(oreName).append(' ');
        }
        this.oreDictString = oreDictStringBuilder.toString();
        StringBuilder creativeTabStringBuilder = new StringBuilder();
        for (CreativeTabs creativeTab : item.getCreativeTabs()) {
            if (creativeTab == null) continue;
            String creativeTabName = I18n.func_135052_a((String)creativeTab.func_78024_c(), (Object[])new Object[0]).toLowerCase();
            creativeTabStringBuilder.append(creativeTabName).append(' ');
        }
        this.creativeTabsString = creativeTabStringBuilder.toString();
        this.colorString = Config.isColorSearchEnabled() ? ItemStackElement.getColorString(itemStack) : "";
        StringBuilder searchStringBuilder = new StringBuilder(displayName);
        if (!Config.isPrefixRequiredForModNameSearch()) {
            searchStringBuilder.append(' ').append(this.modNameString);
        }
        if (!Config.isPrefixRequiredForTooltipSearch()) {
            searchStringBuilder.append(' ').append(this.tooltipString);
        }
        if (!Config.isPrefixRequiredForOreDictSearch()) {
            searchStringBuilder.append(' ').append(this.oreDictString);
        }
        if (!Config.isPrefixRequiredForCreativeTabSearch()) {
            searchStringBuilder.append(' ').append(this.creativeTabsString);
        }
        if (!Config.isPrefixRequiredForColorSearch()) {
            searchStringBuilder.append(' ').append(this.colorString);
        }
        this.searchString = searchStringBuilder.toString();
    }

    private static String getColorString(ItemStack itemStack) {
        ColorNamer colorNamer = Internal.getColorNamer();
        if (colorNamer == null) {
            return "";
        }
        Collection<String> colorNames = colorNamer.getColorNames(itemStack);
        return Joiner.on((char)' ').join(colorNames).toLowerCase();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getModNameString() {
        return this.modNameString;
    }

    public String getTooltipString() {
        return this.tooltipString;
    }

    public String getOreDictString() {
        return this.oreDictString;
    }

    public String getCreativeTabsString() {
        return this.creativeTabsString;
    }

    public String getColorString() {
        return this.colorString;
    }
}

