/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.text.WordUtils;

public class ModList {
    private final Map<String, String> modNamesForIds = new HashMap<String, String>();

    public ModList() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            this.modNamesForIds.put(lowercaseId, modName);
        }
    }

    public String getModNameForItem(Item item) {
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(new ItemStack(item));
            throw new NullPointerException("item.getRegistryName() returned null for: " + stackInfo);
        }
        String modId = itemResourceLocation.func_110624_b();
        return this.getModNameForModId(modId);
    }

    public String getModNameForModId(String modId) {
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = this.modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            this.modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }
}

