/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.betterfps.transformers;

import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import me.guichaguri.betterfps.BetterFpsHelper;
import me.guichaguri.betterfps.tweaker.Naming;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class MathTransformer
implements IClassTransformer {
    public byte[] transform(String name, String name2, byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        try {
            if (Naming.C_MathHelper.is(name)) {
                return this.patchMath(bytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    private byte[] patchMath(byte[] bytes) throws Exception {
        ClassReader reader;
        if (BetterFpsHelper.CONFIG == null) {
            BetterFpsHelper.loadConfig();
        }
        if (BetterFpsHelper.ALGORITHM_NAME.equals("vanilla")) {
            LogManager.getLogger((String)"BetterFps").info("Letting Minecraft use " + BetterFpsHelper.displayHelpers.get(BetterFpsHelper.ALGORITHM_NAME));
            return bytes;
        }
        LogManager.getLogger((String)"BetterFps").info("Patching Minecraft using " + BetterFpsHelper.displayHelpers.get(BetterFpsHelper.ALGORITHM_NAME));
        if (BetterFpsHelper.LOC == null) {
            reader = new ClassReader("me.guichaguri.betterfps.math." + BetterFpsHelper.ALGORITHM_CLASS);
        } else {
            JarFile jar = new JarFile(BetterFpsHelper.LOC);
            ZipEntry e = jar.getEntry("me/guichaguri/betterfps/math/" + BetterFpsHelper.ALGORITHM_CLASS + ".class");
            reader = new ClassReader(jar.getInputStream(e));
            jar.close();
        }
        ClassNode mathnode = new ClassNode();
        reader.accept((ClassVisitor)mathnode, 0);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String className = classNode.name;
        String mathClass = mathnode.name;
        this.patchInit(classNode, mathnode, className, mathClass);
        Iterator methods = classNode.methods.iterator();
        boolean patched = false;
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (Naming.M_sin.is(method.name, method.desc)) {
                this.patchSin(method, mathnode, className, mathClass);
                patched = true;
                continue;
            }
            if (!Naming.M_cos.is(method.name, method.desc)) continue;
            this.patchCos(method, mathnode, className, mathClass);
            patched = true;
        }
        if (!patched) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void patchInit(ClassNode classNode, ClassNode math, String name, String oldName) {
        for (Object field : math.fields) {
            classNode.fields.add(field);
        }
        Object mathClinit = null;
        for (Object m : math.methods) {
            if (!((MethodNode)m).name.equals("<clinit>")) continue;
            mathClinit = m;
            break;
        }
        if (mathClinit != null) {
            MethodNode clinit = null;
            for (MethodNode m : classNode.methods) {
                if (!m.name.equals("<clinit>")) continue;
                clinit = m;
                break;
            }
            if (clinit == null) {
                clinit = new MethodNode(8, "<clinit>", "()V", null, null);
            }
            InsnList list = new InsnList();
            for (AbstractInsnNode node : ((MethodNode)mathClinit).instructions.toArray()) {
                if (node instanceof FieldInsnNode) {
                    FieldInsnNode field = (FieldInsnNode)node;
                    if (field.owner.equals(oldName)) {
                        field.owner = name;
                    }
                } else if (node.getOpcode() == 177) continue;
                list.add(node);
            }
            list.add(clinit.instructions);
            clinit.instructions.clear();
            clinit.instructions.add(list);
            classNode.methods.remove(clinit);
            classNode.methods.add(clinit);
        }
    }

    private void patchSin(MethodNode method, ClassNode math, String name, String oldName) {
        method.instructions.clear();
        for (MethodNode original : math.methods) {
            if (!original.name.equals("sin")) continue;
            method.instructions.add(original.instructions);
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(oldName)) continue;
                field.owner = name;
            }
        }
    }

    private void patchCos(MethodNode method, ClassNode math, String name, String oldName) {
        method.instructions.clear();
        for (MethodNode original : math.methods) {
            if (!original.name.equals("cos")) continue;
            method.instructions.add(original.instructions);
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(oldName)) continue;
                field.owner = name;
            }
        }
    }
}

