/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jeresources.api.restrictions.BlockRestriction;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class DimensionRegistry {
    private static Map<BlockRestriction, Set<Integer>> registry = new HashMap<BlockRestriction, Set<Integer>>();
    private static Map<Integer, DimInfo> altDimensions = new TreeMap<Integer, DimInfo>();

    public static void registerDimension(BlockRestriction block, int dim) {
        DimensionRegistry.registerDimension(block, dim, false);
    }

    public static void registerDimension(BlockRestriction block, int dim, boolean mystAge) {
        Set<Integer> saved = registry.get(block);
        if (saved == null) {
            saved = new TreeSet<Integer>();
        }
        saved.add(dim);
        altDimensions.put(dim, new DimInfo(dim, mystAge));
        registry.put(block, saved);
    }

    public static void registerDimension(BlockRestriction block, Integer ... dims) {
        DimensionRegistry.registerDimension(block, Arrays.asList(dims));
    }

    public static void registerDimension(BlockRestriction block, List<Integer> dims) {
        Set<Integer> saved = registry.get(block);
        if (saved == null) {
            saved = new TreeSet<Integer>();
        }
        saved.addAll(dims);
        for (Integer dim : dims) {
            altDimensions.put(dim, new DimInfo((int)dim));
        }
        registry.put(block, saved);
    }

    public static Set<Integer> getDimensions(BlockRestriction block) {
        if (registry.containsKey(block)) {
            return registry.get(block);
        }
        return null;
    }

    public static Set<Integer> getAltDimensions() {
        return altDimensions.keySet();
    }

    public static String getDimensionName(int dim) {
        return DimensionRegistry.altDimensions.get(dim).getName();
    }

    public static boolean contains(int dimId) {
        return altDimensions.containsKey(dimId);
    }

    static {
        DimensionRegistry.registerDimension(BlockRestriction.NETHER, -1);
        DimensionRegistry.registerDimension(BlockRestriction.STONE, 0);
        DimensionRegistry.registerDimension(BlockRestriction.END, 1);
    }

    private static class DimInfo {
        private int dimId;
        private String name;
        private boolean age;

        private DimInfo(int id) {
            this(id, false);
        }

        private DimInfo(int id, boolean age) {
            this(id, null, age);
        }

        private DimInfo(int id, String name, boolean age) {
            this.dimId = id;
            this.name = name;
            this.age = age;
        }

        private String getName() {
            if (this.name == null) {
                WorldProvider worldProvider = DimInfo.getWorldProvider(this.dimId);
                if (worldProvider != null) {
                    this.name = worldProvider.func_186058_p().func_186065_b();
                    if (this.age && !this.name.startsWith("Age")) {
                        this.name = this.name + " (Age)";
                    }
                } else {
                    this.name = String.valueOf("Dimension ID " + this.dimId);
                }
            }
            return this.name;
        }

        private static WorldProvider getWorldProvider(int dimId) {
            WorldProvider worldProvider = null;
            if (DimensionManager.isDimensionRegistered((int)dimId)) {
                worldProvider = DimensionManager.getWorld((int)dimId) != null ? DimensionManager.getProvider((int)dimId) : DimensionManager.createProviderFor((int)dimId);
            }
            return worldProvider;
        }
    }
}

