/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeresources.api.restrictions.BlockRestriction;
import jeresources.api.restrictions.DimensionRegistry;
import jeresources.api.restrictions.Type;
import net.minecraft.util.text.translation.I18n;

public class DimensionRestriction {
    public static final DimensionRestriction OVERWORLD = new DimensionRestriction(0);
    public static final DimensionRestriction NETHER = new DimensionRestriction(-1);
    public static final DimensionRestriction END = new DimensionRestriction(1);
    public static final DimensionRestriction NONE = new DimensionRestriction();
    private int min;
    private int max;
    private Type type;

    public DimensionRestriction() {
        this.type = Type.NONE;
    }

    public DimensionRestriction(int dim) {
        this(dim, dim);
    }

    public DimensionRestriction(Type type, int dim) {
        this(type, dim, dim);
    }

    public DimensionRestriction(int minDim, int maxDim) {
        this(Type.WHITELIST, minDim, maxDim);
    }

    public DimensionRestriction(Type type, int minDim, int maxDim) {
        this.type = type;
        this.min = Math.min(minDim, maxDim);
        this.max = Math.max(maxDim, minDim);
    }

    public List<String> getValidDimensions(BlockRestriction blockRestriction) {
        Set<Integer> dimensions = DimensionRegistry.getDimensions(blockRestriction);
        if (dimensions != null) {
            return this.getDimensionString(dimensions);
        }
        return this.getAltDimensionString(DimensionRegistry.getAltDimensions());
    }

    private Set<Integer> getValidDimensions(Set<Integer> dimensions) {
        if (this.type == Type.NONE) {
            return dimensions;
        }
        return dimensions.stream().filter(dimension -> dimension >= this.min == (this.type == Type.WHITELIST) == dimension <= this.max).collect(Collectors.toCollection(TreeSet::new));
    }

    private List<String> getDimensionString(Set<Integer> dimensions) {
        return this.getStringList(this.getValidDimensions(dimensions));
    }

    private List<String> getStringList(Set<Integer> set) {
        ArrayList<String> result = new ArrayList<String>();
        for (Integer i : set) {
            String dimName = DimensionRegistry.getDimensionName(i);
            if (dimName == null) continue;
            result.add("  " + dimName);
        }
        return result;
    }

    private List<String> getAltDimensionString(Set<Integer> dimensions) {
        TreeSet<Integer> validDimensions = new TreeSet<Integer>();
        int dimMin = Integer.MAX_VALUE;
        int dimMax = Integer.MIN_VALUE;
        for (Integer dim : dimensions) {
            if (dim < dimMin) {
                dimMin = dim;
            }
            if (dim <= dimMax) continue;
            dimMax = dim;
        }
        for (int i = Math.min(this.min, dimMin) - 1; i <= Math.max(this.max, dimMax) + 1; ++i) {
            if (dimensions.contains(i)) continue;
            validDimensions.add(i);
        }
        List<String> result = this.getStringList(this.getValidDimensions(this.type != Type.NONE ? validDimensions : dimensions));
        if (result.isEmpty()) {
            result.add(I18n.func_74838_a((String)"ner.dim.no"));
        }
        switch (this.type) {
            default: {
                break;
            }
            case NONE: {
                result.add(0, I18n.func_74838_a((String)"ner.not"));
                break;
            }
            case BLACKLIST: {
                result.add(0, "<=");
                result.add(result.size(), "=<");
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionRestriction) {
            DimensionRestriction other = (DimensionRestriction)obj;
            return other.min == this.min && other.max == this.max && other.type == this.type;
        }
        return false;
    }

    public boolean isMergeable(DimensionRestriction other) {
        if (other.type == Type.NONE) {
            return true;
        }
        int dimMin = Math.min(this.min, other.min) - 1;
        int dimMax = Math.max(this.max, other.max) + 1;
        TreeSet<Integer> testDimensions = new TreeSet<Integer>();
        for (int dim = dimMin; dim <= dimMax; ++dim) {
            testDimensions.add(dim);
        }
        Set<Integer> thisValidDimensions = this.getValidDimensions(testDimensions);
        Set<Integer> otherValidDimensions = other.getValidDimensions(testDimensions);
        return otherValidDimensions.containsAll(thisValidDimensions);
    }

    public String toString() {
        return "Dimension: " + (Object)((Object)this.type) + (this.type != Type.NONE ? " " + this.min + "-" + this.max : "");
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.min ^ this.max;
    }
}

