/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.List;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.BlockRestriction;
import jeresources.api.restrictions.DimensionRestriction;

public class Restriction {
    public static final Restriction OVERWORLD_LIKE = new Restriction();
    public static final Restriction NETHER_LIKE = new Restriction(BlockRestriction.NETHER);
    public static final Restriction END_LIKE = new Restriction(BlockRestriction.END);
    public static final Restriction OVERWORLD = new Restriction(DimensionRestriction.OVERWORLD);
    public static final Restriction NETHER = new Restriction(BlockRestriction.NETHER, DimensionRestriction.NETHER);
    public static final Restriction END = new Restriction(BlockRestriction.END, DimensionRestriction.END);
    private BlockRestriction blockRestriction;
    private BiomeRestriction biomeRestriction;
    private DimensionRestriction dimensionRestriction;

    public Restriction() {
        this(BiomeRestriction.NONE);
    }

    public Restriction(BlockRestriction blockRestriction) {
        this(blockRestriction, BiomeRestriction.NONE, DimensionRestriction.NONE);
    }

    public Restriction(BiomeRestriction biomeRestriction) {
        this(BlockRestriction.STONE, biomeRestriction, DimensionRestriction.NONE);
    }

    public Restriction(DimensionRestriction dimensionRestriction) {
        this(BlockRestriction.STONE, BiomeRestriction.NONE, dimensionRestriction);
    }

    public Restriction(BlockRestriction blockRestriction, BiomeRestriction biomeRestriction) {
        this(blockRestriction, biomeRestriction, DimensionRestriction.NONE);
    }

    public Restriction(BlockRestriction blockRestriction, DimensionRestriction dimensionRestriction) {
        this(blockRestriction, BiomeRestriction.NONE, dimensionRestriction);
    }

    public Restriction(BiomeRestriction biomeRestriction, DimensionRestriction dimensionRestriction) {
        this(BlockRestriction.STONE, biomeRestriction, dimensionRestriction);
    }

    public Restriction(BlockRestriction blockRestriction, BiomeRestriction biomeRestriction, DimensionRestriction dimensionRestriction) {
        this.blockRestriction = blockRestriction;
        this.biomeRestriction = biomeRestriction;
        this.dimensionRestriction = dimensionRestriction;
    }

    public List<String> getBiomeRestrictions() {
        return this.biomeRestriction.toStringList();
    }

    public List<String> getDimensionRestrictions() {
        return this.dimensionRestriction.getValidDimensions(this.blockRestriction);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Restriction)) {
            return false;
        }
        Restriction other = (Restriction)obj;
        if (!other.biomeRestriction.equals(this.biomeRestriction)) {
            return false;
        }
        if (!other.blockRestriction.equals(this.blockRestriction)) {
            return false;
        }
        return other.dimensionRestriction.equals(this.dimensionRestriction);
    }

    public boolean isMergeable(Restriction restriction) {
        if (!this.biomeRestriction.isMergeAble(restriction.biomeRestriction)) {
            return false;
        }
        if (!this.blockRestriction.equals(restriction.blockRestriction)) {
            return false;
        }
        return this.dimensionRestriction.isMergeable(restriction.dimensionRestriction);
    }

    public String toString() {
        return this.blockRestriction.toString() + ", " + this.dimensionRestriction.toString() + ", " + this.biomeRestriction.toString();
    }

    public int hashCode() {
        return this.blockRestriction.hashCode() ^ this.dimensionRestriction.hashCode() ^ this.biomeRestriction.hashCode();
    }
}

