/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.CompatBase;
import jeresources.entry.MobEntry;
import jeresources.registry.MobRegistry;
import jeresources.util.LootTableHelper;
import jeresources.util.ReflectionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class MobRegistryImpl
implements IMobRegistry {
    private static Map<MobEntry, ResourceLocation> rawRegisters = new HashMap<MobEntry, ResourceLocation>();
    private static Map<Class<? extends EntityLivingBase>, List<IMobRenderHook>> renderHooks = new HashMap<Class<? extends EntityLivingBase>, List<IMobRenderHook>>();
    private static Map<String, List<IScissorHook>> scissorHooks = new HashMap<String, List<IScissorHook>>();

    protected MobRegistryImpl() {
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, int minExp, int maxExp, String[] biomes, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, minExp, maxExp, biomes, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, int minExp, int maxExp, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, minExp, maxExp, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, int exp, String[] biomes, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, exp, biomes, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, int exp, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, exp, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, String[] biomes, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, biomes, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, LightLevel lightLevel, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity, lightLevel, new LootDrop[0]), lootTable);
    }

    @Override
    public void register(EntityLivingBase entity, ResourceLocation lootTable) {
        rawRegisters.put(new MobEntry(entity), lootTable);
    }

    @Override
    public void registerRenderHook(Class<? extends EntityLivingBase> entity, IMobRenderHook renderHook) {
        List<IMobRenderHook> list = renderHooks.get(entity);
        if (list == null) {
            list = new ArrayList<IMobRenderHook>();
        }
        list.add(renderHook);
        renderHooks.put(entity, list);
    }

    @Override
    public void registerScissorHook(Class caller, IScissorHook scissorHook) {
        List<IScissorHook> list = scissorHooks.get(caller.getName());
        if (list == null) {
            list = new ArrayList<IScissorHook>();
        }
        list.add(scissorHook);
        scissorHooks.put(caller.getName(), list);
    }

    public static IMobRenderHook.RenderInfo applyRenderHooks(EntityLivingBase entity, IMobRenderHook.RenderInfo renderInfo) {
        for (Map.Entry<Class<? extends EntityLivingBase>, List<IMobRenderHook>> entry : renderHooks.entrySet()) {
            if (!ReflectionHelper.isInstanceOf(entity.getClass(), entry.getKey())) continue;
            for (IMobRenderHook renderHook : entry.getValue()) {
                renderInfo = renderHook.transform(renderInfo, entity);
            }
        }
        return renderInfo;
    }

    public static IScissorHook.ScissorInfo applyScissorHooks(IScissorHook.ScissorInfo scissorInfo) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int depth = 0;
        for (StackTraceElement element : stack) {
            if (scissorHooks.containsKey(element.getClassName())) {
                for (IScissorHook scissorHook : scissorHooks.get(element.getClassName())) {
                    scissorInfo = scissorHook.transformScissor(scissorInfo);
                }
                break;
            }
            if (depth++ > 10) break;
        }
        return scissorInfo;
    }

    protected static void commit() {
        rawRegisters.entrySet().forEach(entry -> ((MobEntry)entry.getKey()).addDrops(LootTableHelper.toDrops(CompatBase.getWorld(), (ResourceLocation)entry.getValue())));
        rawRegisters.keySet().forEach(MobRegistry.getInstance()::registerMob);
        rawRegisters.clear();
    }
}

