/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeresources.api.drop.LootDrop;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LootTableHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTable;

public class DungeonEntry {
    private Set<LootDrop> drops = new HashSet<LootDrop>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public DungeonEntry(String name, LootTable lootTable) {
        this.name = name;
        float[] tmpMinStacks = new float[]{0.0f};
        float[] tmpMaxStacks = new float[]{0.0f};
        LootTableHelper.getPools(lootTable).forEach(pool -> {
            fArray[0] = tmpMinStacks[0] + pool.getRolls().func_186509_a();
            fArray2[0] = tmpMaxStacks[0] + (pool.getRolls().func_186512_b() + pool.getBonusRolls().func_186512_b());
            float totalWeight = LootTableHelper.getEntries(pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            LootTableHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryItem).map(entry -> (LootEntryItem)entry).map(entry -> new LootDrop(LootTableHelper.getItem(entry), (float)entry.func_186361_a(0.0f) / totalWeight, LootTableHelper.getFunctions(entry))).forEach(this.drops::add);
        });
        this.drops = new TreeSet<LootDrop>(this.drops);
        this.minStacks = MathHelper.func_76141_d((float)tmpMinStacks[0]);
        this.maxStacks = MathHelper.func_76141_d((float)tmpMaxStacks[0]);
    }

    public boolean containsItem(ItemStack itemStack) {
        return this.drops.stream().anyMatch(drop -> drop.item.func_77969_a(itemStack));
    }

    public String getName() {
        String name = DungeonRegistry.categoryToLocalKeyMap.get(this.name);
        return name == null ? this.name : name;
    }

    public List<ItemStack> getItemStacks() {
        return this.drops.stream().map(drop -> drop.item).collect(Collectors.toList());
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public LootDrop getChestDrop(ItemStack ingredient) {
        return this.drops.stream().filter(drop -> ItemStack.func_179545_c((ItemStack)drop.item, (ItemStack)ingredient)).findFirst().orElse(null);
    }
}

