/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.collection.TradeList;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;

public class VillagerEntry {
    private final List<TradeList> tradeList;
    private final int profession;
    private final int career;
    private final String name;

    public VillagerEntry(String name, int profession, int career, List<List<EntityVillager.ITradeList>> tradesLists) {
        this.name = name;
        this.profession = profession;
        this.career = career;
        this.tradeList = new LinkedList<TradeList>();
        this.addITradeLists(tradesLists);
    }

    public void addITradeLists(List<List<EntityVillager.ITradeList>> tradesLists) {
        int i = 0;
        for (List<EntityVillager.ITradeList> levelList : tradesLists) {
            TradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new TradeList(this);
            levelList.forEach(trades::addITradeList);
            this.tradeList.add(trades);
            ++i;
        }
    }

    public TradeList getVillagerTrades(int level) {
        return this.tradeList.get(level);
    }

    public List<ItemStack> getInputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            for (TradeList.Trade trade : list2) {
                list.add(trade.getMinBuyStack1());
                list.add(trade.getMinBuyStack2());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(TradeList.Trade::getMinSellStack).collect(Collectors.toList()));
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public int getCareer() {
        return this.career;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return "entity.Villager." + this.name;
    }

    public int getProfession() {
        return this.profession;
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }
}

