/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei;

import javax.annotation.Nonnull;
import jeresources.JEResources;
import jeresources.jei.dungeon.DungeonCategory;
import jeresources.jei.dungeon.DungeonHandler;
import jeresources.jei.enchantment.EnchantmentCategory;
import jeresources.jei.enchantment.EnchantmentHandler;
import jeresources.jei.enchantment.EnchantmentMaker;
import jeresources.jei.mob.MobCategory;
import jeresources.jei.mob.MobHandler;
import jeresources.jei.plant.PlantCategory;
import jeresources.jei.plant.PlantHandler;
import jeresources.jei.villager.VillagerCategory;
import jeresources.jei.villager.VillagerHandler;
import jeresources.jei.worldgen.WorldGenCategory;
import jeresources.jei.worldgen.WorldGenHandler;
import jeresources.registry.DungeonRegistry;
import jeresources.registry.MobRegistry;
import jeresources.registry.PlantRegistry;
import jeresources.registry.VillagerRegistry;
import jeresources.registry.WorldGenRegistry;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;

@JEIPlugin
public class JEIConfig
extends BlankModPlugin {
    public static final String MOB = "jeresources.mob";
    public static final String DUNGEON = "jeresources.dungeon";
    public static final String WORLD_GEN = "jeresources.worldgen";
    public static final String PLANT = "jeresources.plant";
    public static final String ENCHANTMENT = "jeresources.enchantment";
    public static final String VILLAGER = "jeresources.villager";
    private static IJeiHelpers jeiHelpers;

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeHandlers(new IRecipeHandler[]{new PlantHandler(), new WorldGenHandler(), new MobHandler(), new EnchantmentHandler(), new DungeonHandler(), new VillagerHandler()});
        registry.addRecipeCategories(new IRecipeCategory[]{new PlantCategory(), new WorldGenCategory(), new MobCategory(), new EnchantmentCategory(), new DungeonCategory(), new VillagerCategory()});
        JEResources.PROXY.initCompatibility();
        registry.addRecipes(WorldGenRegistry.getInstance().getWorldGen());
        registry.addRecipes(PlantRegistry.getInstance().getAllPlants());
        registry.addRecipes(MobRegistry.getInstance().getMobs());
        registry.addRecipes(DungeonRegistry.getInstance().getDungeons());
        registry.addRecipes(VillagerRegistry.getInstance().getVillagers());
        registry.addRecipes(EnchantmentMaker.createRecipes(registry.getItemRegistry()));
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }
}

