/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import javax.annotation.Nonnull;
import jeresources.config.Settings;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.reference.Resources;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;

public class DungeonCategory
extends BlankRecipeCategory {
    protected static final int Y_FIRST_ITEM = 44;
    protected static final int X_FIRST_ITEM = 6;
    protected static int SPACING_Y;
    protected static int SPACING_X;
    protected static int ITEMS_PER_PAGE;

    public static void reloadSettings() {
        ITEMS_PER_PAGE = Settings.ITEMS_PER_COLUMN * Settings.ITEMS_PER_ROW * 2;
        SPACING_X = 166 / (Settings.ITEMS_PER_ROW * 2);
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
    }

    @Nonnull
    public String getUid() {
        return "jeresources.dungeon";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.dungeon.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.DUNGEON;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        int x = 6;
        int y = 44;
        for (int i = 0; i < Math.min(ITEMS_PER_PAGE, recipeWrapper.getOutputs().size()); ++i) {
            recipeLayout.getItemStacks().init(i, false, x, y);
            if ((x += SPACING_X) < 6 + SPACING_X * Settings.ITEMS_PER_ROW * 2) continue;
            x = 6;
            y += SPACING_Y;
        }
        if (recipeWrapper instanceof DungeonWrapper) {
            DungeonWrapper dungeonWrapper = (DungeonWrapper)recipeWrapper;
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)dungeonWrapper);
            int slots = Math.min(dungeonWrapper.amountOfItems(), ITEMS_PER_PAGE);
            for (int i = 0; i < slots; ++i) {
                recipeLayout.getItemStacks().set(i, dungeonWrapper.getItems(i, slots));
            }
            dungeonWrapper.resetLid();
        }
    }
}

