/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import java.util.List;
import javax.annotation.Nonnull;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class DungeonWrapper
extends BlankRecipeWrapper
implements ITooltipCallback<ItemStack> {
    public DungeonEntry chest;
    private boolean done;
    private int lidStart;

    public DungeonWrapper(DungeonEntry chest) {
        this.chest = chest;
    }

    @Nonnull
    public List getOutputs() {
        return this.chest.getItemStacks();
    }

    public int amountOfItems() {
        return this.chest.getItemStacks().size();
    }

    public List<ItemStack> getItems(int slot, int slots) {
        List<ItemStack> list = this.chest.getItemStacks().subList(slot, slot + 1);
        for (int n = 1; n < this.amountOfItems() / slots + 1; ++n) {
            list.add(this.amountOfItems() <= slot + slots * n ? null : this.chest.getItemStacks().get(slot + slots * n));
        }
        return list;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        Font.normal.print(TranslationHelper.translateToLocal(this.chest.getName()), 60, 7);
        Font.small.print(DungeonRegistry.getInstance().getNumStacks(this.chest), 60, 20);
    }

    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        RenderHelper.renderChest(15.0f, 20.0f, -40.0f, 20.0f, this.getLidAngle());
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        tooltip.add(this.chest.getChestDrop(ingredient).toString());
    }

    private float getLidAngle() {
        float angle = ((int)System.currentTimeMillis() / 100 - this.lidStart) % 80;
        if (angle > 50.0f || this.done) {
            this.done = true;
            angle = 50.0f;
        }
        return angle;
    }

    public void resetLid() {
        this.lidStart = (int)System.currentTimeMillis() / 100;
    }
}

